#!/bin/sh

# Copyright (c) 2003 Asim Jalis
# 
# THIS SOFTWARE IS PROVIDED 'AS IS', WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTY. IN NO EVENT WILL THE AUTHORS BE HELD LIABLE FOR ANY DAMAGES
# ARISING FROM THE USE OF THIS SOFTWARE.
# 
# Permission is granted to anyone to use this software for any purpose,
# including commercial applications, and to alter it and redistribute it
# freely, subject to the following restrictions:
# 
# 1. The origin of this software must not be misrepresented; you must not
# claim that you wrote the original software. If you use this software in
# a product, an acknowledgment in the product documentation would be
# appreciated but is not required.
# 
# 2. Altered source versions must be plainly marked as such, and must not
# be misrepresented as being the original software.
# 
# 3. This notice may not be removed or altered from any source
# distribution.

# Auto generate single AllTests file by searching through all C source files
# in the current directory. Sends the resulting code to stdout.

if test $# -eq 0 ; then FILES=`ls *.c *.cc *.cpp 2>/dev/null` ; else FILES=$* ; fi

echo '

/* Do not edit this code directly. It has been auto-generated by CuTest.sh */

#include "CuTest.h"
#include <stdio.h>

'

cat $FILES | grep '^TEST_FUNCTION Test' | 
    sed -e 's/(.*$//' \
        -e 's/$/(CuTest*);/' \
        -e 's/^/extern /'

echo \
'

void RunAllTests(void) 
{
    CuString *output = CuStringNew();
    CuSuite* suite = CuSuiteNew();

'
cat $FILES | grep '^TEST_FUNCTION Test' | 
    sed -e 's/^void //' \
        -e 's/^TEST_FUNCTION //' \
        -e 's/(.*$//' \
        -e 's/^/    SUITE_ADD_TEST(suite, /' \
        -e 's/$/);/'

echo \
'
    CuSuiteRun(suite);
    CuSuiteSummary(suite, output);
    CuSuiteDetails(suite, output);
    printf("%s\n", output->buffer);
}

int main(void)
{
    RunAllTests();
    return 0;
}
'
