# gozerbot/exit.py
#
#

""" gozerbot's finaliser """

__copyright__ = 'this file is in the public domain'

# ==============
# IMPORT SECTION


# gozerbot imports
from utils.log import rlog
from utils.trace import whichmodule
from eventhandler import mainhandler
from plugins import plugins
from fleet import fleet
from persist.persist import saving
from runner import runners_stop
from gozerbot.config import config

# basic imports
import atexit, os, time, sys

# END IMPORT
# ==========

# ============
# LOCK SECTION

# no locks

# END LOCK
# ========

def globalshutdown():

    """
        shutdown the bot.

        .. literalinclude:: ../../gozerbot/exit.py
            :pyobject: globalshutdown

    """

    rlog(10, 'GOZERBOT', 'SHUTTING DOWN')

    try:
        os.remove('gozerbot.pid')
    except:
        pass

    try:
        runners_stop()
        rlog(10, 'gozerbot', 'shutting down fleet')
        fleet.exit()
        rlog(10, 'gozerbot', 'shutting down plugins')
        plugins.exit()
        rlog(10, 'GOZERBOT', 'done')
        os._exit(0)

    except Exception, ex:
        rlog(10, 'gozerbot.exit', 'exit error %s:' % str(ex))

# ============
# INIT SECTION

# register shutdown function
#atexit.register(globalshutdown)

# END INIT
# ========
