/*
 * Copyright 2011 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.gradle.integtests.openapi;

import org.gradle.openapi.external.ui.CommandLineArgumentAlteringListenerVersion1;

import java.io.File;

public class ExtraTestCommandLineOptionsListener implements CommandLineArgumentAlteringListenerVersion1 {
    private final File gradleUserHomeDir;

    public ExtraTestCommandLineOptionsListener(File gradleUserHomeDir) {
        this.gradleUserHomeDir = gradleUserHomeDir;
    }

    public String getAdditionalCommandLineArguments(String commandLineArguments) {
        return String.format("--no-search-upward --gradle-user-home \'%s\'", gradleUserHomeDir);
    }
}
