//*****************************************************************************
//                              CmdGnuCapOP.hpp                               *
//                             -----------------                              *
// Description : This class contains values associated with the GNU-Cap       *
//               OP (Operating Point) command. It inherits from the class     *
//               CmdBase.                                                     *
// Started     : 05/03/2008                                                   *
// Last Update : 24/12/2010                                                   *
// Copyright   : (C) 2008 by M.S.Waters                                       *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef CMDGCPOP_HPP
#define CMDGCPOP_HPP

// System Includes

using  namespace  std;

#include <iostream>
#include <climits>

// wxWidgets Includes

#include <wx/wx.h>
#include <wx/tokenzr.h>

// Application Includes

#include "base/CmdBase.hpp"
#include "ngspice/commands/CmdNgSpiceDC.hpp"
#include "utility/ConvertType.hpp"

struct CmdNgSpiceDC;

// Local Macro and Constant Declarations

//*****************************************************************************

struct CmdGnuCapOP : public CmdBase
{
  private :

    virtual  bool  bValidate( void );

  public :

    wxString    m_osStart;  // Sweep start value
    wxString    m_osStop;   // Sweep stop  value
    wxString    m_osStep;   // Sweep step  value
    eScaleType  m_eScale;   // The sweep scale type

              CmdGnuCapOP( void );
    virtual  ~CmdGnuCapOP( );

    virtual  bool  bSetDefaults( void );

    virtual  bool  bParse ( void );
    virtual  bool  bFormat( void );

    CmdGnuCapOP & operator = ( const CmdNgSpiceDC & roCmdDC );

    void  Print( const wxString & rosPrefix=wxT("  ") );
};

//*****************************************************************************

#endif // CMDGCPOP_HPP
