//*****************************************************************************
//                             PnlNgSpiceTR.hpp                               *
//                            ------------------                              *
// Description : This class derives from the Analysis Panel base class and    *
//               provides a GUI for a user to configure a Transient Analysis  *
//               for NG-Spice electronic circuit simulator.                   *
// Started     : 05/08/2004                                                   *
// Last Update : 30/06/2009                                                   *
// Copyright   : (C) 2004 by MSWaters                                         *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef PNLNGSPICETR_HPP
#define PNLNGSPICETR_HPP

// System Includes

#include <cfloat>

// wxWidgets Library Includes


// Application Includes

#include "TypeDefs.hpp"
#include "base/PnlAnaBase.hpp"
#include "netlist/SimnNgSpice.hpp"
#include "ngspice/dialogs/DlgNgsCfgSrc.hpp"

// Local Constant Declarations


//*****************************************************************************

class PnlNgSpiceTR : public PnlAnaBase
{
  private :

    // Signal source configuration controls
    wxButton      m_oBtnSetup;
    DlgNgsCfgSrc  m_oDlgCfgSrc;

    void  Create( void );

  public :

    PnlNgSpiceTR( wxWindow * poWin );
   ~PnlNgSpiceTR( );

    bool  bClear( void );

    bool  bLoad( SimnNgSpice & roSimn );
    bool  bSave( SimnNgSpice & roSimn );

    // Event handlers
    void  OnChoSrcName( wxCommandEvent & roEvtCmd );
    void  OnBtnSetup  ( wxCommandEvent & roEvtCmd );

    // Unique display control identifiers
    enum ePnlItemID
    {
      ID_BTN_SETUP = PnlAnaBase::ID_LST+1,

      ID_UNUSED,

      ID_FST = ID_BTN_SETUP,
      ID_LST = ID_BTN_SETUP
    };

    // Leave this as the last line as private access is envoked by macro
    DECLARE_EVENT_TABLE( )
};

//*****************************************************************************

#endif // PNLNGSPICETR_HPP
