
module KAT.AES
	( katAES
	, katAES128
	, katAES192
	, katAES256
	) where

import KAT.Utils
import HexUtils

katAES, katAES128, katAES192, katAES256 :: KATs
katAES = concatKATs
	[ katAES128
	, katAES192
	, katAES256
	]
katAES128 = concatKATs
	[ katAES128Nettle
	, katAES128NIST
	]
katAES192 = concatKATs
	[ katAES192Nettle
	, katAES192NIST
	]
katAES256 = concatKATs
	[ katAES256Nettle
	, katAES256NIST
	]

-- source: nettle tests
katAES128Nettle, katAES192Nettle, katAES256Nettle :: KATs
katAES128Nettle = defaultKATs
	{ kat_ECB =
		[ KAT_ECB
			(hs "0001020305060708 0A0B0C0D0F101112")
			(hs "506812A45F08C889 B97F5980038B8359")
			(hs "D8F532538289EF7D 06B506A4FD5BE9C9")
		, KAT_ECB
			(hs "14151617191A1B1C 1E1F202123242526")
			(hs "5C6D71CA30DE8B8B 00549984D2EC7D4B")
			(hs "59AB30F4D4EE6E4F F9907EF65B1FB68C")
		, KAT_ECB
			(hs "28292A2B2D2E2F30 323334353738393A")
			(hs "53F3F4C64F8616E4 E7C56199F48F21F6")
			(hs "BF1ED2FCB2AF3FD4 1443B56D85025CB1")
		, KAT_ECB
			(hs "A0A1A2A3A5A6A7A8 AAABACADAFB0B1B2")
			(hs "F5F4F7F684878689 A6A7A0A1D2CDCCCF")
			(hs "CE52AF650D088CA5 59425223F4D32694")
-- nettle "test_invert"
		, KAT_ECB
			(hs "0001020305060708 0A0B0C0D0F101112")
			(hs "506812A45F08C889 B97F5980038B8359")
			(hs "D8F532538289EF7D 06B506A4FD5BE9C9")
		]
	}
katAES192Nettle = defaultKATs
	{ kat_ECB =
		[ KAT_ECB
			(hs "0001020305060708 0A0B0C0D0F101112 14151617191A1B1C")
			(hs "2D33EEF2C0430A8A 9EBF45E809C40BB6")
			(hs "DFF4945E0336DF4C 1C56BC700EFF837F")
-- nettle "test_invert"
		, KAT_ECB
			(hs "0001020305060708 0A0B0C0D0F101112 14151617191A1B1C")
			(hs "2D33EEF2C0430A8A 9EBF45E809C40BB6")
			(hs "DFF4945E0336DF4C 1C56BC700EFF837F")
		]
	}
katAES256Nettle = defaultKATs
	{ kat_ECB =
		[ KAT_ECB
			(hs "0001020305060708 0A0B0C0D0F101112 14151617191A1B1C 1E1F202123242526")
			(hs "834EADFCCAC7E1B30664B1ABA44815AB")
			(hs "1946DABF6A03A2A2 C3D0B05080AED6FC")
		, KAT_ECB
			(hs "8d ae 93 ff fc 78 c9 44 2a bd 0c 1e 68 bc a6 c7 05 c7 84 e3 5a a9 11 8b d3 16 aa 54 9b 44 08 9e")
			(hs "a5 ce 55 d4 21 15 a1 c6 4a a4 0c b2 ca a6 d1 37")
			(hs "1f 94 fc 85 f2 36 21 06 4a ea e3 c9 cc 38 01 0e")
-- nettle "test_invert"
		, KAT_ECB
			(hs "0001020305060708 0A0B0C0D0F101112 14151617191A1B1C 1E1F202123242526")
			(hs "834EADFCCAC7E1B30664B1ABA44815AB")
			(hs "1946DABF6A03A2A2 C3D0B05080AED6FC")
		]
	}

-- From draft NIST spec on AES modes.
-- F.1 ECB Example Vectors
katAES128NIST, katAES192NIST, katAES256NIST :: KATs
-- F.1.1 ECB-AES128-Encrypt
katAES128NIST = defaultKATs
	{ kat_ECB =
		[ KAT_ECB
			(hs "2b7e151628aed2a6abf7158809cf4f3c")
			(hs "6bc1bee22e409f96e93d7e117393172a ae2d8a571e03ac9c9eb76fac45af8e51 30c81c46a35ce411e5fbc1191a0a52ef f69f2445df4f9b17ad2b417be66c3710")
			(hs "3ad77bb40d7a3660a89ecaf32466ef97 f5d3d58503b9699de785895a96fdbaaf 43b1cd7f598ece23881b00e3ed030688 7b0c785e27e8ad3f8223207104725dd4")
		]
	}
-- F.1.3 ECB-AES192-Encrypt
katAES192NIST = defaultKATs
	{ kat_ECB =
		[ KAT_ECB
			(hs "8e73b0f7da0e6452c810f32b809079e5 62f8ead2522c6b7b")
			(hs "6bc1bee22e409f96e93d7e117393172a ae2d8a571e03ac9c9eb76fac45af8e51 30c81c46a35ce411e5fbc1191a0a52ef f69f2445df4f9b17ad2b417be66c3710")
			(hs "bd334f1d6e45f25ff712a214571fa5cc 974104846d0ad3ad7734ecb3ecee4eef ef7afd2270e2e60adce0ba2face6444e 9a4b41ba738d6c72fb16691603c18e0e")
		]
	}
-- F.1.5 ECB-AES256-Encrypt
katAES256NIST = defaultKATs
	{ kat_ECB =
		[ KAT_ECB
			(hs "603deb1015ca71be2b73aef0857d7781 1f352c073b6108d72d9810a30914dff4")
			(hs "6bc1bee22e409f96e93d7e117393172a ae2d8a571e03ac9c9eb76fac45af8e51 30c81c46a35ce411e5fbc1191a0a52ef f69f2445df4f9b17ad2b417be66c3710")
			(hs "f3eed1bdb5d2a03c064b5a7e3db181f8 591ccb10d410ed26dc5ba74a31362870 b6ed21b99ca6f4f9f153e7b1beafed1d 23304b7a39f9f3ff067d8d8f9e24ecc7")
		]
	}
