<?php

// This doc comment block generated by idl/sysdoc.php
/**
 * (excerpt from http://php.net/manual/en/class.splqueue.php)
 *
 * The SplQueue class provides the main functionalities of a queue
 * implemented using a doubly linked list.
 *
 */
class SplQueue extends SplDoublyLinkedList
  implements \HH\Iterator, ArrayAccess, Countable {

  // This doc comment block generated by idl/sysdoc.php
  /**
   * (excerpt from http://php.net/manual/en/splqueue.dequeue.php)
   *
   * Dequeues value from the top of the queue.
   *
   * SplQueue::dequeue() is an alias of SplDoublyLinkedList::shift().
   *
   * @return     mixed   The value of the dequeued node.
   */
  public function dequeue() {
    return $this->shift();
  }

  // This doc comment block generated by idl/sysdoc.php
  /**
   * (excerpt from http://php.net/manual/en/splqueue.enqueue.php)
   *
   * Enqueues value at the end of the queue.
   *
   * SplQueue::enqueue() is an alias of SplDoublyLinkedList::push().
   *
   * @value      mixed   The value to enqueue.
   *
   * @return     mixed   No value is returned.
   */
  public function enqueue($value) {
    $this->push($value);
  }

  // This doc comment block generated by idl/sysdoc.php
  /**
   * (excerpt from http://php.net/manual/en/splqueue.setiteratormode.php)
   *
   *
   * @mode       mixed   There is only one iteration parameter you can
   *                     modify. The behavior of the iterator (either one or
   *                     the other): SplDoublyLinkedList::IT_MODE_DELETE
   *                     (Elements are deleted by the iterator)
   *                     SplDoublyLinkedList::IT_MODE_KEEP (Elements are
   *                     traversed by the iterator)
   *
   *                     The default mode is:
   *                     SplDoublyLinkedList::IT_MODE_FIFO |
   *                     SplDoublyLinkedList::IT_MODE_KEEP Warning
   *
   *                     The direction of iteration can not be changed for
   *                     SplQueues, it is always
   *                     SplDoublyLinkedList::IT_MODE_FIFO.
   *
   * @return     mixed   No value is returned.
   */
  public function setIteratorMode($mode) {
    if ($mode & self::IT_MODE_LIFO) {
      throw new RuntimeException(
        'Iterators\' LIFO/FIFO modes for SplStack/SplQueue objects are frozen');
    }
    parent::setIteratorMode($mode);
  }
}
