Hy
==

[![Version](https://img.shields.io/pypi/v/hy.svg)](https://pypi.python.org/pypi/hy)

<a href="https://xkcd.com/224/"><img title="We lost the documentation on quantum mechanics. You'll have to decode the regexes yourself." alt="XKCD #224" src="https://raw.github.com/hylang/shyte/18f6925e08684b0e1f52b2cc2c803989cd62cd91/imgs/xkcd.png"></a>

Lisp and Python should love each other. Let's make it happen.

Hy is a Lisp dialect that's embedded in Python. Since Hy transforms its Lisp
code into Python abstract syntax tree (AST) objects, you have the whole
beautiful world of Python at your fingertips, in Lisp form.

To install the latest release of Hy, just use the command `pip3 install
--user hy`. Then you can start an interactive read-eval-print loop (REPL) with
the command `hy`, or run a Hy program with `hy myprogram.hy`.

Hy is tested on all released and currently maintained versions of CPython (on
Linux and Windows), and on recent versions of PyPy and Pyodide.

* [The Hy homepage](http://hylang.org)
* [Try Hy with a web console](http://hylang.org/try-hy)
* [Why Hy?](http://docs.hylang.org/en/stable/whyhy.html)
* [Tutorial](http://docs.hylang.org/en/stable/tutorial.html)

Project
-------

* Code: https://github.com/hylang/hy
* Documentation:
  * master, for use with the latest revision on GitHub: http://docs.hylang.org/en/master
  * stable, for use with the latest release on PyPI: http://docs.hylang.org/en/stable
* Bug reports: We have no bugs! Your bugs are your own! (https://github.com/hylang/hy/issues)
* License: MIT (Expat)
* [Hacking on Hy](http://docs.hylang.org/en/master/hacking.html)
  * [Contributor Guidelines](http://docs.hylang.org/en/master/hacking.html#contributor-guidelines)
  * [Code of Conduct](http://docs.hylang.org/en/master/hacking.html#contributor-code-of-conduct)
* Community: Join us on [Github Discussions](https://github.com/hylang/hy/discussions)!
* [Stack Overflow: The [hy] tag](https://stackoverflow.com/questions/tagged/hy)

Hy's current maintainer is [Kodi Arfer](https://github.com/Kodiologist). He takes responsibility for answering user questions, which should primarily be asked on Stack Overflow or GitHub Discussions, but feel free to [poke him](http://arfer.net/elsewhere) if he's missed a question or you've found a serious security issue.

![Cuddles the Hacker](https://i.imgur.com/QbPMXTN.png)

(fan art from the one and only [doctormo](http://doctormo.deviantart.com/art/Cuddles-the-Hacker-372184766))
