/*
 * Decompiled with CFR 0.152.
 */
package jarinstaller.gui;

import jarinstaller.JarUtil;
import jarinstaller.gui.INavigation;
import jarinstaller.gui.IReport;
import jarinstaller.gui.StepPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.URI;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class InstallPanel
extends StepPanel
implements IReport {
    Hashtable gp;
    JLabel lblInfo = new JLabel();
    JLabel zippedFile = new JLabel();
    JLabel extractedFile = new JLabel();
    JProgressBar progressBar = new JProgressBar();
    INavigation navigation;
    URI sourcefile;
    String destDir;
    String info;
    String jarinstallerdir;
    boolean insresult = false;
    String errmsg = "";
    int pbvalue = 0;
    JarUtil ju;
    Thread juThread;

    public InstallPanel(Hashtable params) {
        this.gp = params;
        this.sourcefile = (URI)this.gp.get("parameter.option.sourcefile");
        this.destDir = (String)this.gp.get("DESTINATIONDIR");
        this.jarinstallerdir = (String)this.gp.get("parameter.dir.jarinstaller");
        this.navigation = (INavigation)this.gp.get("navigation.frameid");
        try {
            this.createElements();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createElements() throws Exception {
        this.setOpaque(false);
        this.lblInfo.setFont((Font)this.gp.get("gui.font.title"));
        this.lblInfo.setOpaque(false);
        this.zippedFile.setFont((Font)this.gp.get("gui.font.msg.small"));
        this.zippedFile.setOpaque(false);
        this.extractedFile.setFont((Font)this.gp.get("gui.font.msg.small"));
        this.extractedFile.setOpaque(false);
        this.progressBar.setForeground((Color)this.gp.get("gui.color.progress"));
        this.progressBar.setDoubleBuffered(true);
        this.progressBar.setOpaque(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridbag = new GridBagConstraints();
        gridbag.gridx = 0;
        gridbag.gridy = 0;
        gridbag.gridwidth = 1;
        gridbag.gridheight = 1;
        gridbag.weightx = 0.0;
        gridbag.weighty = 0.0;
        gridbag.anchor = 17;
        gridbag.fill = 2;
        gridbag.insets = new Insets(10, 20, 10, 10);
        this.add((Component)this.lblInfo, gridbag);
        gridbag.gridy = 1;
        gridbag.weightx = 1.0;
        gridbag.insets = new Insets(30, 20, 10, 10);
        this.add((Component)this.zippedFile, gridbag);
        gridbag.gridy = 2;
        gridbag.insets = new Insets(15, 20, 10, 10);
        this.add((Component)this.extractedFile, gridbag);
        gridbag.gridy = 3;
        gridbag.insets = new Insets(30, 20, 10, 20);
        this.progressBar.setPreferredSize(new Dimension(150, 20));
        this.add((Component)this.progressBar, gridbag);
        this.refresh();
        this.guiRefresh();
    }

    public void guiRefresh() throws Exception {
        this.setBackground((Color)this.gp.get("gui.color.bgrnd"));
        this.setMaximumSize((Dimension)this.gp.get("gui.dimension.steppanel"));
        this.setPreferredSize((Dimension)this.gp.get("gui.dimension.steppanel"));
        this.setMinimumSize((Dimension)this.gp.get("gui.dimension.steppanel"));
        this.lblInfo.setForeground((Color)this.gp.get("gui.color.fgrnd"));
        this.zippedFile.setForeground((Color)this.gp.get("gui.color.fgrnd"));
        this.extractedFile.setForeground((Color)this.gp.get("gui.color.fgrnd"));
        this.zippedFile.setText("");
        this.extractedFile.setText("");
        this.progressBar.setValue(0);
        this.validate();
    }

    public boolean isActivate() {
        return !this.insresult;
    }

    public void setParams(Hashtable params) {
        this.info = (String)params.get("info");
        this.lblInfo.setText(this.info);
        this.validate();
    }

    public boolean start(Hashtable start_params) {
        return this.exec();
    }

    private boolean checkParameterFileSecurity(Hashtable params) {
        boolean isMain;
        char NL = '\n';
        String mainprogram = (String)params.get("MAINPROGRAM");
        boolean bl = isMain = mainprogram == null || mainprogram.length() == 0 || mainprogram.equalsIgnoreCase("true");
        if (!isMain) {
            return true;
        }
        try {
            String pathvar = (String)params.get("install.path.var");
            String installDir = (String)params.get(pathvar);
            if (installDir != null && installDir.length() > 0) {
                return true;
            }
            String rootdir = (String)params.get("PATHFILEDIR");
            String rootfile = (String)params.get("PATHFILENAME");
            File rfile = new File(rootdir + File.separator + rootfile);
            try {
                if (rfile.exists()) {
                    if (rfile.canWrite()) {
                        return true;
                    }
                    this.setResult(false, "Az al\u00e1bbi \u00e1llom\u00e1ny \u00edr\u00e1s\u00e1hoz nincs jogosults\u00e1ga:" + NL + rfile.getAbsolutePath() + NL + "Futtassa a telep\u00edt\u0151t rendszergazdai jogosults\u00e1gokkal, " + NL + "vagy adjon \u00edr\u00e1si jogosults\u00e1got az \u00e1llom\u00e1nyra. ", null);
                    return false;
                }
            }
            catch (Exception e) {
                this.setResult(false, "Az al\u00e1bbi \u00e1llom\u00e1ny \u00edr\u00e1s\u00e1hoz nincs jogosults\u00e1ga:" + NL + rfile.getAbsolutePath() + NL + "Futtassa a telep\u00edt\u0151t rendszergazdai jogosults\u00e1gokkal, " + NL + "vagy adjon \u00edr\u00e1si jogosults\u00e1got az \u00e1llom\u00e1nyra. ", null);
                return false;
            }
            try {
                if (rfile.createNewFile()) {
                    rfile.delete();
                    return true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.setResult(false, "Az al\u00e1bbi \u00e1llom\u00e1ny l\u00e9trehoz\u00e1s\u00e1hoz nincs jogosults\u00e1ga:" + NL + rfile.getAbsolutePath() + NL + "Futtassa a telep\u00edt\u0151t rendszergazdai jogosults\u00e1gokkal, " + NL + "vagy hozza l\u00e9tre \u00e9s adjon \u00edr\u00e1si jogosults\u00e1got az \u00e1llom\u00e1nyra. ", null);
            return false;
        }
        catch (Exception e) {
            this.setResult(false, e.getMessage(), null);
            return false;
        }
    }

    private boolean exec() {
        if (!this.checkParameterFileSecurity(this.gp)) {
            return this.insresult;
        }
        try {
            this.insresult = false;
            this.ju = new JarUtil(this.sourcefile);
            this.ju.setReport(this);
            this.ju.setParams(this.gp);
            this.progressBar.setMaximum(this.ju.list());
            this.juThread = new Thread(this.ju);
            this.juThread.start();
        }
        catch (Exception e) {
            this.errmsg = e.getMessage();
            this.navigation.fwd();
        }
        return this.insresult;
    }

    public boolean isFinisdhed(boolean stop) {
        if (stop) {
            if (this.juThread.isAlive()) {
                this.ju.stop();
                while (!this.ju.isStopped()) {
                    this.sleep(2000L);
                }
                this.juThread = null;
            }
            return true;
        }
        return true;
    }

    private void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Hashtable end() {
        this.gp.remove("option.installed.msg");
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put("parameter.option.install.result", new Boolean(this.insresult));
        if (!this.insresult) {
            result.put("parameter.option.install.errmsg", this.errmsg);
        }
        return result;
    }

    public void inFormStart(String msg, String info, long size) {
        this.zippedFile.setText(msg);
        this.extractedFile.setText(info);
        this.validate();
    }

    public void inFormEnd(String msg, String info, long size) {
        this.pbvalue += (int)size;
        this.progressBar.setValue(this.pbvalue);
    }

    public void setResult(boolean result, String msg, Hashtable data) {
        this.insresult = result;
        this.errmsg = msg;
        this.navigation.fwd();
    }
}

