/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * Copyright (C) chaitanya chandel 2009 <cchandel@yahoo.com>
 * 
 * gui.c is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * gui.c is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#define _GNU_SOURCE
#include "gui.h"
#include <fcntl.h>
#include <pthread.h>
#include <sys/stat.h>

typedef struct _WinList
{
   Evas_Object *win;
   Evas_Object *li;
} Winlist;

typedef struct _CharList
{
   char *type;
   Evas_Object *li;
} CharList;

void pop_win_del(void *data, Evas_Object *obj, void *event_info)
{
	if (scanning == 1) return;
}

void popup_message(char *message, char *msg, int butt_state)
{
	Evas_Object *pop_win, *bg, *inwin, *vbox, *lb;
	static Winlist wl;
	
	pop_win = elm_win_add(NULL, "inwin", ELM_WIN_DIALOG_BASIC);
	elm_win_title_set(pop_win, "Message");
	evas_object_smart_callback_add(pop_win, "delete,request", pop_win_del, NULL);

	bg = elm_bg_add(pop_win);
	elm_win_resize_object_add(pop_win, bg);
	evas_object_size_hint_weight_set(bg, 1.0, 1.0);
	evas_object_show(bg);

	inwin = elm_win_inwin_add(pop_win);
	elm_object_style_set(inwin, "minimal_vertical");
	evas_object_show(inwin);

	vbox = elm_box_add(pop_win);
	elm_win_inwin_content_set(inwin, vbox);
	evas_object_show(vbox);
	
	popup_lb = elm_label_add(pop_win);
	elm_object_text_set(popup_lb, message);
	elm_box_pack_end(vbox, popup_lb);
	evas_object_show(popup_lb);

	lb = elm_label_add(pop_win);
	elm_object_text_set(lb, msg);
	elm_box_pack_end(vbox, lb);
	evas_object_show(lb);
	
	//add close button
	popup_bt = elm_button_add(pop_win);
	elm_object_text_set(popup_bt, "Done");
	evas_object_size_hint_weight_set(popup_bt, 1.0, 1.0);
	evas_object_size_hint_align_set(popup_bt, 0.5, -1.0);
	elm_box_pack_end(vbox, popup_bt);
	if (butt_state) evas_object_show(popup_bt);
	wl.win = pop_win;
	wl.li = NULL;
	evas_object_smart_callback_add(popup_bt, "clicked", cancel_button_clicked, &wl);
	
	evas_object_resize(pop_win, 320, 240);
	evas_object_show(pop_win);
}

int cancel_alert(void *data, Evas_Object *obj, void *event_info)
{
	Evas_Object *win = data;
	//close the window
	evas_object_del((Evas_Object *)win);
	return 0;
}

int ack_alert(void *data, Evas_Object *obj, void *event_info)
{
	Evas_Object *win = data;
	//close the window
	evas_object_del((Evas_Object *)win);
	return 1;
}

void popup_alert(char *message)
{
	Evas_Object *win, *bg, *inwin, *lb, *bt, *bt1;

	win = elm_win_add(NULL, "inwin", ELM_WIN_DIALOG_BASIC);
	elm_win_title_set(win, "Alert!");
	elm_win_autodel_set(win, 1);

	bg = elm_bg_add(win);
	elm_win_resize_object_add(win, bg);
	evas_object_size_hint_weight_set(bg, 1.0, 1.0);
	evas_object_show(bg);

	inwin = elm_win_inwin_add(win);
	elm_object_style_set(inwin, "minimal_vertical");
	evas_object_show(inwin);

	lb = elm_label_add(win);
	elm_object_text_set(lb,message);
	elm_win_inwin_content_set(inwin, lb);
	evas_object_show(lb);

	//add yes button
	bt = elm_button_add(win);
	elm_object_text_set(bt, "Yes");
	evas_object_size_hint_weight_set(bt, 1.0, 1.0);
	evas_object_size_hint_align_set(bt, -1.0, -1.0);
	elm_box_pack_end(inwin, bt);
	evas_object_show(bt);
	evas_object_smart_callback_add(bt, "clicked", (void *)ack_alert, win);
	
	//add close button
	bt1 = elm_button_add(win);
	elm_object_text_set(bt1, "Done");
	evas_object_size_hint_weight_set(bt1, 1.0, 1.0);
	evas_object_size_hint_align_set(bt1, -1.0, -1.0);
	elm_box_pack_end(inwin, bt1);
	evas_object_show(bt1);
	evas_object_smart_callback_add(bt1, "clicked", (void *)cancel_alert, win);
	
	evas_object_resize(win, 320, 240);
	evas_object_show(win);
}

void set_music_dir_button_clicked(void *data, Evas_Object *obj, void *event_info)
{
	int ret;
	static Winlist wl1;
	Winlist *wl = data;
	
	Elm_Object_Item *gl_item = (Elm_Object_Item *)elm_genlist_selected_item_get(wl->li);
	_dir *dir_gl = (_dir *)elm_object_item_data_get(gl_item);
	if (dir_gl->type != DT_DIR) return;
	//set values for closing window
	wl1.li = wl->li;
	wl1.win = wl->win;
	cancel_button_clicked (&wl1, NULL, NULL);
	//set songs_dir
	strcpy(songs_dir, dir_gl->path);
	popup_message("Adding Songs .... Please Wait !!", NULL, 0);
	scanning = 1;
	scan_timer = ecore_timer_add(1.0, update_scan_popup, NULL);
	ret = pthread_create(&thread_id, NULL, (void *)song_scan, NULL);
}

void cancel_button_clicked(void *data, Evas_Object *obj, void *event_info)
{
	Winlist *wl = data;
	//clear the list
	if (wl->li) elm_genlist_clear(wl->li);
	//close the window
	evas_object_del(wl->win);
}

char *album_gl_text_get(void *data, Evas_Object *obj, const char *part)
{
	char tystr[254], *ty;
	char *label = (char *)data;

	sprintf(tystr, "%s", label);
	ty = strdup(tystr);
	return (ty);
}

Evas_Object *album_gl_content_get(void *data, Evas_Object *obj, const char *part)
{
	char buf[PATH_MAX];
	if (!strcmp(part, "elm.swallow.icon"))
	{
		Evas_Object *ic = elm_icon_add(obj);
		snprintf(buf, sizeof(buf), "%s/album.png", intone_dir);
		elm_icon_file_set(ic, buf, NULL);
		evas_object_size_hint_aspect_set(ic, EVAS_ASPECT_CONTROL_VERTICAL, 1, 1);
		return ic;
	}
	return NULL;
}

Eina_Bool album_gl_state_get(void *data, Evas_Object *obj, const char *part)
{
   return 0;
}

void album_gl_del(void *data, Evas_Object *obj)
{
}

void create_add_alb_page(void *data, Evas_Object *obj, void *event_info)
{
	Evas_Object *add_alb_win;
	add_alb_win = elm_win_add(NULL, "add_album_page", ELM_WIN_BASIC);
	elm_win_title_set(add_alb_win, "Add Albums");

	Evas_Object *bg, *vbox, *hbox, *hbox1, *fr, *lb;
	Evas_Object *add_album_button, *cancel_button;
	static Winlist wl;
	
	//add background
	bg = elm_bg_add(add_alb_win);
	elm_win_resize_object_add(add_alb_win, bg);
	evas_object_size_hint_weight_set(bg, 1.0, 1.0);
	evas_object_show(bg);

	//add vbox 4
	vbox = elm_box_add(add_alb_win);
	elm_win_resize_object_add(add_alb_win, vbox);
	evas_object_size_hint_weight_set(vbox, 1.0, 1.0);
	evas_object_show(vbox);

	// add button hbox
	hbox = elm_box_add(add_alb_win);
	elm_box_horizontal_set(hbox, 1);
	evas_object_size_hint_weight_set(hbox, 1.0, 0.0);
	evas_object_size_hint_align_set(hbox, -1.0, 0.0);
	elm_box_pack_end(vbox, hbox);
	evas_object_show(hbox);

	// add a frame
	fr = elm_frame_add(add_alb_win);
	elm_object_style_set(fr, "outdent_top");
	evas_object_size_hint_weight_set(fr, 0.0, 0.0);
	evas_object_size_hint_align_set(fr, 0.0, -1.0);
	elm_box_pack_end(hbox, fr);
	evas_object_show(fr);

	// add a label
	lb = elm_label_add(add_alb_win);
	elm_object_text_set(lb, "Albums");
	elm_object_content_set(fr, lb);
	evas_object_show(lb);    

	//add list to vbox now
	add_album_list = elm_genlist_add(add_alb_win);
	elm_object_scale_set(add_album_list,1.0);
	elm_genlist_bounce_set(add_album_list, 0 ,0);
	evas_object_size_hint_weight_set(add_album_list, 1.0, 1.0);
	evas_object_size_hint_align_set(add_album_list, -1.0, -1.0);
	elm_genlist_multi_select_set(add_album_list, 1);
	elm_box_pack_end(vbox, add_album_list);
	evas_object_show(add_album_list);

	//genlist class defs
	itc_add_album_list.item_style     		= "default";
	itc_add_album_list.func.text_get 	= album_gl_text_get;
	itc_add_album_list.func.content_get  	= album_gl_content_get;
	itc_add_album_list.func.state_get 	= album_gl_state_get;
	itc_add_album_list.func.del       		= album_gl_del;
	
	// add button hbox1
	hbox1 = elm_box_add(add_alb_win);
	elm_box_horizontal_set(hbox1, 1);
	evas_object_size_hint_weight_set(hbox1, 1.0, 0.0);
	evas_object_size_hint_align_set(hbox1, -1.0, 0.0);
	elm_box_pack_end(vbox, hbox1);
	evas_object_show(hbox1);

	//add add_album button to hbox1
	add_album_button = elm_button_add(add_alb_win);
	elm_object_text_set(add_album_button, "Add Selected");
	evas_object_size_hint_weight_set(add_album_button, 1.0, 1.0);
	evas_object_size_hint_align_set(add_album_button, -1.0, -1.0);
	elm_box_pack_end(hbox1, add_album_button);
	evas_object_show(add_album_button);
	evas_object_smart_callback_add(add_album_button, "clicked", add_album_button_clicked, add_album_list);
		
	// add cancel button
	cancel_button = elm_button_add(add_alb_win);
	elm_object_text_set(cancel_button, "Done");
	evas_object_size_hint_weight_set(cancel_button, 1.0, 1.0);
	evas_object_size_hint_align_set(cancel_button, -1.0, -1.0);
	elm_box_pack_end(hbox1, cancel_button);
	evas_object_show(cancel_button);
	wl.win = add_alb_win;
	wl.li = add_album_list;
	evas_object_smart_callback_add(cancel_button, "clicked", cancel_button_clicked, &wl);
	
	//set delete callback for this window
	evas_object_smart_callback_add(add_alb_win, "delete,request", cancel_button_clicked, &wl);

	update_album_list(&itc_add_album_list, add_album_list);
	evas_object_resize(add_alb_win, 480, 600);	
	evas_object_show(add_alb_win);
}

static void
my_hover_bt_1(void *data, Evas_Object *obj, void *event_info)
{
   Evas_Object *hv = data;
   
   evas_object_show(hv);
}

char *gl_text_get(void *data, Evas_Object *obj, const char *part)
{
	char tystr[254], *ty;
	
	_dir *song_data = (_dir *)data;
	if (pl_info){
		ty = strrchr(path_songs[song_data->type], '/');
		if (ty) {
			ty ++;
			sprintf(tystr, "%s", ty);
		}
	}
	else sprintf(tystr, "%s", song_data->path);
	ty = strdup(tystr);
	return (ty);
}

Evas_Object *gl_content_get(void *data, Evas_Object *obj, const char *part)
{
	char buf[PATH_MAX];
	if (!strcmp(part, "elm.swallow.icon"))
	{
		Evas_Object *ic = elm_icon_add(obj);
		_dir *song_data = (_dir *) data;
		snprintf(buf, sizeof(buf), "%s/song.png", intone_dir);
		if ((play_state != IDLE) && (randomize == 0) && (song_data->type == song_index )) snprintf(buf, sizeof(buf), "%s/play.png", intone_dir);
		if ((play_state != IDLE) && (randomize == 1) && (song_data->type == seq[song_index])) snprintf(buf, sizeof(buf), "%s/play.png", intone_dir);
		elm_icon_file_set(ic, buf, NULL);
		evas_object_size_hint_aspect_set(ic, EVAS_ASPECT_CONTROL_VERTICAL, 1, 1);
		return ic;
	}
	return NULL;
}

Eina_Bool gl_state_get(void *data, Evas_Object *obj, const char *part)
{
   return 0;
}

void gl_del(void *data, Evas_Object *obj)
{
}

void create_gui(Evas_Object *win)
{
	//playlist page - default view is playlist view
	Evas_Object *bg, *hbox, *prev_button, *next_button, *playlist_button, *view_button;
	Evas_Object *bx, *bt, *shuffle_button;
	Evas_Object *toolbar, *vol_slider, *ic, *eq_button, *loop_button;
	char buf[PATH_MAX], hv_label[30], *tystr, ty[30];
	int i;
	
	//add background
	bg = elm_bg_add(win);
	elm_win_resize_object_add(win, bg);
	evas_object_size_hint_weight_set(bg, 1.0, 1.0);
	evas_object_show(bg);
	evas_object_focus_set(bg, 1);
	evas_object_event_callback_add(bg, EVAS_CALLBACK_KEY_DOWN, key_press, NULL);

	//add vbox 4
	vbox = elm_box_add(win);
	elm_win_resize_object_add(win, vbox);
	evas_object_size_hint_weight_set(vbox, 1.0, 1.0);
	evas_object_show(vbox);

	//toolbar hbox
	toolbar = elm_box_add(win);
	elm_box_horizontal_set(toolbar, 1);
	evas_object_size_hint_weight_set(toolbar, 1.0, 0.0);
	evas_object_size_hint_align_set(toolbar, -1.0, 0.0);
	elm_box_pack_end(vbox, toolbar);
	evas_object_show(toolbar);

	//add view button to the toolbar
	view_button = elm_button_add(win);
	ic_view = elm_icon_add(win);
	snprintf(buf, sizeof(buf), "%s/playlist_view.png", intone_dir);
	elm_icon_file_set(ic_view, buf, NULL);
	elm_object_content_set(view_button, ic_view);
	evas_object_size_hint_weight_set(view_button, 1.0, 1.0);
	evas_object_size_hint_align_set(view_button, -1.0, -1.0);
	elm_box_pack_end(toolbar, view_button);
	evas_object_show(view_button);
 	evas_object_smart_callback_add(view_button, "clicked", toggle_view, NULL);

	//add settings button to the toolbar
	eq_button = elm_button_add(win);
	ic= elm_icon_add(win);
	snprintf(buf, sizeof(buf), "%s/settings.png", intone_dir);
	elm_icon_file_set(ic, buf, NULL);
	elm_object_content_set(eq_button, ic);
	evas_object_size_hint_weight_set(eq_button, 1.0, 1.0);
	evas_object_size_hint_align_set(eq_button, -1.0, -1.0);
	elm_box_pack_end(toolbar, eq_button);
	evas_object_show(eq_button);
 	evas_object_smart_callback_add(eq_button, "clicked", create_set_page, NULL);
	
	//add songs button to the toolbar
	playlist_button = elm_button_add(win);
	elm_object_text_set(playlist_button, "Songs");
	evas_object_size_hint_weight_set(playlist_button, 1.0, 1.0);
	evas_object_size_hint_align_set(playlist_button, -1.0, -1.0);
	elm_box_pack_end(toolbar, playlist_button);
	evas_object_show(playlist_button);
	evas_object_smart_callback_add(playlist_button, "clicked", (void *)manage_songs_page, list);   

	//add hover for list shuffle to the toolbar
	shuffle_hv = elm_hover_add(win);
	bx = elm_box_add(win);
	evas_object_size_hint_weight_set(bx, 1.0, 1.0);
	evas_object_size_hint_align_set(bx, -1.0, -1.0);
	elm_box_pack_end(toolbar, bx);
	evas_object_show(bx);

	shuffle_button = elm_button_add(win);
	ic_shuffle = elm_icon_add(win);
	if (randomize) snprintf(buf, sizeof(buf), "%s/shuffle.png", intone_dir);
	else snprintf(buf, sizeof(buf), "%s/no-shuffle.png", intone_dir);
	elm_icon_file_set(ic_shuffle, buf, NULL);
	elm_object_content_set(shuffle_button, ic_shuffle);
	evas_object_smart_callback_add(shuffle_button, "clicked", my_hover_bt_1, shuffle_hv);
	evas_object_size_hint_weight_set(shuffle_button, 1.0, 1.0);
	evas_object_size_hint_align_set(shuffle_button, -1.0, -1.0);
	elm_box_pack_end(bx, shuffle_button);
	evas_object_show(shuffle_button);
	elm_hover_parent_set(shuffle_hv, win);
	elm_hover_target_set(shuffle_hv, shuffle_button);

	bt = elm_button_add(win);
	elm_object_text_set(bt, "---");
	evas_object_size_hint_weight_set(bt, 1.0, 1.0);
	evas_object_size_hint_align_set(bt, -1.0, -1.0);
	elm_object_part_content_set(shuffle_hv, "middle", bt);
	evas_object_show(bt);

	bx = elm_box_add(win);
	//add 5 buttons
	for (i=1; i<6; i++) {
		bt = elm_button_add(win);
		switch(i) {
			case 1 : strcpy(hv_label, "File"); strcpy(ty, "none"); break;
			case 2 : strcpy(hv_label, "Album"); strcpy(ty, "album"); break;
			case 3 : strcpy(hv_label, "Artist"); strcpy(ty, "artist"); break;
			case 4 : strcpy(hv_label, "Song"); strcpy(ty, "song"); break;
			case 5 : strcpy(hv_label, "Random"); strcpy(ty, "random"); break;
			default : break;
		}
		elm_object_text_set(bt, hv_label);
		elm_box_pack_end(bx, bt);
		tystr = strdup(ty);
		evas_object_smart_callback_add(bt, "clicked", set_random_mode, (char *)tystr);
		evas_object_show(bt);
	}	
	evas_object_show(bx);
	elm_object_part_content_set(shuffle_hv, "bottom", bx);

	/*random_button = elm_button_add(win);
	ic_shuffle = elm_icon_add(win);
	if (randomize) snprintf(buf, sizeof(buf), "%s/shuffle.png", intone_dir);
	else snprintf(buf, sizeof(buf), "%s/no-shuffle.png", intone_dir);
	elm_icon_file_set(ic_shuffle, buf, NULL);
	elm_object_content_set(random_button, ic_shuffle);
	evas_object_size_hint_weight_set(random_button, 1.0, 1.0);
	evas_object_size_hint_align_set(random_button, -1.0, -1.0);
	elm_box_pack_end(toolbar, random_button);
	evas_object_show(random_button);
 	evas_object_smart_callback_add(random_button, "clicked", random_tg, NULL);*/

	//add hover for play loop to the toolbar
	loop_button = elm_button_add(win);
	ic_repeat = elm_icon_add(win);
	if (loop) snprintf(buf, sizeof(buf), "%s/repeat.png", intone_dir);
	else snprintf(buf, sizeof(buf), "%s/no-repeat.png", intone_dir);
	elm_icon_file_set(ic_repeat, buf, NULL);
	elm_object_content_set(loop_button, ic_repeat);
	evas_object_size_hint_weight_set(loop_button, 1.0, 1.0);
	evas_object_size_hint_align_set(loop_button, -1.0, -1.0);
	elm_box_pack_end(toolbar, loop_button);
	evas_object_show(loop_button);
 	evas_object_smart_callback_add(loop_button, "clicked", loop_tg, NULL);
	
	//add the list box
	list_box = elm_box_add(win);
	evas_object_size_hint_weight_set(list_box, 1.0, 1.0);
	evas_object_size_hint_align_set(list_box, -1.0, -1.0);
	elm_box_pack_end(vbox, list_box);
	evas_object_show(list_box);
	
	//add list to vbox now
	list = elm_genlist_add(win);
	elm_object_scale_set(list, 1.0);
	elm_genlist_bounce_set(list, 0, 0);
	evas_object_size_hint_weight_set(list, 1.0, 1.0);
	evas_object_size_hint_align_set(list, -1.0, -1.0);
	elm_genlist_multi_select_set(list, 0);
	elm_box_pack_end(list_box, list);
	evas_object_show(list);
	evas_object_smart_callback_add(list, "clicked", song_select_play, list);
	evas_object_smart_callback_add(list, "selected", song_select, list);	
	//evas_object_event_callback_add(list, EVAS_CALLBACK_KEY_DOWN, key_press, NULL);
	
	//genlist class defs
	itc_list.item_style     		= "default";
	itc_list.func.text_get 	= gl_text_get;
	itc_list.func.content_get  	= gl_content_get;
	itc_list.func.state_get 	= gl_state_get;
	itc_list.func.del       		= gl_del;

	//add hbox to vbox at pos 4
	hbox = elm_box_add(win);
	elm_box_horizontal_set(hbox, 1);
	evas_object_size_hint_weight_set(hbox, 1.0, 0.0);
	evas_object_size_hint_align_set(hbox, -1.0, 0.0);
	elm_box_pack_end(vbox, hbox);
	evas_object_show(hbox);

	//add prev button to the hbox
	prev_button = elm_button_add(win);
	ic = elm_icon_add(win);
	snprintf(buf, sizeof(buf), "%s/prev.png", intone_dir);
	elm_icon_file_set(ic, buf, NULL);
	evas_object_size_hint_aspect_set(ic, EVAS_ASPECT_CONTROL_VERTICAL, 1, 1);
	elm_object_content_set(prev_button, ic);
	evas_object_show(ic);
	evas_object_size_hint_weight_set(prev_button, 1.0, 1.0);
	evas_object_size_hint_align_set(prev_button, -1.0, -1.0);
	elm_box_pack_end(hbox, prev_button);
	evas_object_show(prev_button);
	evas_object_smart_callback_add(prev_button, "clicked", prev_button_clicked, list);

	//add play button to the hbox
	play_button = elm_button_add(win);
	ic_play = elm_icon_add(win);
	snprintf(buf, sizeof(buf), "%s/play.png", intone_dir);
	elm_icon_file_set(ic_play, buf, NULL);
	evas_object_size_hint_aspect_set(ic_play, EVAS_ASPECT_CONTROL_VERTICAL, 1, 1);
	elm_object_content_set(play_button, ic_play);
	evas_object_show(ic_play);
	evas_object_size_hint_weight_set(play_button, 1.0, 1.0);
	evas_object_size_hint_align_set(play_button, -1.0, -1.0);
	elm_box_pack_end(hbox, play_button);
	evas_object_show(play_button);
	evas_object_smart_callback_add(play_button, "clicked", play_button_clicked, list);

	//add next button to the hbox
	next_button = elm_button_add(win);
	ic = elm_icon_add(win);
	snprintf(buf, sizeof(buf), "%s/next.png", intone_dir);
	elm_icon_file_set(ic, buf, NULL);
	evas_object_size_hint_aspect_set(ic, EVAS_ASPECT_CONTROL_VERTICAL, 1, 1);
	elm_object_content_set(next_button, ic);
	evas_object_show(ic);
	evas_object_size_hint_weight_set(next_button, 1.0, 1.0);
	evas_object_size_hint_align_set(next_button, -1.0, -1.0);
	elm_box_pack_end(hbox, next_button);
	evas_object_show(next_button);
	evas_object_smart_callback_add(next_button, "clicked", next_button_clicked, list);

	//add vol slider to hbox
	vol_slider = elm_slider_add(win);
	elm_object_text_set(vol_slider, "Vol");
	elm_slider_unit_format_set(vol_slider, "%3.0f");
	elm_slider_indicator_format_set(vol_slider, "%3.0f");
	elm_slider_min_max_set(vol_slider, 70, 100);
	elm_slider_value_set(vol_slider, vol);
	evas_object_size_hint_align_set(vol_slider, -1.0, 0.5);
	evas_object_size_hint_weight_set(vol_slider, 1.0, 1.0);
	elm_box_pack_end(hbox, vol_slider);
	evas_object_show(vol_slider);
	evas_object_smart_callback_add(vol_slider, "delay,changed", vol_changed, NULL);

	//add hbox to vbox
	hbox = elm_box_add(win);
	elm_box_horizontal_set(hbox, 1);
	evas_object_size_hint_weight_set(hbox, 1.0, 0.0);
	evas_object_size_hint_align_set(hbox, -1.0, 0.0);
	elm_box_pack_end(vbox, hbox);
	evas_object_show(hbox);

	//add cur pos label
	play_cur_pos = elm_label_add(win);
	elm_object_text_set(play_cur_pos, "0:00");
	elm_box_pack_end(hbox, play_cur_pos);
	evas_object_show(play_cur_pos);

	//add position slider to hbox
	pos_slider = elm_slider_add(win);
 	elm_slider_indicator_format_set(pos_slider, "%3.0f");
	evas_object_size_hint_weight_set(pos_slider, 1.0, 0.0);
	evas_object_size_hint_align_set(pos_slider, -1.0, 0.0);
	elm_box_pack_end(hbox, pos_slider);
	elm_slider_min_max_set(pos_slider, 0, song_dur); //set to seconds
	elm_slider_value_set(pos_slider, (double)seek);
	evas_object_show(pos_slider);
	evas_object_smart_callback_add(pos_slider, "changed", pos_changed_start, NULL);
	evas_object_smart_callback_add(pos_slider, "delay,changed", pos_changed, NULL);
	
	//add total dur label label
	play_dur = elm_label_add(win);
	elm_object_text_set(play_dur, "0:00");
	elm_box_pack_end(hbox, play_dur);
	evas_object_show(play_dur);

	//if seek set up duration
	if (seek) {
		int min,sec;
		char tystr[254], cmd[254];
		min = song_dur / 60;
		sec = song_dur % 60;
		if (sec < 10) sprintf(tystr, "0%d", sec);
		else sprintf(tystr, "%d", sec);
		sprintf(cmd, "%d:%s", min, tystr);
	}

	// make window full screen
	evas_object_resize(win, 480, 600);
	
	//Populate the playlist
	populate_main_list(list);
}

char *dir_gl_text_get(void *data, Evas_Object *obj, const char *part)
{
	_dir *dir_gl = (_dir *)data;
	char tystr[254], *ty;
	char *label = dir_gl->path;
	
	ty = strrchr(label, '/');
	ty ++;
	sprintf(tystr, "%s", ty);
	ty = strdup(tystr);
	return (ty);
}

Evas_Object *dir_gl_content_get(void *data, Evas_Object *obj, const char *part)
{
	_dir *dir_gl = (_dir *)data;
	char buf[PATH_MAX], buf1[PATH_MAX];
	
	if (!strcmp(part, "elm.swallow.icon"))
	{
		Evas_Object *ic = elm_icon_add(obj);
		Evas_Object *ic1 = elm_icon_add(obj);
		
		snprintf(buf, sizeof(buf), "%s/folder.png", intone_dir);
		snprintf(buf1, sizeof(buf1), "%s/generic.png", intone_dir);
		elm_icon_file_set(ic, buf, NULL);
		elm_icon_file_set(ic1, buf1, NULL);
		evas_object_size_hint_aspect_set(ic, EVAS_ASPECT_CONTROL_VERTICAL, 1, 1);
		evas_object_size_hint_aspect_set(ic1, EVAS_ASPECT_CONTROL_VERTICAL, 1, 1);
		if (dir_gl->type == DT_DIR) return ic;
		else return ic1;
	}
	return NULL;
}

Eina_Bool dir_gl_state_get(void *data, Evas_Object *obj, const char *part)
{
   return 0;
}

void dir_gl_del(void *data, Evas_Object *obj)
{
}

void create_dir_browser_page(void *data, Evas_Object *obj, void *event_info)
{
	//Evas_Object *dir_browser_page_win;
	dir_browser_page_win = elm_win_add(NULL, "sel_direc", ELM_WIN_BASIC);
	elm_win_title_set(dir_browser_page_win, "Set Music Home Directory");

	Evas_Object *bg, *vbox, *hbox, *hbox1, *up_button, *home_button, *enter_dir_button;
	Evas_Object *cancel_button, *dir_list, *done_button;
	static Winlist wl;
	
	//add background
	bg = elm_bg_add(dir_browser_page_win);
	elm_win_resize_object_add(dir_browser_page_win, bg);
	evas_object_size_hint_weight_set(bg, 1.0, 1.0);
	evas_object_show(bg);

	//add vbox 3
	vbox = elm_box_add(dir_browser_page_win);
	elm_win_resize_object_add(dir_browser_page_win, vbox);
	evas_object_size_hint_weight_set(vbox, 1.0, 1.0);
	evas_object_show(vbox);

	// add button hbox
	hbox = elm_box_add(dir_browser_page_win);
	elm_box_horizontal_set(hbox, 1);
	elm_box_homogeneous_set(hbox, 1);
	evas_object_size_hint_weight_set(hbox, 1.0, 0.0);
	evas_object_size_hint_align_set(hbox, -1.0, 0.0);
	elm_box_pack_end(vbox, hbox);
	evas_object_show(hbox);

	//add up button to hbox
	up_button = elm_button_add(dir_browser_page_win);
	elm_object_text_set(up_button, "Up");
	evas_object_size_hint_weight_set(up_button, 1.0, 1.0);
	evas_object_size_hint_align_set(up_button, -1.0, -1.0);
	elm_box_pack_end(hbox, up_button);
	evas_object_show(up_button);

	//add home button to hbox
	home_button = elm_button_add(dir_browser_page_win);
	elm_object_text_set(home_button, "Home");
	evas_object_size_hint_weight_set(home_button, 1.0, 1.0);
	evas_object_size_hint_align_set(home_button, -1.0, -1.0);
	elm_box_pack_end(hbox, home_button);
	evas_object_show(home_button);

	//add enter dir button to hbox
	enter_dir_button = elm_button_add(dir_browser_page_win);
	elm_object_text_set(enter_dir_button, "Enter Dir");
	evas_object_size_hint_weight_set(enter_dir_button, 1.0, 1.0);
	evas_object_size_hint_align_set(enter_dir_button, -1.0, -1.0);
	elm_box_pack_end(hbox, enter_dir_button);
	evas_object_show(enter_dir_button);

	//add list to vbox now
	dir_list = elm_genlist_add(dir_browser_page_win);
	elm_object_scale_set(dir_list, 1.0);
	elm_genlist_bounce_set(dir_list, 0 ,0);
	evas_object_size_hint_weight_set(dir_list, 1.0, 1.0);
	evas_object_size_hint_align_set(dir_list, -1.0, -1.0);
	elm_genlist_multi_select_set(dir_list, 0);
	elm_box_pack_end(vbox, dir_list);
	evas_object_show(dir_list);
	evas_object_smart_callback_add(dir_list, "clicked", dir_list_select, dir_list);
	evas_object_smart_callback_add(up_button, "clicked", up_button_clicked, dir_list);
	evas_object_smart_callback_add(home_button, "clicked", home_button_clicked, dir_list);   
	evas_object_smart_callback_add(enter_dir_button, "clicked", dir_list_select, dir_list); 

	//genlist class defs
	itc_dir_list.item_style     		= "default";
	itc_dir_list.func.text_get 		= dir_gl_text_get;
	itc_dir_list.func.content_get  		= dir_gl_content_get;
	itc_dir_list.func.state_get 	= dir_gl_state_get;
	itc_dir_list.func.del       		= dir_gl_del;
	
	// add button hbox1
	hbox1 = elm_box_add(dir_browser_page_win);
	elm_box_horizontal_set(hbox1, 1);
	evas_object_size_hint_weight_set(hbox1, 1.0, 0.0);
	evas_object_size_hint_align_set(hbox1, -1.0, 0.0);
	elm_box_pack_end(vbox, hbox1);
	evas_object_show(hbox1);

	//add done button to hbox1
	done_button = elm_button_add(dir_browser_page_win);
	elm_object_text_set(done_button, "Select Dir");
	evas_object_size_hint_weight_set(done_button, 1.0, 1.0);
	evas_object_size_hint_align_set(done_button, -1.0, -1.0);
	elm_box_pack_end(hbox1, done_button);
	evas_object_show(done_button);
	wl.win = dir_browser_page_win;
	wl.li = dir_list;
	evas_object_smart_callback_add(done_button, "clicked", set_music_dir_button_clicked, &wl);

	//add cancel button to hbox1
	cancel_button = elm_button_add(dir_browser_page_win);
	elm_object_text_set(cancel_button, "Cancel");
	evas_object_size_hint_weight_set(cancel_button, 1.0, 1.0);
	evas_object_size_hint_align_set(cancel_button, -1.0, -1.0);
	elm_box_pack_end(hbox1, cancel_button);
	evas_object_show(cancel_button);
	evas_object_smart_callback_add(cancel_button, "clicked", cancel_button_clicked, &wl);
	
	//set delete callback for this window
	evas_object_smart_callback_add(dir_browser_page_win, "delete,request", cancel_button_clicked, &wl);

	//load directory data
	load_dir(dir_list, "/");

	evas_object_resize(dir_browser_page_win, 480, 600);
	evas_object_show(dir_browser_page_win);
}

void select_all_songs(void *data, Evas_Object *obj, void *event_info)
{
	Evas_Object *li = (Evas_Object *) data;
	Elm_Object_Item *gl_item;

	gl_item = elm_genlist_first_item_get(li);
	if (gl_item) elm_genlist_item_selected_set(gl_item, 1);
	while ((gl_item = elm_genlist_item_next_get(gl_item))) {
		elm_genlist_item_selected_set(gl_item, 1);
	}
}

char *final_filter_gl_text_get(void *data, Evas_Object *obj, const char *part)
{
	char tystr[254], *ty;
	_str2 *filter_song = (_str2 *) data;
	
	sprintf(tystr, "%s", filter_song->name);
	ty = strdup(tystr);
	return (ty);
}

Evas_Object *final_filter_gl_content_get(void *data, Evas_Object *obj, const char *part)
{
	char buf[PATH_MAX];
	if (!strcmp(part, "elm.swallow.icon"))
	{
		Evas_Object *ic = elm_icon_add(obj);
		snprintf(buf, sizeof(buf), "%s/playlist.png", intone_dir);
		elm_icon_file_set(ic, buf, NULL);
		evas_object_size_hint_aspect_set(ic, EVAS_ASPECT_CONTROL_VERTICAL, 1, 1);
		return ic;
	}
	return NULL;
}

Eina_Bool final_filter_gl_state_get(void *data, Evas_Object *obj, const char *part)
{
   return 0;
}

void final_filter_gl_del(void *data, Evas_Object *obj)
{
}

void select_songs_page(void *data, Evas_Object *obj, void *event_info)
{
	CharList *cl = data;
	Elm_Object_Item *gl_item;

	char *name;
	gl_item = elm_genlist_selected_item_get(cl->li);
	if (!gl_item) return;
	name = (char *)elm_object_item_data_get(gl_item);
	
	//save a temporary playlist
	select_songs_page_win = elm_win_add(NULL, "select songs", ELM_WIN_BASIC);
	elm_win_title_set(select_songs_page_win, "Select Songs to Play");

	Evas_Object *bg, *vbox, *hbox, *filter_final_list;
	Evas_Object *home_dir_button;
	Evas_Object *cancel_button;
	static Winlist wl;
	
	//add background
	bg = elm_bg_add(select_songs_page_win);
	elm_win_resize_object_add(select_songs_page_win, bg);
	evas_object_size_hint_weight_set(bg, 1.0, 1.0);
	evas_object_show(bg);

	//add vbox
	vbox = elm_box_add(select_songs_page_win);
	elm_win_resize_object_add(select_songs_page_win, vbox);
	evas_object_size_hint_weight_set(vbox, 1.0, 1.0);
	evas_object_show(vbox);

	// add list
	filter_final_list = elm_genlist_add(select_songs_page_win);
	elm_object_scale_set(filter_final_list, 1.0);
	elm_genlist_bounce_set(filter_final_list, 0 ,0);
	evas_object_size_hint_weight_set(filter_final_list, 1.0, 1.0);
	evas_object_size_hint_align_set(filter_final_list, -1.0, -1.0);
	elm_genlist_multi_select_set(filter_final_list, 1);
	elm_box_pack_end(vbox, filter_final_list);
	evas_object_show(filter_final_list);

	//genlist class defs
	itc_filter_final.item_style     		= "default";
	itc_filter_final.func.text_get 	= final_filter_gl_text_get;
	itc_filter_final.func.content_get  	= final_filter_gl_content_get;
	itc_filter_final.func.state_get 	= final_filter_gl_state_get;
	itc_filter_final.func.del       		= final_filter_gl_del;

	// add hbox
	hbox = elm_box_add(select_songs_page_win);
	elm_box_horizontal_set(hbox, 1);
	evas_object_size_hint_weight_set(hbox, 1.0, 0.0);
	evas_object_size_hint_align_set(hbox, -1.0, 0.0);
	elm_box_pack_end(vbox, hbox);
	evas_object_show(hbox);

	//add create_playlist button to hbox
	home_dir_button = elm_button_add(select_songs_page_win);
	elm_object_text_set(home_dir_button, "Play Selected");
	evas_object_size_hint_weight_set(home_dir_button, 1.0, 1.0);
	evas_object_size_hint_align_set(home_dir_button, -1.0, -1.0);
	elm_box_pack_end(hbox, home_dir_button);
	evas_object_show(home_dir_button);
	evas_object_smart_callback_add(home_dir_button, "clicked", (void *)temp_playlist, filter_final_list);

	//add create_playlist button to hbox
	home_dir_button = elm_button_add(select_songs_page_win);
	elm_object_text_set(home_dir_button, "Select All");
	evas_object_size_hint_weight_set(home_dir_button, 1.0, 1.0);
	evas_object_size_hint_align_set(home_dir_button, -1.0, -1.0);
	elm_box_pack_end(hbox, home_dir_button);
	evas_object_show(home_dir_button);
	evas_object_smart_callback_add(home_dir_button, "clicked", (void *)select_all_songs, filter_final_list);
	
	//add cancel button to hbox
	cancel_button = elm_button_add(select_songs_page_win);
	elm_object_text_set(cancel_button, "Cancel");
	evas_object_size_hint_weight_set(cancel_button, 1.0, 1.0);
	evas_object_size_hint_align_set(cancel_button, -1.0, -1.0);
	elm_box_pack_end(hbox, cancel_button);
	evas_object_show(cancel_button);
	wl.win = select_songs_page_win;
	wl.li = filter_final_list;
	evas_object_smart_callback_add(cancel_button, "clicked", cancel_button_clicked, &wl);

	//set delete callback for this window
	evas_object_smart_callback_add(select_songs_page_win, "delete,request", cancel_button_clicked, &wl);
	populate_filter_final_list(cl->type, name, filter_final_list);
	
	evas_object_resize(select_songs_page_win, 480, 600);
	evas_object_show(select_songs_page_win);
}

char *filter_gl_text_get(void *data, Evas_Object *obj, const char *part)
{
	char tystr[254], *ty;
	char *label = (char *)data;
	
	sprintf(tystr, "%s", label);
	ty = strdup(tystr);
	return (ty);
}

Evas_Object *filter_gl_content_get(void *data, Evas_Object *obj, const char *part)
{
	char buf[PATH_MAX];
	if (!strcmp(part, "elm.swallow.icon"))
	{
		Evas_Object *ic = elm_icon_add(obj);
		snprintf(buf, sizeof(buf), "%s/playlist.png", intone_dir);
		elm_icon_file_set(ic, buf, NULL);
		evas_object_size_hint_aspect_set(ic, EVAS_ASPECT_CONTROL_VERTICAL, 1, 1);
		return ic;
	}
	return NULL;
}

Eina_Bool filter_gl_state_get(void *data, Evas_Object *obj, const char *part)
{
   return 0;
}

void filter_gl_del(void *data, Evas_Object *obj)
{
}

void sel_songs_by_page(void *data, Evas_Object *obj, void *event_info)
{
	char *type = (char *) data;
	
	//list with alphabetical listing of artists
	sel_songs_win = elm_win_add(NULL, "manage_songs", ELM_WIN_BASIC);
	elm_win_title_set(sel_songs_win, type);

	Evas_Object *bg, *vbox, *hbox, *filter_list;
	Evas_Object *home_dir_button;
	Evas_Object *cancel_button;
	static CharList cl;
	static Winlist wl;
	
	//add background
	bg = elm_bg_add(sel_songs_win);
	elm_win_resize_object_add(sel_songs_win, bg);
	evas_object_size_hint_weight_set(bg, 1.0, 1.0);
	evas_object_show(bg);

	//add vbox
	vbox = elm_box_add(sel_songs_win);
	elm_win_resize_object_add(sel_songs_win, vbox);
	evas_object_size_hint_weight_set(vbox, 1.0, 1.0);
	evas_object_show(vbox);

	// add list
	filter_list = elm_genlist_add(sel_songs_win);
	elm_object_scale_set(filter_list, 1.0);
	elm_genlist_bounce_set(filter_list, 0 ,0);
	evas_object_size_hint_weight_set(filter_list, 1.0, 1.0);
	evas_object_size_hint_align_set(filter_list, -1.0, -1.0);
	elm_genlist_multi_select_set(filter_list, 0); //till the popup_alert starts working
	elm_box_pack_end(vbox, filter_list);
	evas_object_show(filter_list);

	//genlist class defs
	itc_filter_list.item_style     	= "default";
	itc_filter_list.func.text_get 	= filter_gl_text_get;
	itc_filter_list.func.content_get  	= filter_gl_content_get;
	itc_filter_list.func.state_get 	= filter_gl_state_get;
	itc_filter_list.func.del       		= filter_gl_del;

	// add hbox
	hbox = elm_box_add(sel_songs_win);
	elm_box_horizontal_set(hbox, 1);
	evas_object_size_hint_weight_set(hbox, 1.0, 0.0);
	evas_object_size_hint_align_set(hbox, -1.0, 0.0);
	elm_box_pack_end(vbox, hbox);
	evas_object_show(hbox);

	//add create_playlist button to hbox
	home_dir_button = elm_button_add(sel_songs_win);
	elm_object_text_set(home_dir_button, "Select");
	evas_object_size_hint_weight_set(home_dir_button, 1.0, 1.0);
	evas_object_size_hint_align_set(home_dir_button, -1.0, -1.0);
	elm_box_pack_end(hbox, home_dir_button);
	evas_object_show(home_dir_button);
	cl.type = type;
	cl.li = filter_list;	
	evas_object_smart_callback_add(home_dir_button, "clicked", (void *)select_songs_page, &cl);

	//add cancel button to hbox
	cancel_button = elm_button_add(sel_songs_win);
	elm_object_text_set(cancel_button, "Cancel");
	evas_object_size_hint_weight_set(cancel_button, 1.0, 1.0);
	evas_object_size_hint_align_set(cancel_button, -1.0, -1.0);
	elm_box_pack_end(hbox, cancel_button);
	evas_object_show(cancel_button);
	wl.win = sel_songs_win;
	wl.li = filter_list;
	evas_object_smart_callback_add(cancel_button, "clicked", cancel_button_clicked, &wl);

	//set delete callback for this window
	evas_object_smart_callback_add(sel_songs_win, "delete,request", cancel_button_clicked, &wl);

	populate_filter_list(type, filter_list);
	evas_object_resize(sel_songs_win, 480, 600);
	evas_object_show(sel_songs_win);
}

void play_all_songs(void *data, Evas_Object *obj, void *event_info)
{
	Winlist *wl = data;
	//clear the list
	if (wl->li) elm_genlist_clear(wl->li);
	//close the window
	evas_object_del(wl->win);
	
	strcpy(cur_playlist, "0 All Songs");
	set_no_songs ();
	populate_main_list (list);
	elm_win_title_set(win, "All Songs");
}

char *home_list_text_get(void *data, Evas_Object *obj, const char *part)
{
	char tystr[254], *ty;
	char *label = (char *)data;
	
	sprintf(tystr, "%s", label);
	ty = strdup(tystr);
	return (ty);
}

Evas_Object *home_list_content_get(void *data, Evas_Object *obj, const char *part)
{
	return NULL;
}

Eina_Bool home_list_state_get(void *data, Evas_Object *obj, const char *part)
{
   return 0;
}

void home_list_del(void *data, Evas_Object *obj)
{
}

void manage_songs_page(void *data, Evas_Object *obj, void *event_info)
{
	manage_songs_page_win = elm_win_add(NULL, "manage_songs", ELM_WIN_BASIC);
	elm_win_title_set(manage_songs_page_win, "Songs");

	Evas_Object *bg, *vbox, *hbox, *create_playlist_button;
	Evas_Object *fr, *lb, *home_dir_button, *rescan_button;
	Evas_Object *cancel_button;
	char *var;
	static Winlist wl;
	
	wl.win = manage_songs_page_win;
	wl.li = NULL;
	
	//add background
	bg = elm_bg_add(manage_songs_page_win);
	elm_win_resize_object_add(manage_songs_page_win, bg);
	evas_object_size_hint_weight_set(bg, 1.0, 1.0);
	evas_object_show(bg);

	//add vbox
	vbox = elm_box_add(manage_songs_page_win);
	elm_win_resize_object_add(manage_songs_page_win, vbox);
	evas_object_size_hint_weight_set(vbox, 1.0, 1.0);
	evas_object_show(vbox);
	
	// add a label
	lb = elm_label_add(manage_songs_page_win);
	elm_object_text_set(lb, "Song Directories");
	elm_box_pack_end(vbox, lb);
	evas_object_show(lb);    

	// add a list
	home_list = elm_genlist_add(manage_songs_page_win);
	elm_object_scale_set(home_list, 1.0);
	elm_genlist_bounce_set(home_list, 0 ,0);
	evas_object_size_hint_weight_set(home_list, 1.0, 1.0);
	evas_object_size_hint_align_set(home_list, -1.0, -1.0);
	elm_genlist_multi_select_set(home_list, 0); //till the popup_alert starts working
	elm_box_pack_end(vbox, home_list);
	evas_object_show(home_list);

	//genlist class defs
	itc_home_list.item_style     		= "default";
	itc_home_list.func.text_get 	= home_list_text_get;
	itc_home_list.func.content_get  	= home_list_content_get;
	itc_home_list.func.state_get 	= home_list_state_get;
	itc_home_list.func.del       		= home_list_del;

	populate_home_list(home_list);
	
	// add a frame
	fr = elm_frame_add(manage_songs_page_win);
	elm_object_style_set(fr, "outdent_top");
	evas_object_size_hint_weight_set(fr, 1.0, 0.0);
	//evas_object_size_hint_align_set(fr, 0.5, 0.0);
	elm_box_pack_end(vbox, fr);
	evas_object_show(fr);
	
	// add hbox
	hbox = elm_box_add(manage_songs_page_win);
	elm_box_horizontal_set(hbox, 1);
	elm_box_homogeneous_set(hbox, 1);
	evas_object_size_hint_weight_set(hbox, 1.0, 1.0);
	//evas_object_size_hint_align_set(hbox, -1.0, 0.0);
	elm_object_content_set(fr, hbox);
	evas_object_show(hbox);

	//add add dir button to hbox
	home_dir_button = elm_button_add(manage_songs_page_win);
	elm_object_text_set(home_dir_button, "Add Dir");
	evas_object_size_hint_weight_set(home_dir_button, 1.0, 1.0);
	evas_object_size_hint_align_set(home_dir_button, -1.0, 0.0);
	elm_box_pack_end(hbox, home_dir_button);
	evas_object_show(home_dir_button);
	evas_object_smart_callback_add(home_dir_button, "clicked", (void *)create_dir_browser_page, NULL);

	//add rescan dir button to hbox
	rescan_button = elm_button_add(manage_songs_page_win);
	elm_object_text_set(rescan_button, "ReScan Dir");
	evas_object_size_hint_weight_set(rescan_button, 1.0, 1.0);
	evas_object_size_hint_align_set(rescan_button, -1.0, 0.0);
	elm_box_pack_end(hbox, rescan_button);
	evas_object_show(rescan_button);
	evas_object_smart_callback_add(rescan_button, "clicked", (void *)rescan_button_clicked, home_list);

	//add remove dir button to hbox
	rescan_button = elm_button_add(manage_songs_page_win);
	elm_object_text_set(rescan_button, "Remove Dir");
	evas_object_size_hint_weight_set(rescan_button, 1.0, 1.0);
	evas_object_size_hint_align_set(rescan_button, -1.0, 0.0);
	elm_box_pack_end(hbox, rescan_button);
	evas_object_show(rescan_button);
	evas_object_smart_callback_add(rescan_button, "clicked", (void *)remove_dir_button_clicked, home_list);
	
	//add all songs button to vbox
	create_playlist_button = elm_button_add(manage_songs_page_win);
	elm_object_text_set(create_playlist_button, "Play All Songs");
	evas_object_size_hint_weight_set(create_playlist_button, 1.0, 0.0);
	evas_object_size_hint_align_set(create_playlist_button, -1.0, 0.0);
	elm_box_pack_end(vbox, create_playlist_button);
	evas_object_show(create_playlist_button);
	evas_object_smart_callback_add(create_playlist_button, "clicked", (void *)play_all_songs, &wl);
	
	//add select playlist button to vbox
	create_playlist_button = elm_button_add(manage_songs_page_win);
	elm_object_text_set(create_playlist_button, "Select Songs / Folder to Play");
	evas_object_size_hint_weight_set(create_playlist_button, 1.0, 0.0);
	evas_object_size_hint_align_set(create_playlist_button, -1.0, 0.0);
	elm_box_pack_end(vbox, create_playlist_button);
	evas_object_show(create_playlist_button);
	evas_object_smart_callback_add(create_playlist_button, "clicked", (void *)create_manage_playlist_page, NULL);

	//add select artist button to hbox
	create_playlist_button = elm_button_add(manage_songs_page_win);
	elm_object_text_set(create_playlist_button, "Artists");
	evas_object_size_hint_weight_set(create_playlist_button, 1.0, 0.0);
	evas_object_size_hint_align_set(create_playlist_button, -1.0, 0.0);
	elm_box_pack_end(vbox, create_playlist_button);
	evas_object_show(create_playlist_button);
	var = "Artists";
	evas_object_smart_callback_add(create_playlist_button, "clicked", (void *)sel_songs_by_page, (char *)var);

	//add select album button to hbox
	cancel_button = elm_button_add(manage_songs_page_win);
	elm_object_text_set(cancel_button, "Done");
	evas_object_size_hint_weight_set(cancel_button, 1.0, 0.0);
	evas_object_size_hint_align_set(cancel_button, -1.0, 0.0);
	elm_box_pack_end(vbox, cancel_button);
	evas_object_show(cancel_button);
	evas_object_smart_callback_add(cancel_button, "clicked", cancel_button_clicked, &wl);
	
	//set delete callback for this window
	evas_object_smart_callback_add(manage_songs_page_win, "delete,request", cancel_button_clicked, &wl);
	
	evas_object_resize(manage_songs_page_win, 480, 600);
	evas_object_show(manage_songs_page_win);
}

char *play_gl_text_get(void *data, Evas_Object *obj, const char *part)
{
	char tystr[254], *ty;
	char *label = (char *)data;
	
	sprintf(tystr, "%s", label);
	ty = strdup(tystr);
	return (ty);
}

Evas_Object *play_gl_content_get(void *data, Evas_Object *obj, const char *part)
{
	char buf[PATH_MAX];
	if (!strcmp(part, "elm.swallow.icon"))
	{
		Evas_Object *ic = elm_icon_add(obj);
		snprintf(buf, sizeof(buf), "%s/playlist.png", intone_dir);
		elm_icon_file_set(ic, buf, NULL);
		evas_object_size_hint_aspect_set(ic, EVAS_ASPECT_CONTROL_VERTICAL, 1, 1);
		return ic;
	}
	return NULL;
}

Eina_Bool play_gl_state_get(void *data, Evas_Object *obj, const char *part)
{
   return 0;
}

void play_gl_del(void *data, Evas_Object *obj)
{
}

void manage_done_clicked(void *data, Evas_Object *obj, void *event_info)
{
	static Winlist wl1;
	Winlist *ty = data;
	wl1.win = ty->win;
	wl1.li = ty->li;
	
	//if((strlen(cur_playlist) > 1) && (strcmp(cur_playlist, "Select a Playlist!") != 0))
		//sel_song();
	cancel_button_clicked (&wl1, NULL, NULL);
}

void create_manage_playlist_page(void)
{
	//Evas_Object *manage_playlist_page_win;
	manage_playlist_page_win = elm_win_add(NULL, "manage_playlist", ELM_WIN_BASIC);
	elm_win_title_set(manage_playlist_page_win, "Manage Playlists");

	Evas_Object *bg, *vbox, *hbox, *create_playlist_button, *del_playlist_button;
	Evas_Object *sel_playlist_button, *edit_playlist_button, *cancel_button;
	char *pl_name = "";
	static Winlist wl;
	
	//add background
	bg = elm_bg_add(manage_playlist_page_win);
	elm_win_resize_object_add(manage_playlist_page_win, bg);
	evas_object_size_hint_weight_set(bg, 1.0, 1.0);
	evas_object_show(bg);

	//add vbox
	vbox = elm_box_add(manage_playlist_page_win);
	elm_win_resize_object_add(manage_playlist_page_win, vbox);
	evas_object_size_hint_weight_set(vbox, 1.0, 1.0);
	evas_object_show(vbox);
	
	//add list
	play_list = elm_genlist_add(manage_playlist_page_win);
	elm_object_scale_set(play_list, 1.0);
	elm_genlist_bounce_set(play_list, 0 ,0);
	evas_object_size_hint_weight_set(play_list, 1.0, 1.0);
	evas_object_size_hint_align_set(play_list, -1.0, -1.0);
	elm_genlist_multi_select_set(play_list, 0); //till the popup_alert starts working
	elm_box_pack_end(vbox, play_list);
	evas_object_show(play_list);

	//genlist class defs
	itc_play_list.item_style     		= "default";
	itc_play_list.func.text_get 	= play_gl_text_get;
	itc_play_list.func.content_get  	= play_gl_content_get;
	itc_play_list.func.state_get 	= play_gl_state_get;
	itc_play_list.func.del       		= play_gl_del;
	
	// add hbox
	hbox = elm_box_add(manage_playlist_page_win);
	elm_box_horizontal_set(hbox, 1);
	elm_box_homogeneous_set(hbox, 1);
	evas_object_size_hint_weight_set(hbox, 1.0, 0.0);
	evas_object_size_hint_align_set(hbox, -1.0, 0.0);
	elm_box_pack_end(vbox, hbox);
	evas_object_show(hbox);

	//add create_playlist button to hbox
	create_playlist_button = elm_button_add(manage_playlist_page_win);
	elm_object_text_set(create_playlist_button, "Add");
	evas_object_size_hint_weight_set(create_playlist_button, 1.0, 1.0);
	evas_object_size_hint_align_set(create_playlist_button, -1.0, -1.0);
	elm_box_pack_end(hbox, create_playlist_button);
	evas_object_show(create_playlist_button);
	evas_object_smart_callback_add(create_playlist_button, "clicked", (void *)create_playlist_page, (char *)pl_name);

	//add del_playlist button to hbox
	del_playlist_button = elm_button_add(manage_playlist_page_win);
	elm_object_text_set(del_playlist_button, "Del");
	evas_object_size_hint_weight_set(del_playlist_button, 1.0, 1.0);
	evas_object_size_hint_align_set(del_playlist_button, -1.0, -1.0);
	elm_box_pack_end(hbox, del_playlist_button);
	evas_object_show(del_playlist_button);
	evas_object_smart_callback_add(del_playlist_button, "clicked", del_playlist_button_clicked, play_list);

	//add edit_playlist button to hbox
	edit_playlist_button = elm_button_add(manage_playlist_page_win);
	elm_object_text_set(edit_playlist_button, "Edit");
	evas_object_size_hint_weight_set(edit_playlist_button, 1.0, 1.0);
	evas_object_size_hint_align_set(edit_playlist_button, -1.0, -1.0);
	elm_box_pack_end(hbox, edit_playlist_button);
	evas_object_show(edit_playlist_button);
	evas_object_smart_callback_add(edit_playlist_button, "clicked", edit_playlist_button_clicked, play_list);

	//add edit_playlist button to hbox
	sel_playlist_button = elm_button_add(manage_playlist_page_win);
	elm_object_text_set(sel_playlist_button, "Select");
	evas_object_size_hint_weight_set(sel_playlist_button, 1.0, 1.0);
	evas_object_size_hint_align_set(sel_playlist_button, -1.0, -1.0);
	elm_box_pack_end(hbox, sel_playlist_button);
	evas_object_show(sel_playlist_button);
	evas_object_smart_callback_add(sel_playlist_button, "clicked", sel_playlist_button_clicked, play_list);

	//add cancel button to hbox
	cancel_button = elm_button_add(manage_playlist_page_win);
	elm_object_text_set(cancel_button, "Done");
	evas_object_size_hint_weight_set(cancel_button, 1.0, 1.0);
	evas_object_size_hint_align_set(cancel_button, -1.0, -1.0);
	elm_box_pack_end(hbox, cancel_button);
	evas_object_show(cancel_button);
	wl.win = manage_playlist_page_win;
	wl.li = play_list;
	evas_object_smart_callback_add(cancel_button, "clicked", cancel_button_clicked, &wl);
	
	//set delete callback for this window
	evas_object_smart_callback_add(manage_playlist_page_win, "delete,request", cancel_button_clicked, &wl);

	evas_object_resize(manage_playlist_page_win, 480, 600);
	evas_object_show(manage_playlist_page_win);

	//populate the playlist
	populate_play_list(play_list);
}

char *c_play_gl_text_get(void *data, Evas_Object *obj, const char *part)
{
	char tystr[254], *ty;
	char *label = (char *)data;
	ty = strrchr(label, '/');
	ty ++;
	sprintf(tystr, "%s", ty);
	ty = strdup(tystr);
	return (ty);
}

Evas_Object *c_play_gl_content_get(void *data, Evas_Object *obj, const char *part)
{
	char buf[PATH_MAX];
	if (!strcmp(part, "elm.swallow.icon"))
	{
		Evas_Object *ic = elm_icon_add(obj);
		snprintf(buf, sizeof(buf), "%s/song.png", intone_dir);
		elm_icon_file_set(ic, buf, NULL);
		evas_object_size_hint_aspect_set(ic, EVAS_ASPECT_CONTROL_VERTICAL, 1, 1);
		return ic;
	}
	return NULL;
}

Eina_Bool c_play_gl_state_get(void *data, Evas_Object *obj, const char *part)
{
   return 0;
}

void c_play_gl_del(void *data, Evas_Object *obj)
{
}

void create_playlist_page(void *data, Evas_Object *obj, void *event_info)
{
	Evas_Object *playlist_page_win;
	playlist_page_win = elm_win_add(NULL, "playlist", ELM_WIN_BASIC);
	elm_win_title_set(playlist_page_win, "Create Playlist");
	elm_win_autodel_set(playlist_page_win, 1);

	Evas_Object *bg, *vbox, *fr, *lb, *hbox, *save_playlist_button, *cancel_button;
	Evas_Object *hbox1, *fr1, *lb1, *entry, *add_alb_button, *remove_songs_button;
	char *pl_name = data;
	static Winlist wl;
	
	//add background
	bg = elm_bg_add(playlist_page_win);
	elm_win_resize_object_add(playlist_page_win, bg);
	evas_object_size_hint_weight_set(bg, 1.0, 1.0);
	evas_object_show(bg);

	//add vbox 3
	vbox = elm_box_add(playlist_page_win);
	elm_win_resize_object_add(playlist_page_win, vbox);
	evas_object_size_hint_weight_set(vbox, 1.0, 1.0);
	evas_object_show(vbox);

	// add  hbox
	hbox = elm_box_add(playlist_page_win);
	elm_box_horizontal_set(hbox, 1);
	evas_object_size_hint_weight_set(hbox, 1.0, 0.0);
	evas_object_size_hint_align_set(hbox, -1.0, -1.0);
	elm_box_pack_end(vbox, hbox);
	evas_object_show(hbox);

	// add a frame
	fr = elm_frame_add(playlist_page_win);
	elm_object_style_set(fr, "outdent_top");
	evas_object_size_hint_weight_set(fr, 0.0, 0.0);
	evas_object_size_hint_align_set(fr, 0.0, -1.0);
	elm_box_pack_end(hbox, fr);
	evas_object_show(fr);

	// add a label
	lb = elm_label_add(playlist_page_win);
	elm_object_text_set(lb, "Playlist:");
	elm_object_content_set(fr, lb);
	evas_object_show(lb);    

	//add an entry
	entry = elm_entry_add(playlist_page_win);
	evas_object_size_hint_weight_set(entry, 1.0, 0.0);
	evas_object_size_hint_align_set(entry, -1.0, 0.0);
	elm_entry_single_line_set(entry, 1);
	elm_entry_editable_set(entry, 1);
	elm_entry_line_wrap_set(entry, 0);
	elm_box_pack_end(hbox, entry);
	evas_object_show(entry);

	//add save playlist button to hboxsave_playlist_button_clicked
	save_playlist_button = elm_button_add(playlist_page_win);
	elm_object_text_set(save_playlist_button, "Save");
	evas_object_size_hint_weight_set(save_playlist_button, 1.0, 1.0);
	evas_object_size_hint_align_set(save_playlist_button, 0.5, -1.0);
	elm_box_pack_end(hbox, save_playlist_button);
	evas_object_show(save_playlist_button);
	evas_object_smart_callback_add(save_playlist_button, "clicked", save_playlist_button_clicked, entry); 

	// add a frame
	fr1 = elm_frame_add(playlist_page_win);
	elm_object_style_set(fr1, "outdent_top");
	evas_object_size_hint_weight_set(fr1, 0.0, 0.0);
	evas_object_size_hint_align_set(fr1, 0.5, -1.0);
	elm_box_pack_end(vbox, fr1);
	evas_object_show(fr1);

	// add a label
	lb1 = elm_label_add(playlist_page_win);
	elm_object_text_set(lb1, "Songs");
	elm_object_content_set(fr1, lb1);
	evas_object_show(lb1);    

	//add list to vbox now
	c_play_list = elm_genlist_add(playlist_page_win);
	elm_object_scale_set(c_play_list, 1.0);
	elm_genlist_bounce_set(c_play_list, 0 ,0);
	evas_object_size_hint_weight_set(c_play_list, 1.0, 1.0);
	evas_object_size_hint_align_set(c_play_list, -1.0, -1.0);
	elm_genlist_multi_select_set(c_play_list, 1);
	elm_box_pack_end(vbox, c_play_list);
	evas_object_show(c_play_list);

	//genlist class defs
	itc_c_play_list.item_style     		= "default";
	itc_c_play_list.func.text_get 	= c_play_gl_text_get;
	itc_c_play_list.func.content_get  	= c_play_gl_content_get;
	itc_c_play_list.func.state_get 	= c_play_gl_state_get;
	itc_c_play_list.func.del       		= c_play_gl_del;
	
	// add button hbox
	hbox1 = elm_box_add(playlist_page_win);
	elm_box_horizontal_set(hbox1, 1);
	elm_box_homogeneous_set(hbox1, 1);
	evas_object_size_hint_weight_set(hbox1, 1.0, 0.0);
	evas_object_size_hint_align_set(hbox1, -1.0, 0.0);
	elm_box_pack_end(vbox, hbox1);
	evas_object_show(hbox1);

	//add add dir button to hbox
	add_alb_button = elm_button_add(playlist_page_win);
	elm_object_text_set(add_alb_button, "Add Album");
	evas_object_size_hint_weight_set(add_alb_button, 1.0, 1.0);
	evas_object_size_hint_align_set(add_alb_button, -1.0, -1.0);
	elm_box_pack_end(hbox1, add_alb_button);
	evas_object_show(add_alb_button);
	evas_object_smart_callback_add(add_alb_button, "clicked", create_add_alb_page, NULL); 

	//add remove song button to hbox
	remove_songs_button = elm_button_add(playlist_page_win);
	elm_object_text_set(remove_songs_button, "Del Songs");
	evas_object_size_hint_weight_set(remove_songs_button, 1.0, 1.0);
	evas_object_size_hint_align_set(remove_songs_button, -1.0, -1.0);
	elm_box_pack_end(hbox1, remove_songs_button);
	evas_object_show(remove_songs_button);
	evas_object_smart_callback_add(remove_songs_button, "clicked", remove_songs_button_clicked, c_play_list); 

	//add cancel button to hbox1
	cancel_button = elm_button_add(playlist_page_win);
	elm_object_text_set(cancel_button, "Cancel");
	evas_object_size_hint_weight_set(cancel_button, 1.0, 1.0);
	evas_object_size_hint_align_set(cancel_button, -1.0, -1.0);
	elm_box_pack_end(hbox1, cancel_button);
	evas_object_show(cancel_button);
	wl.win = playlist_page_win;
	wl.li = c_play_list;
	evas_object_smart_callback_add(cancel_button, "clicked", cancel_button_clicked, &wl);
	
	//set delete callback for this window
	evas_object_smart_callback_add(playlist_page_win, "delete,request", cancel_button_clicked, &wl);

	if (strcmp(pl_name, "") == 0) {
		elm_entry_entry_set(entry, "myplaylist");
	}
	else {
		elm_entry_entry_set(entry, pl_name);
		//populate the list with songs from the playlist
		populate_playlist_songs (c_play_list);
	}
	evas_object_resize(playlist_page_win, 480, 600);
	evas_object_show(playlist_page_win);
}

void create_set_page(void *data, Evas_Object *obj, void *event_info)
{
	set_page_win = elm_win_add(NULL, "set", ELM_WIN_BASIC);
	elm_win_title_set(set_page_win, "Settings");
	elm_win_autodel_set(set_page_win, 1);

	Evas_Object *bg, *vbox, *hbox, *cancel_button, *fr, *box, *priority_slider;
	Evas_Object *bass_slider, *treble_slider, *vbox1, *rdg, *rdg_bt;

	static Winlist wl;
	
	//add background
	bg = elm_bg_add(set_page_win);
	elm_win_resize_object_add(set_page_win, bg);
	evas_object_size_hint_weight_set(bg, 1.0, 1.0);
	evas_object_show(bg);

	//add vbox
	vbox = elm_box_add(set_page_win);
	elm_win_resize_object_add(set_page_win, vbox);
	evas_object_size_hint_weight_set(vbox, 1.0, 1.0);
	evas_object_size_hint_align_set(vbox, -1.0, -1.0);
	evas_object_show(vbox);

	// add  hbox
	hbox = elm_box_add(set_page_win);
	elm_box_horizontal_set(hbox, 1);
	evas_object_size_hint_weight_set(hbox, 1.0, 0.0);
	evas_object_size_hint_align_set(hbox, -1.0, -1.0);
	elm_box_pack_end(vbox, hbox);
	evas_object_show(hbox);

	//add bass slider
	bass_slider = elm_slider_add(set_page_win);
	elm_object_scale_set(bass_slider, 1.0);
	elm_object_text_set(bass_slider, "Bass");
	elm_slider_horizontal_set(bass_slider, 0);
 	elm_slider_inverted_set(bass_slider, 1);
	elm_slider_span_size_set(bass_slider, 180);
	elm_slider_unit_format_set(bass_slider, "%2.0f");
	elm_slider_indicator_format_set(bass_slider, "%2.0f");
	evas_object_size_hint_weight_set(bass_slider, 1.0, 1.0);
	evas_object_size_hint_align_set(bass_slider, -1.0, -1.0);
	elm_box_pack_end(hbox, bass_slider);
	elm_slider_min_max_set(bass_slider, 0, 15);
	elm_slider_value_set(bass_slider, (double)bass);
	evas_object_show(bass_slider);	
	evas_object_smart_callback_add(bass_slider, "delay,changed", bass_changed, NULL);

	//add treble slider
	treble_slider = elm_slider_add(set_page_win);
	elm_object_scale_set(treble_slider, 1.0);
	elm_object_text_set(treble_slider, "Treble");
	elm_slider_horizontal_set(treble_slider, 0);
	elm_slider_inverted_set(treble_slider, 1);
	elm_slider_span_size_set(treble_slider, 180);
	elm_slider_unit_format_set(treble_slider, "%2.0f");
	elm_slider_indicator_format_set(treble_slider, "%2.0f");
	evas_object_size_hint_weight_set(treble_slider, 1.0, 1.0);
	evas_object_size_hint_align_set(treble_slider, -1.0, -1.0);
	elm_box_pack_end(hbox, treble_slider);
	elm_slider_min_max_set(treble_slider, 0, 15);
	elm_slider_value_set(treble_slider, (double)treble);
	evas_object_show(treble_slider);	
	evas_object_smart_callback_add(treble_slider, "delay,changed", treble_changed, NULL);

	//add a slider for mplayer priority	
	priority_slider = elm_slider_add(set_page_win);
	elm_object_scale_set(priority_slider, 1.0);
	elm_object_text_set(priority_slider, "Prioirty");
	elm_slider_horizontal_set(priority_slider, 0);
	elm_slider_span_size_set(priority_slider, 180);
	elm_slider_unit_format_set(priority_slider, "%2.0f");
	elm_slider_indicator_format_set(priority_slider, "%2.0f");
	evas_object_size_hint_weight_set(priority_slider, 1.0, 1.0);
	evas_object_size_hint_align_set(priority_slider, -1.0, -1.0);
	elm_box_pack_end(hbox, priority_slider);
	elm_slider_min_max_set(priority_slider, -20, 0);
	elm_slider_value_set(priority_slider, (double)priority);
	evas_object_show(priority_slider);	
	evas_object_smart_callback_add(priority_slider, "delay,changed", priority_changed, NULL);

	//add vbox1 to hbox
	vbox1 = elm_box_add(set_page_win);
	evas_object_size_hint_weight_set(vbox1, 1.0, 1.0);
	evas_object_size_hint_align_set(vbox1, -1.0, -1.0);
	elm_box_pack_end(hbox, vbox1);
	evas_object_show(vbox1);

	//add a frame
	fr = elm_frame_add(set_page_win);
	elm_object_scale_set(fr, 1.0);
	elm_object_style_set(fr, "default");
	elm_object_text_set(fr, "Playlist Data");
	evas_object_size_hint_weight_set(fr, 1.0, 0.0);
	evas_object_size_hint_align_set(fr, -1.0, -1.0);
	elm_box_pack_end(vbox1, fr);
	evas_object_show(fr);

	//add a box
	box = elm_box_add(set_page_win);
	evas_object_size_hint_weight_set(box, 1.0, 0.0);
	evas_object_size_hint_align_set(box, -1.0, 0.0);
	elm_object_content_set(fr, box);
	evas_object_show(box);

	//add radio buttons
	rd = elm_radio_add(set_page_win);
	elm_radio_state_value_set(rd, pl_info);
	evas_object_size_hint_weight_set(rd, 1.0, 1.0);
	evas_object_size_hint_align_set(rd, -1.0, 0.5);
	elm_object_text_set(rd, "Show Song Tag");
	elm_box_pack_end(box, rd);
	evas_object_show(rd);
	rdg = rd;
	evas_object_smart_callback_add(rd, "changed", playlist_song_tg, NULL);

	rd = elm_radio_add(set_page_win);
	if (pl_info) elm_radio_state_value_set(rd, 0);
	else elm_radio_state_value_set(rd, 1);
	evas_object_size_hint_weight_set(rd, 1.0, 1.0);
	evas_object_size_hint_align_set(rd, -1.0, 0.5);
	elm_radio_group_add(rd, rdg);
	elm_object_text_set(rd, "Show File Name");
	elm_box_pack_end(box, rd);
	evas_object_show(rd);
	evas_object_smart_callback_add(rd, "changed", playlist_song_tg, NULL);
	
	//add a frame
	fr = elm_frame_add(set_page_win);
	elm_object_scale_set(fr, 1.0);
	elm_object_style_set(fr, "default");
	elm_object_text_set(fr, "UI Size (Restart)");
	evas_object_size_hint_weight_set(fr, 1.0, 0.0);
	evas_object_size_hint_align_set(fr, -1.0, -1.0);
	elm_box_pack_end(vbox1, fr);
	evas_object_show(fr);

	//add a box
	box = elm_box_add(set_page_win);
	evas_object_size_hint_weight_set(box, 1.0, 0.0);
	evas_object_size_hint_align_set(box, -1.0, 0.0);
	elm_object_content_set(fr, box);
	evas_object_show(box);
	
	//add radio buttons
	rd = elm_radio_add(set_page_win);
	elm_radio_state_value_set(rd, finger);
	evas_object_size_hint_weight_set(rd, 1.0, 1.0);
	evas_object_size_hint_align_set(rd, -1.0, 0.5);
	elm_object_text_set(rd, "Large");
	elm_box_pack_end(box, rd);
	evas_object_show(rd);
	rdg = rd;
	evas_object_smart_callback_add(rd, "changed", finger_tg, NULL);

	rd = elm_radio_add(set_page_win);
	if (finger) elm_radio_state_value_set(rd, 0);
	else elm_radio_state_value_set(rd, 1);
	evas_object_size_hint_weight_set(rd, 1.0, 1.0);
	evas_object_size_hint_align_set(rd, -1.0, 0.5);
	elm_radio_group_add(rd, rdg);
	elm_object_text_set(rd, "Small");
	elm_box_pack_end(box, rd);
	evas_object_show(rd);
	evas_object_smart_callback_add(rd, "changed", finger_tg, NULL);

	//add a frame
	fr = elm_frame_add(set_page_win);
	elm_object_scale_set(fr, 1.0);
	elm_object_style_set(fr, "default");
	elm_object_text_set(fr, "mplayer Output");
	evas_object_size_hint_weight_set(fr, 1.0, 0.0);
	evas_object_size_hint_align_set(fr, -1.0, -1.0);
	elm_box_pack_end(vbox1, fr);
	evas_object_show(fr);

	//add a box
	box = elm_box_add(set_page_win);
	evas_object_size_hint_weight_set(box, 1.0, 0.0);
	evas_object_size_hint_align_set(box, -1.0, 0.0);
	elm_object_content_set(fr, box);
	evas_object_show(box);
	
	//add radio buttons
	rd_bt = elm_radio_add(set_page_win);
	if (bt) elm_radio_state_value_set(rd_bt, 1);
	else elm_radio_state_value_set(rd_bt, 0);
	evas_object_size_hint_weight_set(rd_bt, 1.0, 1.0);
	evas_object_size_hint_align_set(rd_bt, -1.0, 0.5);
	elm_object_text_set(rd_bt, "Phone Speaker");
	elm_box_pack_end(box, rd_bt);
	evas_object_show(rd_bt);
	rdg_bt = rd_bt;
	evas_object_smart_callback_add(rd_bt, "changed", bt_tg, NULL);

	rd_bt = elm_radio_add(set_page_win);
	if (bt) elm_radio_state_value_set(rd_bt, 0);
	else elm_radio_state_value_set(rd_bt, 1);
	evas_object_size_hint_weight_set(rd_bt, 1.0, 1.0);
	evas_object_size_hint_align_set(rd_bt, -1.0, 0.5);
	elm_radio_group_add(rd_bt, rdg_bt);
	elm_object_text_set(rd_bt, "BT Headphones");
	elm_box_pack_end(box, rd_bt);
	evas_object_show(rd_bt);
	evas_object_smart_callback_add(rd_bt, "changed", bt_tg, NULL);

	//add a frame
	/*fr = elm_frame_add(set_page_win);
	elm_object_scale_set(fr, 1.0);
	elm_object_style_set(fr, "default");
	elm_object_text_set(fr, "mplayer Priority");
	evas_object_size_hint_weight_set(fr, 0.0, 0.0);
	evas_object_size_hint_align_set(fr, 0.0, -1.0);
	elm_box_pack_end(vbox1, fr);
	evas_object_show(fr);*/
	
	//add cancel button to vbox
	cancel_button = elm_button_add(set_page_win);
	elm_object_text_set(cancel_button, "Done");
	evas_object_size_hint_weight_set(cancel_button, 1.0, 1.0);
	evas_object_size_hint_align_set(cancel_button, -1.0, -1.0);
	elm_box_pack_end(vbox, cancel_button);
	evas_object_show(cancel_button);
	wl.win = set_page_win;
	wl.li = NULL;
	evas_object_smart_callback_add(cancel_button, "clicked", cancel_button_clicked, &wl);
	
	evas_object_resize(set_page_win, 480, 600);
	evas_object_show(set_page_win);
}
