/*
 * lanplus_defs.h:  (extracted from ipmitool/ipmi_intf.h)
 *
 * Copyright (c) 2003 Sun Microsystems, Inc.  All Rights Reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * Redistribution of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * Redistribution in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * Neither the name of Sun Microsystems, Inc. or the names of
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * 
 * This software is provided "AS IS," without a warranty of any kind.
 * ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES,
 * INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED.
 * SUN MICROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.  IN NO EVENT WILL
 * SUN OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA,
 * OR FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
 * PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
 * LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE,
 * EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */

#ifndef LANPLUS_DEFS_H
#define LANPLUS_DEFS_H

#if defined(HAVE_CONFIG_H)
#include "config.h"
#else
#ifndef HPUX
/* HPUX already has socklen_t but no #define */
#ifndef socklen_t
typedef unsigned int socklen_t;
#endif
#endif
#endif


#if defined(MACOS)
#include <stdint.h>
#endif

#include <openssl/evp.h>

#ifdef WIN32
#define SockType  SOCKET
#define SockInvalid INVALID_SOCKET /*=0*/
#else
#define SockType  int
#define SockInvalid -1 
#endif

#ifndef IPMI_H

#ifndef _IPMI_RQ_
#define _IPMI_RQ_
struct ipmi_rq {
        struct {
                uint8_t netfn:6;
                uint8_t lun:2;
                uint8_t cmd;
                uint8_t target_cmd;
                uint16_t data_len;
                uint8_t *data;
        } msg;
};
#endif

#ifndef _IPMI_RS_
#define _IPMI_RS_
struct ipmi_rs {
        uint8_t ccode;
        uint8_t data[IPMI_BUF_SIZE];
 
        /*
         * Looks like this is the length of the entire packet, including the RMCP
         * stuff, then modified to be the length of the extra IPMI message data
         */
        int data_len;
 
        struct {
                uint8_t netfn;
                uint8_t cmd;
                uint8_t seq;
                uint8_t lun;
        } msg;
 
        struct {
                uint8_t authtype;
                uint32_t seq;
                uint32_t id;
                uint8_t bEncrypted;     /* IPMI v2 only */
                uint8_t bAuthenticated; /* IPMI v2 only */
                uint8_t payloadtype;    /* IPMI v2 only */
                /* This is the total length of the payload or
                   IPMI message.  IPMI v2.0 requires this to
                   be 2 bytes.  Not really used for much. */
                uint16_t msglen;
        } session;
 
        /*
         * A union of the different possible payload meta-data
         */
        union {
                struct {
                        uint8_t rq_addr;
                        uint8_t netfn;
                        uint8_t rq_lun;
                        uint8_t rs_addr;
                        uint8_t rq_seq;
                        uint8_t rs_lun;
                        uint8_t cmd;
                } ipmi_response;
                struct {
                        uint8_t message_tag;
                        uint8_t rakp_return_code;
                        uint8_t max_priv_level;
                        uint32_t console_id;
                        uint32_t bmc_id;
                        uint8_t auth_alg;
                        uint8_t integrity_alg;
                        uint8_t crypt_alg;
                } open_session_response;
                struct {
                        uint8_t message_tag;
                        uint8_t rakp_return_code;
                        uint32_t console_id;
                        uint8_t bmc_rand[16];   /* Random number generated by the BMC */
                        uint8_t bmc_guid[16];
                        uint8_t key_exchange_auth_code[EVP_MAX_MD_SIZE];
                } rakp2_message;
                struct {
                        uint8_t message_tag;
                        uint8_t rakp_return_code;
                        uint32_t console_id;
                        uint8_t integrity_check_value[EVP_MAX_MD_SIZE];
                } rakp4_message;
                struct {
                        uint8_t packet_sequence_number;
                        uint8_t acked_packet_number;
                        uint8_t accepted_character_count;
                        uint8_t is_nack;        /* bool */
                        uint8_t transfer_unavailable;   /* bool */
                        uint8_t sol_inactive;   /* bool */
                        uint8_t transmit_overrun;       /* bool */
                        uint8_t break_detected; /* bool */
                } sol_packet;
 
        } payload;
};
#endif

struct ipmi_v2_payload {
	uint16_t payload_length;
	uint8_t payload_type;

	union {

		struct {
			uint8_t rq_seq;
			struct ipmi_rq *request;
		} ipmi_request;

		struct {
			uint8_t rs_seq;
			struct ipmi_rs *response;
		} ipmi_response;

		/* Only used internally by the lanplus interface */
		struct {
			uint8_t *request;
		} open_session_request;

		/* Only used internally by the lanplus interface */
		struct {
			uint8_t *message;
		} rakp_1_message;

		/* Only used internally by the lanplus interface */
		struct {
			uint8_t *message;
		} rakp_2_message;

		/* Only used internally by the lanplus interface */
		struct {
			uint8_t *message;
		} rakp_3_message;

		/* Only used internally by the lanplus interface */
		struct {
			uint8_t *message;
		} rakp_4_message;

		struct {
			uint8_t data[IPMI_BUF_SIZE];
			uint16_t character_count;
			uint8_t packet_sequence_number;
			uint8_t acked_packet_number;
			uint8_t accepted_character_count;
			uint8_t is_nack;	/* bool */
			uint8_t assert_ring_wor;	/* bool */
			uint8_t generate_break;	/* bool */
			uint8_t deassert_cts;	/* bool */
			uint8_t deassert_dcd_dsr;	/* bool */
			uint8_t flush_inbound;	/* bool */
			uint8_t flush_outbound;	/* bool */
		} sol_packet;

	} payload;
};
#endif
/**************************************/

/* define ipmi_intf locally */
/*
 * An enumeration that describes every possible session state for
 * an IPMIv2 / RMCP+ session.
 */
enum LANPLUS_SESSION_STATE {
	LANPLUS_STATE_PRESESSION = 0,
	LANPLUS_STATE_OPEN_SESSION_SENT,
	LANPLUS_STATE_OPEN_SESSION_RECEIEVED,
	LANPLUS_STATE_RAKP_1_SENT,
	LANPLUS_STATE_RAKP_2_RECEIVED,
	LANPLUS_STATE_RAKP_3_SENT,
	LANPLUS_STATE_ACTIVE,
	LANPLUS_STATE_CLOSE_SENT,
};


#define IPMI_AUTHCODE_BUFFER_SIZE 20 // KG or KUID
#define IPMI_SIK_BUFFER_SIZE      EVP_MAX_MD_SIZE
#define IPMI_KG_BUFFER_SIZE       21 /* key plus null byte */

struct ipmi_session {
	uint8_t hostname[64];
	uint8_t username[17];
	uint8_t authcode[IPMI_AUTHCODE_BUFFER_SIZE + 1];
	uint8_t challenge[16];
	uint8_t authtype;
	uint8_t authtype_set;
#define IPMI_AUTHSTATUS_PER_MSG_DISABLED	0x10
#define IPMI_AUTHSTATUS_PER_USER_DISABLED	0x08
#define IPMI_AUTHSTATUS_NONNULL_USERS_ENABLED	0x04
#define IPMI_AUTHSTATUS_NULL_USERS_ENABLED	0x02
#define IPMI_AUTHSTATUS_ANONYMOUS_USERS_ENABLED	0x01
	uint8_t authstatus;
	uint8_t authextra;
	uint8_t privlvl;
	uint8_t cipher_suite_id;
	char sol_escape_char;
	int password;
	int port;
	int active;
	int retry;

	uint32_t session_id;
	uint32_t in_seq;
	uint32_t out_seq;
	uint32_t timeout;

#ifdef HAVE_IPV6
	/* struct sockaddr_storage addr;  *causes rest of structure to break */
	struct sockaddr_in addr;
#else
	struct sockaddr_in addr;
#endif
	socklen_t addrlen;

	/*
	 * This struct holds state data specific to IMPI v2 / RMCP+ sessions
	 */
	struct {
		enum LANPLUS_SESSION_STATE session_state;

		/* These are the algorithms agreed upon for the session */
		uint8_t requested_auth_alg;
		uint8_t requested_integrity_alg;
		uint8_t requested_crypt_alg;
		uint8_t auth_alg;
		uint8_t integrity_alg;
		uint8_t crypt_alg;
		uint8_t max_priv_level;

		uint32_t console_id;
		uint32_t bmc_id;

		/*
		 * Values required for RAKP mesages
		 */

		/* Random number generated byt the console */
		uint8_t console_rand[16]; 
		/* Random number generated by the BMC */
		uint8_t bmc_rand[16];

		uint8_t bmc_guid[16];
		uint8_t requested_role;   /* As sent in the RAKP 1 message */
		uint8_t rakp2_return_code;

		uint8_t sik[EVP_MAX_MD_SIZE]; /* Session integrity key */
		uint8_t kg[IPMI_KG_BUFFER_SIZE];   /* BMC key */
		uint8_t k1[EVP_MAX_MD_SIZE]; /* Used for Integrity checking? */
		uint8_t k2[EVP_MAX_MD_SIZE]; /* First 16 bytes used for AES  */
		uint8_t sik_len;  /* length of sik */
		uint8_t k1_len;   /* length of k1 */
		uint8_t k2_len;   /* length of k2 */
	} v2_data;


	/*
	 * This data is specific to the Serial Over Lan session
	 */
	struct {
		uint16_t max_inbound_payload_size;
		uint16_t max_outbound_payload_size;
		uint16_t port;
		uint8_t sequence_number;

		/*  This data describes the last SOL packet */
		uint8_t last_received_sequence_number;
		uint8_t last_received_byte_count;
		void (*sol_input_handler)(struct ipmi_rs * rsp);
	} sol_data;
};

struct ipmi_intf_support {
	const char * name;
	int supported;
};

struct ipmi_intf {
	char name[16];
	char desc[128];
	SockType fd;
	int opened;
	int abort;
	int noanswer;

	struct ipmi_session * session;
	struct ipmi_oem_handle * oem;
	struct ipmi_cmd * cmdlist;
	uint32_t my_addr;
	uint32_t target_addr;
	uint8_t target_lun;
	uint8_t target_channel;
        uint32_t transit_addr;
        uint8_t transit_channel;
        uint8_t devnum;

	int (*setup)(struct ipmi_intf * intf);
	int (*open)(struct ipmi_intf * intf);
	void (*close)(struct ipmi_intf * intf);
	struct ipmi_rs *(*sendrecv)(struct ipmi_intf * intf, struct ipmi_rq * req);
	int (*sendrsp)(struct ipmi_intf * intf, struct ipmi_rs * rsp);
	struct ipmi_rs *(*recv_sol)(struct ipmi_intf * intf);
	struct ipmi_rs *(*send_sol)(struct ipmi_intf * intf, void *payload);
                                 /*struct ipmi_v2_payload * payload);*/
	int (*keepalive)(struct ipmi_intf * intf);
};

struct ipmi_cmd {
	int (*func)(struct ipmi_intf * intf, int argc, char ** argv);
	const char * name;
	const char * desc;
};

#endif /* lanplus_defs.h */
