#!/bin/sh -e

VERSION=$2
PACKAGE=$(dpkg-parsechangelog | sed -n 's/^Source: //p')
TAR=../${PACKAGE}_${VERSION}+dfsg.orig.tar.gz
TARPOMS=../${PACKAGE}_${VERSION}+dfsg.orig-maven.tar.gz
DIR=${PACKAGE}-${VERSION}

# svn checkout sources
svn export http://svn.codehaus.org/jmock/tags/${VERSION} $DIR
# svn checkout maven poms
svn export http://svn.codehaus.org/jmock/tags/packaging-maven-${VERSION} $DIR/maven
GZIP=--best tar -c -z -f $TAR --exclude '*.jar' --exclude '*.class' $DIR
rm -rf $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir && echo "moved $TAR to $origDir"
fi

