/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.validation;

import java.util.Locale;
import java.util.MissingResourceException;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.localization.LocalizationUtility;
import net.sourceforge.stripes.validation.SimpleError;

public class LocalizableError
extends SimpleError {
    private static final long serialVersionUID = 1L;
    private String messageKey;

    public LocalizableError(String messageKey, Object ... parameter) {
        super(null, parameter);
        this.messageKey = messageKey;
    }

    protected String getMessageTemplate(Locale locale) {
        String actionPath;
        String template = null;
        Class<? extends ActionBean> beanclass = this.getBeanclass();
        if (beanclass != null) {
            template = LocalizationUtility.getErrorMessage(locale, beanclass.getName() + "." + this.messageKey);
        }
        if (template == null && (actionPath = this.getActionPath()) != null) {
            template = LocalizationUtility.getErrorMessage(locale, actionPath + "." + this.messageKey);
        }
        if (template == null) {
            template = LocalizationUtility.getErrorMessage(locale, this.messageKey);
        }
        if (template == null) {
            throw new MissingResourceException("Could not find an error message with key: " + this.messageKey, null, null);
        }
        return template;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LocalizableError that = (LocalizableError)o;
        return !(this.messageKey != null ? !this.messageKey.equals(that.messageKey) : that.messageKey != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.messageKey != null ? this.messageKey.hashCode() : 0);
        return result;
    }

    public String getMessageKey() {
        return this.messageKey;
    }
}

