/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1SequenceParser;
import org.bouncycastle.asn1.ASN1SetParser;
import org.bouncycastle.asn1.ASN1TaggedObjectParser;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.cms.EncryptedContentInfoParser;

public class EnvelopedDataParser {
    private ASN1SequenceParser _seq;
    private DERInteger _version;
    private DEREncodable _nextObject;

    public EnvelopedDataParser(ASN1SequenceParser aSN1SequenceParser) throws IOException {
        this._seq = aSN1SequenceParser;
        this._version = (DERInteger)aSN1SequenceParser.readObject();
    }

    public DERInteger getVersion() {
        return this._version;
    }

    public ASN1SetParser getCertificates() throws IOException {
        this._nextObject = this._seq.readObject();
        if (this._nextObject instanceof ASN1TaggedObjectParser && ((ASN1TaggedObjectParser)this._nextObject).getTagNo() == 0) {
            ASN1SetParser aSN1SetParser = (ASN1SetParser)((ASN1TaggedObjectParser)this._nextObject).getObjectParser(17, false);
            this._nextObject = null;
            return aSN1SetParser;
        }
        return null;
    }

    public ASN1SetParser getCrls() throws IOException {
        if (this._nextObject == null) {
            this._nextObject = this._seq.readObject();
        }
        if (this._nextObject instanceof ASN1TaggedObjectParser && ((ASN1TaggedObjectParser)this._nextObject).getTagNo() == 1) {
            ASN1SetParser aSN1SetParser = (ASN1SetParser)((ASN1TaggedObjectParser)this._nextObject).getObjectParser(17, false);
            this._nextObject = null;
            return aSN1SetParser;
        }
        return null;
    }

    public ASN1SetParser getRecipientInfos() throws IOException {
        return (ASN1SetParser)this._seq.readObject();
    }

    public EncryptedContentInfoParser getEncryptedContentInfo() throws IOException {
        return new EncryptedContentInfoParser((ASN1SequenceParser)this._seq.readObject());
    }

    public ASN1SetParser getUnprotectedAttrs() throws IOException {
        DEREncodable dEREncodable = this._seq.readObject();
        if (dEREncodable != null) {
            return (ASN1SetParser)((ASN1TaggedObjectParser)dEREncodable).getObjectParser(17, false);
        }
        return null;
    }
}

