
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQPalette.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QPalette>
#include <QBrush>
#include <QColor>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QPalette

//  Constructor QPalette::QPalette()


static void _init_ctor_QPalette_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QPalette> ();
}

static void _call_ctor_QPalette_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPalette *> (new QPalette ());
}


//  Constructor QPalette::QPalette(const QColor &button)


static void _init_ctor_QPalette_1905 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<const QColor & > (argspec_0);
  decl->set_return_new<QPalette> ();
}

static void _call_ctor_QPalette_1905 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QColor &arg1 = gsi::arg_reader<const QColor & >() (args, heap);
  ret.write<QPalette *> (new QPalette (arg1));
}


//  Constructor QPalette::QPalette(Qt::GlobalColor button)


static void _init_ctor_QPalette_1853 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<const qt_gsi::Converter<Qt::GlobalColor>::target_type & > (argspec_0);
  decl->set_return_new<QPalette> ();
}

static void _call_ctor_QPalette_1853 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::GlobalColor>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::GlobalColor>::target_type & >() (args, heap);
  ret.write<QPalette *> (new QPalette (qt_gsi::QtToCppAdaptor<Qt::GlobalColor>(arg1).cref()));
}


//  Constructor QPalette::QPalette(const QColor &button, const QColor &window)


static void _init_ctor_QPalette_3702 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<const QColor & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("window");
  decl->add_arg<const QColor & > (argspec_1);
  decl->set_return_new<QPalette> ();
}

static void _call_ctor_QPalette_3702 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QColor &arg1 = gsi::arg_reader<const QColor & >() (args, heap);
  const QColor &arg2 = gsi::arg_reader<const QColor & >() (args, heap);
  ret.write<QPalette *> (new QPalette (arg1, arg2));
}


//  Constructor QPalette::QPalette(const QBrush &windowText, const QBrush &button, const QBrush &light, const QBrush &dark, const QBrush &mid, const QBrush &text, const QBrush &bright_text, const QBrush &base, const QBrush &window)


static void _init_ctor_QPalette_16326 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("windowText");
  decl->add_arg<const QBrush & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("button");
  decl->add_arg<const QBrush & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("light");
  decl->add_arg<const QBrush & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("dark");
  decl->add_arg<const QBrush & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("mid");
  decl->add_arg<const QBrush & > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("text");
  decl->add_arg<const QBrush & > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("bright_text");
  decl->add_arg<const QBrush & > (argspec_6);
  static gsi::ArgSpecBase argspec_7 ("base");
  decl->add_arg<const QBrush & > (argspec_7);
  static gsi::ArgSpecBase argspec_8 ("window");
  decl->add_arg<const QBrush & > (argspec_8);
  decl->set_return_new<QPalette> ();
}

static void _call_ctor_QPalette_16326 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QBrush &arg1 = gsi::arg_reader<const QBrush & >() (args, heap);
  const QBrush &arg2 = gsi::arg_reader<const QBrush & >() (args, heap);
  const QBrush &arg3 = gsi::arg_reader<const QBrush & >() (args, heap);
  const QBrush &arg4 = gsi::arg_reader<const QBrush & >() (args, heap);
  const QBrush &arg5 = gsi::arg_reader<const QBrush & >() (args, heap);
  const QBrush &arg6 = gsi::arg_reader<const QBrush & >() (args, heap);
  const QBrush &arg7 = gsi::arg_reader<const QBrush & >() (args, heap);
  const QBrush &arg8 = gsi::arg_reader<const QBrush & >() (args, heap);
  const QBrush &arg9 = gsi::arg_reader<const QBrush & >() (args, heap);
  ret.write<QPalette *> (new QPalette (arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9));
}


//  Constructor QPalette::QPalette(const QColor &windowText, const QColor &window, const QColor &light, const QColor &dark, const QColor &mid, const QColor &text, const QColor &base)


static void _init_ctor_QPalette_12687 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("windowText");
  decl->add_arg<const QColor & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("window");
  decl->add_arg<const QColor & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("light");
  decl->add_arg<const QColor & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("dark");
  decl->add_arg<const QColor & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("mid");
  decl->add_arg<const QColor & > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("text");
  decl->add_arg<const QColor & > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("base");
  decl->add_arg<const QColor & > (argspec_6);
  decl->set_return_new<QPalette> ();
}

static void _call_ctor_QPalette_12687 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QColor &arg1 = gsi::arg_reader<const QColor & >() (args, heap);
  const QColor &arg2 = gsi::arg_reader<const QColor & >() (args, heap);
  const QColor &arg3 = gsi::arg_reader<const QColor & >() (args, heap);
  const QColor &arg4 = gsi::arg_reader<const QColor & >() (args, heap);
  const QColor &arg5 = gsi::arg_reader<const QColor & >() (args, heap);
  const QColor &arg6 = gsi::arg_reader<const QColor & >() (args, heap);
  const QColor &arg7 = gsi::arg_reader<const QColor & >() (args, heap);
  ret.write<QPalette *> (new QPalette (arg1, arg2, arg3, arg4, arg5, arg6, arg7));
}


//  Constructor QPalette::QPalette(const QPalette &palette)


static void _init_ctor_QPalette_2113 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("palette");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return_new<QPalette> ();
}

static void _call_ctor_QPalette_2113 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPalette &arg1 = gsi::arg_reader<const QPalette & >() (args, heap);
  ret.write<QPalette *> (new QPalette (arg1));
}


// const QBrush &QPalette::alternateBase()


static void _init_f_alternateBase_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_alternateBase_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->alternateBase ());
}


// const QBrush &QPalette::background()


static void _init_f_background_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_background_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->background ());
}


// const QBrush &QPalette::base()


static void _init_f_base_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_base_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->base ());
}


// const QBrush &QPalette::brightText()


static void _init_f_brightText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_brightText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->brightText ());
}


// const QBrush &QPalette::brush(QPalette::ColorGroup cg, QPalette::ColorRole cr)


static void _init_f_brush_c4545 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cg");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("cr");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (argspec_1);
  decl->set_return<const QBrush & > ();
}

static void _call_f_brush_c4545 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPalette::ColorGroup>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & >() (args, heap);
  const qt_gsi::Converter<QPalette::ColorRole>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QPalette::ColorRole>::target_type & >() (args, heap);
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->brush (qt_gsi::QtToCppAdaptor<QPalette::ColorGroup>(arg1).cref(), qt_gsi::QtToCppAdaptor<QPalette::ColorRole>(arg2).cref()));
}


// const QBrush &QPalette::brush(QPalette::ColorRole cr)


static void _init_f_brush_c2265 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cr");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (argspec_0);
  decl->set_return<const QBrush & > ();
}

static void _call_f_brush_c2265 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPalette::ColorRole>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPalette::ColorRole>::target_type & >() (args, heap);
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->brush (qt_gsi::QtToCppAdaptor<QPalette::ColorRole>(arg1).cref()));
}


// const QBrush &QPalette::button()


static void _init_f_button_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_button_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->button ());
}


// const QBrush &QPalette::buttonText()


static void _init_f_buttonText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_buttonText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->buttonText ());
}


// qint64 QPalette::cacheKey()


static void _init_f_cacheKey_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_cacheKey_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QPalette *)cls)->cacheKey ());
}


// const QColor &QPalette::color(QPalette::ColorGroup cg, QPalette::ColorRole cr)


static void _init_f_color_c4545 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cg");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("cr");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (argspec_1);
  decl->set_return<const QColor & > ();
}

static void _call_f_color_c4545 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPalette::ColorGroup>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & >() (args, heap);
  const qt_gsi::Converter<QPalette::ColorRole>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QPalette::ColorRole>::target_type & >() (args, heap);
  ret.write<const QColor & > ((const QColor &)((QPalette *)cls)->color (qt_gsi::QtToCppAdaptor<QPalette::ColorGroup>(arg1).cref(), qt_gsi::QtToCppAdaptor<QPalette::ColorRole>(arg2).cref()));
}


// const QColor &QPalette::color(QPalette::ColorRole cr)


static void _init_f_color_c2265 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cr");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (argspec_0);
  decl->set_return<const QColor & > ();
}

static void _call_f_color_c2265 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPalette::ColorRole>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPalette::ColorRole>::target_type & >() (args, heap);
  ret.write<const QColor & > ((const QColor &)((QPalette *)cls)->color (qt_gsi::QtToCppAdaptor<QPalette::ColorRole>(arg1).cref()));
}


// QPalette::ColorGroup QPalette::currentColorGroup()


static void _init_f_currentColorGroup_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPalette::ColorGroup>::target_type > ();
}

static void _call_f_currentColorGroup_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QPalette::ColorGroup>::target_type > ((qt_gsi::Converter<QPalette::ColorGroup>::target_type)qt_gsi::CppToQtAdaptor<QPalette::ColorGroup>(((QPalette *)cls)->currentColorGroup ()));
}


// const QBrush &QPalette::dark()


static void _init_f_dark_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_dark_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->dark ());
}


// const QBrush &QPalette::foreground()


static void _init_f_foreground_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_foreground_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->foreground ());
}


// const QBrush &QPalette::highlight()


static void _init_f_highlight_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_highlight_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->highlight ());
}


// const QBrush &QPalette::highlightedText()


static void _init_f_highlightedText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_highlightedText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->highlightedText ());
}


// bool QPalette::isBrushSet(QPalette::ColorGroup cg, QPalette::ColorRole cr)


static void _init_f_isBrushSet_c4545 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cg");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("cr");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_isBrushSet_c4545 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPalette::ColorGroup>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & >() (args, heap);
  const qt_gsi::Converter<QPalette::ColorRole>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QPalette::ColorRole>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QPalette *)cls)->isBrushSet (qt_gsi::QtToCppAdaptor<QPalette::ColorGroup>(arg1).cref(), qt_gsi::QtToCppAdaptor<QPalette::ColorRole>(arg2).cref()));
}


// bool QPalette::isCopyOf(const QPalette &p)


static void _init_f_isCopyOf_c2113 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isCopyOf_c2113 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPalette &arg1 = gsi::arg_reader<const QPalette & >() (args, heap);
  ret.write<bool > ((bool)((QPalette *)cls)->isCopyOf (arg1));
}


// bool QPalette::isEqual(QPalette::ColorGroup cr1, QPalette::ColorGroup cr2)


static void _init_f_isEqual_c4668 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cr1");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("cr2");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_isEqual_c4668 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPalette::ColorGroup>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & >() (args, heap);
  const qt_gsi::Converter<QPalette::ColorGroup>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QPalette *)cls)->isEqual (qt_gsi::QtToCppAdaptor<QPalette::ColorGroup>(arg1).cref(), qt_gsi::QtToCppAdaptor<QPalette::ColorGroup>(arg2).cref()));
}


// const QBrush &QPalette::light()


static void _init_f_light_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_light_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->light ());
}


// const QBrush &QPalette::link()


static void _init_f_link_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_link_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->link ());
}


// const QBrush &QPalette::linkVisited()


static void _init_f_linkVisited_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_linkVisited_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->linkVisited ());
}


// const QBrush &QPalette::mid()


static void _init_f_mid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_mid_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->mid ());
}


// const QBrush &QPalette::midlight()


static void _init_f_midlight_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_midlight_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->midlight ());
}


// bool QPalette::operator!=(const QPalette &p)


static void _init_f_operator_excl__eq__c2113 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c2113 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPalette &arg1 = gsi::arg_reader<const QPalette & >() (args, heap);
  ret.write<bool > ((bool)((QPalette *)cls)->operator!= (arg1));
}


// QPalette &QPalette::operator=(const QPalette &palette)


static void _init_f_operator_eq__2113 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("palette");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<QPalette & > ();
}

static void _call_f_operator_eq__2113 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPalette &arg1 = gsi::arg_reader<const QPalette & >() (args, heap);
  ret.write<QPalette & > ((QPalette &)((QPalette *)cls)->operator= (arg1));
}


// bool QPalette::operator==(const QPalette &p)


static void _init_f_operator_eq__eq__c2113 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c2113 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPalette &arg1 = gsi::arg_reader<const QPalette & >() (args, heap);
  ret.write<bool > ((bool)((QPalette *)cls)->operator== (arg1));
}


// QPalette QPalette::resolve(const QPalette &)


static void _init_f_resolve_c2113 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<QPalette > ();
}

static void _call_f_resolve_c2113 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPalette &arg1 = gsi::arg_reader<const QPalette & >() (args, heap);
  ret.write<QPalette > ((QPalette)((QPalette *)cls)->resolve (arg1));
}


// int QPalette::serialNumber()


static void _init_f_serialNumber_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_serialNumber_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPalette *)cls)->serialNumber ());
}


// void QPalette::setBrush(QPalette::ColorRole cr, const QBrush &brush)


static void _init_f_setBrush_4067 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cr");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("brush");
  decl->add_arg<const QBrush & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setBrush_4067 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPalette::ColorRole>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPalette::ColorRole>::target_type & >() (args, heap);
  const QBrush &arg2 = gsi::arg_reader<const QBrush & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPalette *)cls)->setBrush (qt_gsi::QtToCppAdaptor<QPalette::ColorRole>(arg1).cref(), arg2);
}


// void QPalette::setBrush(QPalette::ColorGroup cg, QPalette::ColorRole cr, const QBrush &brush)


static void _init_f_setBrush_6347 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cg");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("cr");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("brush");
  decl->add_arg<const QBrush & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setBrush_6347 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPalette::ColorGroup>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & >() (args, heap);
  const qt_gsi::Converter<QPalette::ColorRole>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QPalette::ColorRole>::target_type & >() (args, heap);
  const QBrush &arg3 = gsi::arg_reader<const QBrush & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPalette *)cls)->setBrush (qt_gsi::QtToCppAdaptor<QPalette::ColorGroup>(arg1).cref(), qt_gsi::QtToCppAdaptor<QPalette::ColorRole>(arg2).cref(), arg3);
}


// void QPalette::setColor(QPalette::ColorGroup cg, QPalette::ColorRole cr, const QColor &color)


static void _init_f_setColor_6342 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cg");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("cr");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("color");
  decl->add_arg<const QColor & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setColor_6342 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPalette::ColorGroup>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & >() (args, heap);
  const qt_gsi::Converter<QPalette::ColorRole>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QPalette::ColorRole>::target_type & >() (args, heap);
  const QColor &arg3 = gsi::arg_reader<const QColor & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPalette *)cls)->setColor (qt_gsi::QtToCppAdaptor<QPalette::ColorGroup>(arg1).cref(), qt_gsi::QtToCppAdaptor<QPalette::ColorRole>(arg2).cref(), arg3);
}


// void QPalette::setColor(QPalette::ColorRole cr, const QColor &color)


static void _init_f_setColor_4062 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cr");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("color");
  decl->add_arg<const QColor & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setColor_4062 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPalette::ColorRole>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPalette::ColorRole>::target_type & >() (args, heap);
  const QColor &arg2 = gsi::arg_reader<const QColor & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPalette *)cls)->setColor (qt_gsi::QtToCppAdaptor<QPalette::ColorRole>(arg1).cref(), arg2);
}


// void QPalette::setColorGroup(QPalette::ColorGroup cr, const QBrush &windowText, const QBrush &button, const QBrush &light, const QBrush &dark, const QBrush &mid, const QBrush &text, const QBrush &bright_text, const QBrush &base, const QBrush &window)


static void _init_f_setColorGroup_18606 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cr");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("windowText");
  decl->add_arg<const QBrush & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("button");
  decl->add_arg<const QBrush & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("light");
  decl->add_arg<const QBrush & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("dark");
  decl->add_arg<const QBrush & > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("mid");
  decl->add_arg<const QBrush & > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("text");
  decl->add_arg<const QBrush & > (argspec_6);
  static gsi::ArgSpecBase argspec_7 ("bright_text");
  decl->add_arg<const QBrush & > (argspec_7);
  static gsi::ArgSpecBase argspec_8 ("base");
  decl->add_arg<const QBrush & > (argspec_8);
  static gsi::ArgSpecBase argspec_9 ("window");
  decl->add_arg<const QBrush & > (argspec_9);
  decl->set_return<void > ();
}

static void _call_f_setColorGroup_18606 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPalette::ColorGroup>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & >() (args, heap);
  const QBrush &arg2 = gsi::arg_reader<const QBrush & >() (args, heap);
  const QBrush &arg3 = gsi::arg_reader<const QBrush & >() (args, heap);
  const QBrush &arg4 = gsi::arg_reader<const QBrush & >() (args, heap);
  const QBrush &arg5 = gsi::arg_reader<const QBrush & >() (args, heap);
  const QBrush &arg6 = gsi::arg_reader<const QBrush & >() (args, heap);
  const QBrush &arg7 = gsi::arg_reader<const QBrush & >() (args, heap);
  const QBrush &arg8 = gsi::arg_reader<const QBrush & >() (args, heap);
  const QBrush &arg9 = gsi::arg_reader<const QBrush & >() (args, heap);
  const QBrush &arg10 = gsi::arg_reader<const QBrush & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPalette *)cls)->setColorGroup (qt_gsi::QtToCppAdaptor<QPalette::ColorGroup>(arg1).cref(), arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
}


// void QPalette::setCurrentColorGroup(QPalette::ColorGroup cg)


static void _init_f_setCurrentColorGroup_2388 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cg");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentColorGroup_2388 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPalette::ColorGroup>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPalette *)cls)->setCurrentColorGroup (qt_gsi::QtToCppAdaptor<QPalette::ColorGroup>(arg1).cref());
}


// const QBrush &QPalette::shadow()


static void _init_f_shadow_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_shadow_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->shadow ());
}


// const QBrush &QPalette::text()


static void _init_f_text_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_text_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->text ());
}


// const QBrush &QPalette::toolTipBase()


static void _init_f_toolTipBase_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_toolTipBase_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->toolTipBase ());
}


// const QBrush &QPalette::toolTipText()


static void _init_f_toolTipText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_toolTipText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->toolTipText ());
}


// const QBrush &QPalette::window()


static void _init_f_window_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_window_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->window ());
}


// const QBrush &QPalette::windowText()


static void _init_f_windowText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_windowText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->windowText ());
}



namespace gsi
{

static gsi::Methods methods_QPalette () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPalette::QPalette()\nThis method creates an object of class QPalette.", &_init_ctor_QPalette_0, &_call_ctor_QPalette_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPalette::QPalette(const QColor &button)\nThis method creates an object of class QPalette.", &_init_ctor_QPalette_1905, &_call_ctor_QPalette_1905);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPalette::QPalette(Qt::GlobalColor button)\nThis method creates an object of class QPalette.", &_init_ctor_QPalette_1853, &_call_ctor_QPalette_1853);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPalette::QPalette(const QColor &button, const QColor &window)\nThis method creates an object of class QPalette.", &_init_ctor_QPalette_3702, &_call_ctor_QPalette_3702);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPalette::QPalette(const QBrush &windowText, const QBrush &button, const QBrush &light, const QBrush &dark, const QBrush &mid, const QBrush &text, const QBrush &bright_text, const QBrush &base, const QBrush &window)\nThis method creates an object of class QPalette.", &_init_ctor_QPalette_16326, &_call_ctor_QPalette_16326);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPalette::QPalette(const QColor &windowText, const QColor &window, const QColor &light, const QColor &dark, const QColor &mid, const QColor &text, const QColor &base)\nThis method creates an object of class QPalette.", &_init_ctor_QPalette_12687, &_call_ctor_QPalette_12687);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPalette::QPalette(const QPalette &palette)\nThis method creates an object of class QPalette.", &_init_ctor_QPalette_2113, &_call_ctor_QPalette_2113);
  methods += new qt_gsi::GenericMethod ("alternateBase", "@brief Method const QBrush &QPalette::alternateBase()\n", true, &_init_f_alternateBase_c0, &_call_f_alternateBase_c0);
  methods += new qt_gsi::GenericMethod ("background", "@brief Method const QBrush &QPalette::background()\n", true, &_init_f_background_c0, &_call_f_background_c0);
  methods += new qt_gsi::GenericMethod ("base", "@brief Method const QBrush &QPalette::base()\n", true, &_init_f_base_c0, &_call_f_base_c0);
  methods += new qt_gsi::GenericMethod ("brightText", "@brief Method const QBrush &QPalette::brightText()\n", true, &_init_f_brightText_c0, &_call_f_brightText_c0);
  methods += new qt_gsi::GenericMethod ("brush", "@brief Method const QBrush &QPalette::brush(QPalette::ColorGroup cg, QPalette::ColorRole cr)\n", true, &_init_f_brush_c4545, &_call_f_brush_c4545);
  methods += new qt_gsi::GenericMethod ("brush", "@brief Method const QBrush &QPalette::brush(QPalette::ColorRole cr)\n", true, &_init_f_brush_c2265, &_call_f_brush_c2265);
  methods += new qt_gsi::GenericMethod ("button", "@brief Method const QBrush &QPalette::button()\n", true, &_init_f_button_c0, &_call_f_button_c0);
  methods += new qt_gsi::GenericMethod ("buttonText", "@brief Method const QBrush &QPalette::buttonText()\n", true, &_init_f_buttonText_c0, &_call_f_buttonText_c0);
  methods += new qt_gsi::GenericMethod ("cacheKey", "@brief Method qint64 QPalette::cacheKey()\n", true, &_init_f_cacheKey_c0, &_call_f_cacheKey_c0);
  methods += new qt_gsi::GenericMethod ("color", "@brief Method const QColor &QPalette::color(QPalette::ColorGroup cg, QPalette::ColorRole cr)\n", true, &_init_f_color_c4545, &_call_f_color_c4545);
  methods += new qt_gsi::GenericMethod ("color", "@brief Method const QColor &QPalette::color(QPalette::ColorRole cr)\n", true, &_init_f_color_c2265, &_call_f_color_c2265);
  methods += new qt_gsi::GenericMethod (":currentColorGroup", "@brief Method QPalette::ColorGroup QPalette::currentColorGroup()\n", true, &_init_f_currentColorGroup_c0, &_call_f_currentColorGroup_c0);
  methods += new qt_gsi::GenericMethod ("dark", "@brief Method const QBrush &QPalette::dark()\n", true, &_init_f_dark_c0, &_call_f_dark_c0);
  methods += new qt_gsi::GenericMethod ("foreground", "@brief Method const QBrush &QPalette::foreground()\n", true, &_init_f_foreground_c0, &_call_f_foreground_c0);
  methods += new qt_gsi::GenericMethod ("highlight", "@brief Method const QBrush &QPalette::highlight()\n", true, &_init_f_highlight_c0, &_call_f_highlight_c0);
  methods += new qt_gsi::GenericMethod ("highlightedText", "@brief Method const QBrush &QPalette::highlightedText()\n", true, &_init_f_highlightedText_c0, &_call_f_highlightedText_c0);
  methods += new qt_gsi::GenericMethod ("isBrushSet?", "@brief Method bool QPalette::isBrushSet(QPalette::ColorGroup cg, QPalette::ColorRole cr)\n", true, &_init_f_isBrushSet_c4545, &_call_f_isBrushSet_c4545);
  methods += new qt_gsi::GenericMethod ("isCopyOf?", "@brief Method bool QPalette::isCopyOf(const QPalette &p)\n", true, &_init_f_isCopyOf_c2113, &_call_f_isCopyOf_c2113);
  methods += new qt_gsi::GenericMethod ("isEqual?", "@brief Method bool QPalette::isEqual(QPalette::ColorGroup cr1, QPalette::ColorGroup cr2)\n", true, &_init_f_isEqual_c4668, &_call_f_isEqual_c4668);
  methods += new qt_gsi::GenericMethod ("light", "@brief Method const QBrush &QPalette::light()\n", true, &_init_f_light_c0, &_call_f_light_c0);
  methods += new qt_gsi::GenericMethod ("link", "@brief Method const QBrush &QPalette::link()\n", true, &_init_f_link_c0, &_call_f_link_c0);
  methods += new qt_gsi::GenericMethod ("linkVisited", "@brief Method const QBrush &QPalette::linkVisited()\n", true, &_init_f_linkVisited_c0, &_call_f_linkVisited_c0);
  methods += new qt_gsi::GenericMethod ("mid", "@brief Method const QBrush &QPalette::mid()\n", true, &_init_f_mid_c0, &_call_f_mid_c0);
  methods += new qt_gsi::GenericMethod ("midlight", "@brief Method const QBrush &QPalette::midlight()\n", true, &_init_f_midlight_c0, &_call_f_midlight_c0);
  methods += new qt_gsi::GenericMethod ("!=", "@brief Method bool QPalette::operator!=(const QPalette &p)\n", true, &_init_f_operator_excl__eq__c2113, &_call_f_operator_excl__eq__c2113);
  methods += new qt_gsi::GenericMethod ("assign", "@brief Method QPalette &QPalette::operator=(const QPalette &palette)\n", false, &_init_f_operator_eq__2113, &_call_f_operator_eq__2113);
  methods += new qt_gsi::GenericMethod ("==", "@brief Method bool QPalette::operator==(const QPalette &p)\n", true, &_init_f_operator_eq__eq__c2113, &_call_f_operator_eq__eq__c2113);
  methods += new qt_gsi::GenericMethod ("resolve", "@brief Method QPalette QPalette::resolve(const QPalette &)\n", true, &_init_f_resolve_c2113, &_call_f_resolve_c2113);
  methods += new qt_gsi::GenericMethod ("serialNumber", "@brief Method int QPalette::serialNumber()\n", true, &_init_f_serialNumber_c0, &_call_f_serialNumber_c0);
  methods += new qt_gsi::GenericMethod ("setBrush", "@brief Method void QPalette::setBrush(QPalette::ColorRole cr, const QBrush &brush)\n", false, &_init_f_setBrush_4067, &_call_f_setBrush_4067);
  methods += new qt_gsi::GenericMethod ("setBrush", "@brief Method void QPalette::setBrush(QPalette::ColorGroup cg, QPalette::ColorRole cr, const QBrush &brush)\n", false, &_init_f_setBrush_6347, &_call_f_setBrush_6347);
  methods += new qt_gsi::GenericMethod ("setColor", "@brief Method void QPalette::setColor(QPalette::ColorGroup cg, QPalette::ColorRole cr, const QColor &color)\n", false, &_init_f_setColor_6342, &_call_f_setColor_6342);
  methods += new qt_gsi::GenericMethod ("setColor", "@brief Method void QPalette::setColor(QPalette::ColorRole cr, const QColor &color)\n", false, &_init_f_setColor_4062, &_call_f_setColor_4062);
  methods += new qt_gsi::GenericMethod ("setColorGroup", "@brief Method void QPalette::setColorGroup(QPalette::ColorGroup cr, const QBrush &windowText, const QBrush &button, const QBrush &light, const QBrush &dark, const QBrush &mid, const QBrush &text, const QBrush &bright_text, const QBrush &base, const QBrush &window)\n", false, &_init_f_setColorGroup_18606, &_call_f_setColorGroup_18606);
  methods += new qt_gsi::GenericMethod ("setCurrentColorGroup|currentColorGroup=", "@brief Method void QPalette::setCurrentColorGroup(QPalette::ColorGroup cg)\n", false, &_init_f_setCurrentColorGroup_2388, &_call_f_setCurrentColorGroup_2388);
  methods += new qt_gsi::GenericMethod ("shadow", "@brief Method const QBrush &QPalette::shadow()\n", true, &_init_f_shadow_c0, &_call_f_shadow_c0);
  methods += new qt_gsi::GenericMethod ("text", "@brief Method const QBrush &QPalette::text()\n", true, &_init_f_text_c0, &_call_f_text_c0);
  methods += new qt_gsi::GenericMethod ("toolTipBase", "@brief Method const QBrush &QPalette::toolTipBase()\n", true, &_init_f_toolTipBase_c0, &_call_f_toolTipBase_c0);
  methods += new qt_gsi::GenericMethod ("toolTipText", "@brief Method const QBrush &QPalette::toolTipText()\n", true, &_init_f_toolTipText_c0, &_call_f_toolTipText_c0);
  methods += new qt_gsi::GenericMethod ("window", "@brief Method const QBrush &QPalette::window()\n", true, &_init_f_window_c0, &_call_f_window_c0);
  methods += new qt_gsi::GenericMethod ("windowText", "@brief Method const QBrush &QPalette::windowText()\n", true, &_init_f_windowText_c0, &_call_f_windowText_c0);
  return methods;
}

gsi::Class<QPalette> decl_QPalette ("QtGui", "QPalette",
  methods_QPalette (),
  "@qt\n@brief Binding of QPalette");


GSI_QTGUI_PUBLIC gsi::Class<QPalette> &qtdecl_QPalette () { return decl_QPalette; }

}


//  Implementation of the enum wrapper class for QPalette::ColorGroup
namespace qt_gsi
{

static gsi::Enum<QPalette::ColorGroup> decl_QPalette_ColorGroup_Enum ("QtGui", "QPalette_ColorGroup",
    gsi::enum_const ("Active", QPalette::Active, "@brief Enum constant QPalette::Active") +
    gsi::enum_const ("Disabled", QPalette::Disabled, "@brief Enum constant QPalette::Disabled") +
    gsi::enum_const ("Inactive", QPalette::Inactive, "@brief Enum constant QPalette::Inactive") +
    gsi::enum_const ("NColorGroups", QPalette::NColorGroups, "@brief Enum constant QPalette::NColorGroups") +
    gsi::enum_const ("Current", QPalette::Current, "@brief Enum constant QPalette::Current") +
    gsi::enum_const ("All", QPalette::All, "@brief Enum constant QPalette::All") +
    gsi::enum_const ("Normal", QPalette::Normal, "@brief Enum constant QPalette::Normal"),
  "@qt\n@brief This class represents the QPalette::ColorGroup enum");

static gsi::QFlagsClass<QPalette::ColorGroup > decl_QPalette_ColorGroup_Enums ("QtGui", "QPalette_QFlags_ColorGroup",
  "@qt\n@brief This class represents the QFlags<QPalette::ColorGroup> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QPalette> inject_QPalette_ColorGroup_Enum_in_parent (decl_QPalette_ColorGroup_Enum.defs ());
static gsi::ClassExt<QPalette> decl_QPalette_ColorGroup_Enum_as_child (decl_QPalette_ColorGroup_Enum, "ColorGroup");
static gsi::ClassExt<QPalette> decl_QPalette_ColorGroup_Enums_as_child (decl_QPalette_ColorGroup_Enums, "QFlags_ColorGroup");

}


//  Implementation of the enum wrapper class for QPalette::ColorRole
namespace qt_gsi
{

static gsi::Enum<QPalette::ColorRole> decl_QPalette_ColorRole_Enum ("QtGui", "QPalette_ColorRole",
    gsi::enum_const ("WindowText", QPalette::WindowText, "@brief Enum constant QPalette::WindowText") +
    gsi::enum_const ("Button", QPalette::Button, "@brief Enum constant QPalette::Button") +
    gsi::enum_const ("Light", QPalette::Light, "@brief Enum constant QPalette::Light") +
    gsi::enum_const ("Midlight", QPalette::Midlight, "@brief Enum constant QPalette::Midlight") +
    gsi::enum_const ("Dark", QPalette::Dark, "@brief Enum constant QPalette::Dark") +
    gsi::enum_const ("Mid", QPalette::Mid, "@brief Enum constant QPalette::Mid") +
    gsi::enum_const ("Text", QPalette::Text, "@brief Enum constant QPalette::Text") +
    gsi::enum_const ("BrightText", QPalette::BrightText, "@brief Enum constant QPalette::BrightText") +
    gsi::enum_const ("ButtonText", QPalette::ButtonText, "@brief Enum constant QPalette::ButtonText") +
    gsi::enum_const ("Base", QPalette::Base, "@brief Enum constant QPalette::Base") +
    gsi::enum_const ("Window", QPalette::Window, "@brief Enum constant QPalette::Window") +
    gsi::enum_const ("Shadow", QPalette::Shadow, "@brief Enum constant QPalette::Shadow") +
    gsi::enum_const ("Highlight", QPalette::Highlight, "@brief Enum constant QPalette::Highlight") +
    gsi::enum_const ("HighlightedText", QPalette::HighlightedText, "@brief Enum constant QPalette::HighlightedText") +
    gsi::enum_const ("Link", QPalette::Link, "@brief Enum constant QPalette::Link") +
    gsi::enum_const ("LinkVisited", QPalette::LinkVisited, "@brief Enum constant QPalette::LinkVisited") +
    gsi::enum_const ("AlternateBase", QPalette::AlternateBase, "@brief Enum constant QPalette::AlternateBase") +
    gsi::enum_const ("NoRole", QPalette::NoRole, "@brief Enum constant QPalette::NoRole") +
    gsi::enum_const ("ToolTipBase", QPalette::ToolTipBase, "@brief Enum constant QPalette::ToolTipBase") +
    gsi::enum_const ("ToolTipText", QPalette::ToolTipText, "@brief Enum constant QPalette::ToolTipText") +
    gsi::enum_const ("NColorRoles", QPalette::NColorRoles, "@brief Enum constant QPalette::NColorRoles") +
    gsi::enum_const ("Foreground", QPalette::Foreground, "@brief Enum constant QPalette::Foreground") +
    gsi::enum_const ("Background", QPalette::Background, "@brief Enum constant QPalette::Background"),
  "@qt\n@brief This class represents the QPalette::ColorRole enum");

static gsi::QFlagsClass<QPalette::ColorRole > decl_QPalette_ColorRole_Enums ("QtGui", "QPalette_QFlags_ColorRole",
  "@qt\n@brief This class represents the QFlags<QPalette::ColorRole> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QPalette> inject_QPalette_ColorRole_Enum_in_parent (decl_QPalette_ColorRole_Enum.defs ());
static gsi::ClassExt<QPalette> decl_QPalette_ColorRole_Enum_as_child (decl_QPalette_ColorRole_Enum, "ColorRole");
static gsi::ClassExt<QPalette> decl_QPalette_ColorRole_Enums_as_child (decl_QPalette_ColorRole_Enums, "QFlags_ColorRole");

}

