/***************************************************************************
 *   Copyright (C) 2005-2013 by Georg Hennig                               *
 *   Email: georg.hennig@web.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KFILEITEMEXT_H_
#define _KFILEITEMEXT_H_

#include <QMutex>

#include <KFileItem>

class KMD5;
class KUrl;
class QString;
class KomparatorWidget;
class KTemporaryFile;

enum CUSTOM_EVENT_TYPES
{
	RESULT_DUPLICATE = 12345,
	RESULT_COMP_MISSING,
	RESULT_COMP_NEWER,
	RESULT_COMP_NEWER_EQUAL,
	RESULT_COMP_DIFFERENT,
	RESULT_COMP_FINISHED,
	RESULT_EMPTY_FINISHED,
	RESULT_COPY_FINISHED,
	RESULT_MOVE_FINISHED,
	RESULT_REMOVE_FINISHED,
	DOWNLOAD_FILE,
	DELETE_FILE,
	PROGRESS_PROGRESS,
	MESSAGE_ERROR,
	INTERACTION_MAKEDIR,
	INTERACTION_COPY,
	INTERACTION_MOVE,
	INTERACTION_RESULT
};

class KFileItemExt : public QObject, public KFileItem
{
	Q_OBJECT

	public:
		KFileItemExt( const KIO::UDSEntry &_entry, const KUrl &_url,
			bool _determineMimeTypeOnDemand = false, bool _urlIsDirectory = false );
		KFileItemExt( mode_t _mode, mode_t _permissions, const KUrl &_url,
			bool _determineMimeTypeOnDemand = false );
		KFileItemExt( const KUrl &url, const QString &mimeType, mode_t mode );
		KFileItemExt( const KFileItem &item );
		KFileItemExt( const KFileItemExt &item );
		~KFileItemExt();

		QByteArray MD5( KomparatorWidget *parent, bool force_recalculate = false ); // returns MD5 sum of the file. will be calculated
			// only the first time and then stored in "md5". To be run from non-gui thread komparejob.
		QByteArray MD5( bool force_recalculate = false ); // this is run from gui thread only. Cannot be canceled.
		QString getFile( KomparatorWidget *parent ); // returns path to (temporary if remote) local file
		void deleteFile( KomparatorWidget *parent ); // deletes the temporary file if available. Must be called after getFile(...).

		time_t getKFileItemExtModificationTimeT();
		time_t getKFileItemExtAccessTimeT();
		QString getKFileItemExtModificationTimeString();
		QString getKFileItemExtAccessTimeString();

		void setTmpFile( KTemporaryFile *_tmp_file );
		void setDownloadError( int _download_error );

		int dir; // 0 left, 1 right
		KUrl parent_path;
		KUrl virtual_parent_path;

		int hasdupes_size; // true only if file is first on duplicate chain
		int hasdupes_path;
		int isdupe_size;
		int isdupe_path;
		KFileItemExt *duplicates_size;
		KFileItemExt *dup_size_parent; // parent in chain. NULL if it's the first item in chain.
		KFileItemExt *duplicates_path;
		KFileItemExt *dup_path_parent;
		KFileItemExt *next;       // next in chain.

	signals:
		void emitMessage( const QString &, const QString & );
		void emitDownloadFile( KFileItemExt * );

	private:
		KMD5 *m_md5;
		KTemporaryFile *m_tmp_file;
		QMutex m_mutex;
		int m_download_error;
		time_t m_kfileitemextmodificationtimet;
		time_t m_kfileitemextaccesstimet;
		QString m_kfileitemextmodificationtimestring;
		QString m_kfileitemextaccesstimestring;
};

#endif
