/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.lisaac.ldt.LisaacMessages;
import org.lisaac.ldt.builder.LisaacNature;
import org.lisaac.ldt.editors.LisaacResourceDecorator;
import org.lisaac.ldt.model.LisaacModel;
import org.lisaac.ldt.wizards.NewProjectWizardPage;

public class NewProjectWizard
extends Wizard
implements INewWizard {
    NewProjectWizardPage mainPage;

    public NewProjectWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        IRunnableWithProgress op = null;
        try {
            String name = this.mainPage.getProjectName();
            IPath path = this.mainPage.getLocationPath();
            boolean genereSrc = this.mainPage.generateSrc();
            op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        try {
                            NewProjectWizard.this.doFinish(name, path, genereSrc, monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
        }
        catch (NullPointerException e1) {
            e1.printStackTrace();
        }
        try {
            this.getContainer().run(false, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error !", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String projectName, IPath nomRep, boolean genereSrc, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Project Creation " + projectName, 4);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            IFolder bin;
            IProject project = root.getProject(projectName);
            if (project.exists() && !project.isOpen()) {
                project.open(monitor);
            } else {
                project.create(monitor);
                project.open(monitor);
            }
            try {
                LisaacNature nature = new LisaacNature();
                nature.setProject(project);
                nature.configure();
                IProjectDescription description = project.getDescription();
                description.setNatureIds(new String[]{"org.lisaac.ldt.lisaac"});
                project.setDescription(description, monitor);
            }
            catch (CoreException coreException) {}
            monitor.worked(1);
            new LisaacModel(project);
            monitor.worked(1);
            IFile lipFile = project.getFile("make.lip");
            if (!lipFile.exists()) {
                lipFile.create((InputStream)new ByteArrayInputStream(this.getLipStream(project, genereSrc)), false, monitor);
            }
            if (genereSrc) {
                IFolder src = project.getFolder("src");
                if (!src.exists()) {
                    src.create(false, true, monitor);
                    src.setPersistentProperty(new QualifiedName("", LisaacResourceDecorator.SOURCE_FOLDER_PROPERTY), "true");
                }
                monitor.worked(1);
                IFile mainPrototype = src.getFile(String.valueOf(projectName.toLowerCase()) + ".li");
                if (!mainPrototype.exists()) {
                    mainPrototype.create((InputStream)new ByteArrayInputStream(this.getMainPrototypeStream(projectName)), false, monitor);
                }
            }
            if (!(bin = project.getFolder("bin")).exists()) {
                bin.create(false, true, monitor);
            }
            monitor.worked(1);
            IFolder lib = project.getFolder("lib");
            if (!lib.exists()) {
                lib.create(false, true, monitor);
                lib.setPersistentProperty(new QualifiedName("", LisaacResourceDecorator.LIB_PROPERTY), "true");
            }
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Project creation Error !", (String)e.getMessage());
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Project settings Error !", (String)e.getMessage());
        }
        monitor.done();
    }

    public byte[] getMainPrototypeStream(String projectName) throws IOException {
        String contents = "\nSection Header\n\n";
        contents = String.valueOf(contents) + "  + name    := " + projectName.toUpperCase() + ";\n";
        contents = String.valueOf(contents) + "  - comment := \"Main Prototype\";\n";
        contents = String.valueOf(contents) + "\nSection Inherit\n\n";
        contents = String.valueOf(contents) + "  - parent_object:OBJECT := OBJECT;\n";
        contents = String.valueOf(contents) + "\nSection Public\n\n";
        contents = String.valueOf(contents) + "  - main <- \n";
        contents = String.valueOf(contents) + "  // Main entry point.\n";
        contents = String.valueOf(contents) + "  (\n\n";
        contents = String.valueOf(contents) + "    \n";
        contents = String.valueOf(contents) + "  );\n";
        return contents.getBytes();
    }

    public byte[] getLipStream(IProject project, boolean genereSrc) throws IOException {
        String contents = "//\n// `" + project.getName() + "`  LIsaac Project file\n//";
        contents = String.valueOf(contents) + "\nSection Inherit\n\n";
        contents = String.valueOf(contents) + "  + parent:STRING;\n";
        contents = String.valueOf(contents) + "\nSection Private\n\n";
        contents = String.valueOf(contents) + "  + project_root:STRING := \"" + project.getLocationURI().getPath() + "/\";\n\n";
        contents = String.valueOf(contents) + "  - project_src_path <- \n";
        contents = String.valueOf(contents) + "  // Define the project path for source code.\n";
        contents = String.valueOf(contents) + "  (\n";
        contents = genereSrc ? String.valueOf(contents) + "    path (project_root + \"src/\");\n" : String.valueOf(contents) + "    path project_root;\n";
        contents = String.valueOf(contents) + "  );\n\n";
        contents = String.valueOf(contents) + "  - front_end <- \n";
        contents = String.valueOf(contents) + "  // Executed by compiler, before compilation step.\n";
        contents = String.valueOf(contents) + "  (\n";
        contents = String.valueOf(contents) + "    project_src_path;\n";
        contents = String.valueOf(contents) + "    general_front_end;\n";
        contents = String.valueOf(contents) + "  );\n";
        contents = String.valueOf(contents) + "\nSection Public\n\n";
        contents = String.valueOf(contents) + "  - run_mode m:STRING <- \n";
        contents = String.valueOf(contents) + "  // Select Run Mode.\n";
        contents = String.valueOf(contents) + "  (\n";
        contents = String.valueOf(contents) + "    (m = \"run\").if {\n";
        contents = String.valueOf(contents) + "      no_debug;\n";
        contents = String.valueOf(contents) + "    } else {\n";
        contents = String.valueOf(contents) + "      debug 15; // default level [1-20]\n";
        contents = String.valueOf(contents) + "    };\n";
        contents = String.valueOf(contents) + "  );\n\n";
        contents = String.valueOf(contents) + "  - clean <- \n";
        contents = String.valueOf(contents) + "  // Clean project.\n";
        contents = String.valueOf(contents) + "  (\n";
        contents = String.valueOf(contents) + "  );\n";
        return contents.getBytes();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(LisaacMessages.getString("NewProjectWizard_46"));
        this.setNeedsProgressMonitor(true);
        this.mainPage = new NewProjectWizardPage(LisaacMessages.getString("NewProjectWizard_47"));
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.mainPage);
    }
}

