; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt < %s -passes=jump-table-to-switch -verify-dom-info -S | FileCheck %s

@func_array0 = constant [2 x ptr] [ptr @func0, ptr @declared_only_func1]

define i32 @func0() {
  ret i32 1
}

declare i32 @declared_only_func1()

define i32 @function_with_jump_table_with_a_declared_only_func(i32 %index) {
; CHECK-LABEL: define i32 @function_with_jump_table_with_a_declared_only_func(
; CHECK-SAME: i32 [[INDEX:%.*]]) {
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds [2 x ptr], ptr @func_array0, i32 0, i32 [[INDEX]]
; CHECK-NEXT:    [[FUNC_PTR:%.*]] = load ptr, ptr [[GEP]], align 8
; CHECK-NEXT:    [[RESULT:%.*]] = call i32 [[FUNC_PTR]]()
; CHECK-NEXT:    ret i32 [[RESULT]]
;
  %gep = getelementptr inbounds [2 x ptr], ptr @func_array0, i32 0, i32 %index
  %func_ptr = load ptr, ptr %gep, align 8
  %result = call i32 %func_ptr()
  ret i32 %result
}

declare i32 @__gxx_personality_v0(...)

define i32 @function_with_jump_table_invoke(i32 %index) personality ptr @__gxx_personality_v0 {
; CHECK-LABEL: define i32 @function_with_jump_table_invoke(
; CHECK-SAME: i32 [[INDEX:%.*]]) personality ptr @__gxx_personality_v0 {
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds [2 x ptr], ptr @func_array0, i32 0, i32 [[INDEX]]
; CHECK-NEXT:    [[FUNC_PTR:%.*]] = load ptr, ptr [[GEP]], align 8
; CHECK-NEXT:    [[RESULT:%.*]] = invoke i32 [[FUNC_PTR]]()
; CHECK-NEXT:            to label [[NORMAL:%.*]] unwind label [[EXCEPTIONAL:%.*]]
; CHECK:       normal:
; CHECK-NEXT:    ret i32 [[RESULT]]
; CHECK:       exceptional:
; CHECK-NEXT:    [[LANDING_PAD:%.*]] = landingpad { ptr, i32 }
; CHECK-NEXT:            catch ptr null
; CHECK-NEXT:    resume { ptr, i32 } [[LANDING_PAD]]
;
  %gep = getelementptr inbounds [2 x ptr], ptr @func_array0, i32 0, i32 %index
  %func_ptr = load ptr, ptr %gep, align 8
  %result = invoke i32 %func_ptr() to label %normal unwind label %exceptional
normal:
  ret i32 %result
exceptional:
  %landing_pad = landingpad { ptr, i32 } catch ptr null
  resume { ptr, i32 } %landing_pad
}

@func_array1 = constant [1 x ptr] [ptr @func2]

define i32 @func2(i32 %arg) {
  ret i32 %arg
}

define i32 @function_with_jump_table_musttail_call(i32 %index) {
; CHECK-LABEL: define i32 @function_with_jump_table_musttail_call(
; CHECK-SAME: i32 [[INDEX:%.*]]) {
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds [1 x ptr], ptr @func_array1, i32 0, i32 [[INDEX]]
; CHECK-NEXT:    [[FUNC_PTR:%.*]] = load ptr, ptr [[GEP]], align 8
; CHECK-NEXT:    [[RESULT:%.*]] = musttail call i32 [[FUNC_PTR]](i32 [[INDEX]])
; CHECK-NEXT:    ret i32 [[RESULT]]
;
  %gep = getelementptr inbounds [1 x ptr], ptr @func_array1, i32 0, i32 %index
  %func_ptr = load ptr, ptr %gep, align 8
  %result = musttail call i32 %func_ptr(i32 %index)
  ret i32 %result
}

define i32 @function_with_jump_table_and_volatile_load(i32 %index) {
; CHECK-LABEL: define i32 @function_with_jump_table_and_volatile_load(
; CHECK-SAME: i32 [[INDEX:%.*]]) {
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds [1 x ptr], ptr @func_array1, i32 0, i32 [[INDEX]]
; CHECK-NEXT:    [[FUNC_PTR:%.*]] = load volatile ptr, ptr [[GEP]], align 8
; CHECK-NEXT:    [[RESULT:%.*]] = call i32 [[FUNC_PTR]](i32 [[INDEX]])
; CHECK-NEXT:    ret i32 [[RESULT]]
;
  %gep = getelementptr inbounds [1 x ptr], ptr @func_array1, i32 0, i32 %index
  %func_ptr = load volatile ptr, ptr %gep, align 8
  %result = call i32 %func_ptr(i32 %index)
  ret i32 %result
}

define i32 @function_with_jump_table_and_atomic_load(i32 %index) {
; CHECK-LABEL: define i32 @function_with_jump_table_and_atomic_load(
; CHECK-SAME: i32 [[INDEX:%.*]]) {
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds [1 x ptr], ptr @func_array1, i32 0, i32 [[INDEX]]
; CHECK-NEXT:    [[FUNC_PTR:%.*]] = load atomic ptr, ptr [[GEP]] monotonic, align 8
; CHECK-NEXT:    [[RESULT:%.*]] = call i32 [[FUNC_PTR]](i32 [[INDEX]])
; CHECK-NEXT:    ret i32 [[RESULT]]
;
  %gep = getelementptr inbounds [1 x ptr], ptr @func_array1, i32 0, i32 %index
  %func_ptr = load atomic ptr, ptr %gep monotonic, align 8
  %result = call i32 %func_ptr(i32 %index)
  ret i32 %result
}

@func_array2 = global [1 x ptr] [ptr @func2]

define i32 @function_with_nonconstant_jump_table(i32 %index) {
; CHECK-LABEL: define i32 @function_with_nonconstant_jump_table(
; CHECK-SAME: i32 [[INDEX:%.*]]) {
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds [1 x ptr], ptr @func_array2, i32 0, i32 [[INDEX]]
; CHECK-NEXT:    [[FUNC_PTR:%.*]] = load ptr, ptr [[GEP]], align 8
; CHECK-NEXT:    [[RESULT:%.*]] = call i32 [[FUNC_PTR]](i32 [[INDEX]])
; CHECK-NEXT:    ret i32 [[RESULT]]
;
  %gep = getelementptr inbounds [1 x ptr], ptr @func_array2, i32 0, i32 %index
  %func_ptr = load ptr, ptr %gep, align 8
  %result = call i32 %func_ptr(i32 %index)
  ret i32 %result
}

@func_array3 = weak constant [1 x ptr] [ptr @func2]

define i32 @function_with_constant_weak_jump_table(i32 %index) {
; CHECK-LABEL: define i32 @function_with_constant_weak_jump_table(
; CHECK-SAME: i32 [[INDEX:%.*]]) {
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds [1 x ptr], ptr @func_array3, i32 0, i32 [[INDEX]]
; CHECK-NEXT:    [[FUNC_PTR:%.*]] = load ptr, ptr [[GEP]], align 8
; CHECK-NEXT:    [[RESULT:%.*]] = call i32 [[FUNC_PTR]](i32 [[INDEX]])
; CHECK-NEXT:    ret i32 [[RESULT]]
;
  %gep = getelementptr inbounds [1 x ptr], ptr @func_array3, i32 0, i32 %index
  %func_ptr = load ptr, ptr %gep, align 8
  %result = call i32 %func_ptr(i32 %index)
  ret i32 %result
}

