#!/usr/bin/python
from storm.locals import *
import sys

if len(sys.argv) != 3:
    print "Usage: %s <source DB> <destination DB>" % sys.argv[0]
    sys.exit(1)

sys.path.append('plugins')
sys.path.append('/usr/share/ltsp-agent/plugins')
from weblive import Account

srcdb = create_database(sys.argv[1])
dstdb = create_database(sys.argv[2])

srcstore=Store(srcdb)
dststore=Store(dstdb)

for account in srcstore.find(Account):
    user=Account()
    user.username=account.username
    user.fullname=account.fullname
    user.server=account.server
    user.source=account.source
    user.session=account.session
    user.password=account.password
    user.enabled=account.enabled
    user.created=account.created
    dststore.add(user)
    dststore.commit()
