/*
    dclib-tth.cpp - Tiger Tree Hash tool
    Copyright (C) 2009 Edward Sheldrake <ejs1920@yahoo.co.uk>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <dclib/cfilehasher.h>

#include <cstdio>

int main( int argc, char * argv[] )
{
	for ( int i = 1; i < argc; ++i )
	{
		CFileHasher hasher( argv[i] );
		hasher.ComputeHash();
		
		if ( hasher.GetStatus() == efhsFinished )
		{
			printf("%s  %s\n", hasher.GetHashRoot().Data(), argv[i]);
		}
		else
		{
			fprintf(stderr, "error on file %s\n",argv[i]);
		}
	}
	
	return 0;
}
