/*******************************************************************************/
/* Permission is hereby granted, free of charge, to any person or organization */
/* obtaining a copy of the software and accompanying documentation covered by  */
/* this license (the "Software") to use, reproduce, display, distribute,       */
/* execute, and transmit the Software, and to prepare derivative works of the  */
/* Software, and to permit third-parties to whom the Software is furnished to  */
/* do so, all subject to the following:                                        */
/*                                                                             */
/* The copyright notices in the Software and this entire statement, including  */
/* the above license grant, this restriction and the following disclaimer,     */
/* must be included in all copies of the Software, in whole or in part, and    */
/* all derivative works of the Software, unless such copies or derivative      */
/* works are solely in the form of machine-executable object code generated by */
/* a source language processor.                                                */
/*                                                                             */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR  */
/* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,    */
/* FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT   */
/* SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE   */
/* FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE, */
/* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER */
/* DEALINGS IN THE SOFTWARE.                                                   */
/*******************************************************************************/

#if !defined(_LFP_TIME_H_)
# define _LFP_TIME_H_

#include <lfp/aux.h>

CPLUSPLUS_GUARD

#include <time.h>
#include <sys/time.h>

#include <inttypes.h>

typedef uint64_t lfp_clockid_t;

#if !defined(_POSIX_TIMERS) || _POSIX_TIMERS < 0
# define CLOCK_REALTIME  0
# define CLOCK_MONOTONIC 1
#elif !defined(_POSIX_MONOTONIC_CLOCK) || _POSIX_MONOTONIC_CLOCK < 0
# define CLOCK_MONOTONIC (1 << 32)
#endif

int lfp_clock_getres(lfp_clockid_t clk_id, struct timespec *res);

int lfp_clock_gettime(lfp_clockid_t clk_id, struct timespec *tp);

int lfp_clock_settime(lfp_clockid_t clk_id, struct timespec *tp);

END_CPLUSPLUS_GUARD

#endif /* _LFP_TIME_H_ */
