/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class NewInstrumentSpec {
    private final String className;
    private final ImmutableMap<String, String> options;

    private NewInstrumentSpec(Builder builder) {
        this.className = builder.className;
        this.options = builder.optionsBuilder.build();
    }

    public String className() {
        return this.className;
    }

    public ImmutableMap<String, String> options() {
        return this.options;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NewInstrumentSpec) {
            NewInstrumentSpec that = (NewInstrumentSpec)obj;
            return this.className.equals(that.className) && this.options.equals(that.options);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.className, this.options});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("className", (Object)this.className).add("options", this.options).toString();
    }

    public static final class Builder {
        private String className;
        private final ImmutableMap.Builder<String, String> optionsBuilder = ImmutableMap.builder();

        public Builder className(String className) {
            this.className = (String)Preconditions.checkNotNull((Object)className);
            return this;
        }

        public Builder instrumentClass(Class<?> insturmentClass) {
            return this.className(insturmentClass.getName());
        }

        public Builder addOption(String option, String value) {
            this.optionsBuilder.put((Object)option, (Object)value);
            return this;
        }

        public Builder addAllOptions(Map<String, String> options) {
            this.optionsBuilder.putAll(options);
            return this;
        }

        public NewInstrumentSpec build() {
            Preconditions.checkState((this.className != null ? 1 : 0) != 0);
            return new NewInstrumentSpec(this);
        }
    }
}

