/* This file is part of libhud-qt
 * Copyright 2013 Canonical Ltd.
 *
 * libhud-qt is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * libhud-qt is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "action.h"

using namespace Ubuntu::HUD;

QML::Action::Action(QObject *parent)
    : Ubuntu::HUD::Action(parent)
{

}

QML::Action::~Action()
{

}

QQmlListProperty<Parameter>
QML::Action::parameters_list()
{
    return QQmlListProperty<Parameter>(this,
                                       0,
                                       QML::Action::append,
                                       QML::Action::count,
                                       QML::Action::at,
                                       QML::Action::clear);
}

void
QML::Action::append(QQmlListProperty<Parameter> *list,
                    Parameter *parameter)
{
    QML::Action *action = qobject_cast<QML::Action *>(list->object);
    if (action) {
        action->addParameter(parameter);
        return;
    }

    Q_ASSERT(0); // should not be reached
}

Parameter *
QML::Action::at(QQmlListProperty<Parameter> *list, int index)
{
    QML::Action *action = qobject_cast<QML::Action *>(list->object);
    if (action)
        return action->parameters().at(index);

    Q_ASSERT(0); // should not be reached
    return 0;
}

void
QML::Action::clear(QQmlListProperty<Parameter> *list)
{
    QML::Action *action = qobject_cast<QML::Action *>(list->object);
    if (action) {
        QList< ::Parameter *> parameters = action->parameters();
        foreach(::Parameter *param, parameters) {
            action->removeParameter(param);
        }
        return;
    }

    Q_ASSERT(0); // should not be reached
}

int
QML::Action::count(QQmlListProperty<Parameter> *list)
{
    QML::Action *action = qobject_cast<QML::Action *>(list->object);
    if (action) {
        action->parameters().count();
        return 0;
    }

    Q_ASSERT(0); // should not be reached
    return 0;
}
