/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef QTSHIVA_H
#define QTSHIVA_H

#include <QMainWindow>
#include <QCloseEvent>
#include <QImage>

class Ui_MainWindow;

namespace OpenShiva {
  class Kernel;
}

class qShiva : public QMainWindow
{
  Q_OBJECT
  public:
    qShiva();
    ~qShiva();

  private slots:
    void add();
    void remove();
    void apply();
    void refreshImageViewer();
    void sourceChanged();
  private:
//     void loadFile(const QString &fileName);
  private:
    Ui_MainWindow* m_mainWindow;
    QImage currentImage;
    OpenShiva::Kernel* m_kernel;
};

#endif
