.\" Automatically generated from an mdoc input file.  Do not edit.
.\" zip_get_num_entries.mdoc -- get number of files in archive
.\" Copyright (C) 2011-2017 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <info@libzip.org>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH "ZIP_GET_NUM_ENTRIES" "3" "August 19, 2022" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_get_num_entries\fR
\- get number of entries in archive
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIzip_int64_t\fR
.br
.PD 0
.HP 4n
\fBzip_get_num_entries\fR(\fIzip_t\ *archive\fR, \fIzip_flags_t\ flags\fR);
.PD
.SH "DESCRIPTION"
The
\fBzip_get_num_entries\fR()
function returns the number of entries in
\fIarchive\fR.
Entries are all files that are present in the original archive or that
were added while the archive is open.
This includes deleted files, since
indices are not renumbered until the archive is closed.
(This allows one to refer to deleted files, e. g. to undelete them.)
.PP
If
\fIflags\fR
is set to
\fRZIP_FL_UNCHANGED\fR,
the original number of files is returned.
.SH "RETURN VALUES"
\fBzip_get_num_entries\fR()
returns the number of entries in the zip archive,
or \-1 if
\fIarchive\fR
is
\fRNULL\fR.
.SH "SEE ALSO"
libzip(3),
zip_fopen_index(3),
zip_stat_index(3)
.SH "HISTORY"
\fBzip_get_num_entries\fR()
was added in libzip 0.10.
In libzip 0.11 the return type was changed from
\fIzip_uint64_t\fR
to
\fIzip_int64_t\fR.
In libzip 0.11 the type of
\fIflags\fR
was changed from
\fIint\fR
to
\fIzip_flags_t\fR.
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fIwiz@gatalith.at\fR>
