/* massXpert - the true massist's program.
   --------------------------------------
   Copyright(C) 2006,2007 Filippo Rusconi

   http://www.massxpert.org/massXpert

   This file is part of the massXpert project.

   The massxpert project is the successor to the "GNU polyxmass"
   project that is an official GNU project package(see
   www.gnu.org). The massXpert project is not endorsed by the GNU
   project, although it is released ---in its entirety--- under the
   GNU General Public License. A huge part of the code in massXpert
   is actually a C++ rewrite of code in GNU polyxmass. As such
   massXpert was started at the Centre National de la Recherche
   Scientifique(FRANCE), that granted me the formal authorization to
   publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License version 3, as published by the Free Software Foundation.
   

   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this software; if not, write to the

   Free Software Foundation, Inc.,

   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
*/


#ifndef FRAGMENT_OLIGOMER_HPP
#define FRAGMENT_OLIGOMER_HPP


/////////////////////// Local includes
#include "oligomer.hpp"


namespace massXpert
{

  class FragmentOligomer : public Oligomer
  {
  protected:
    QString m_fragmentationPattern;
      
  public:
    FragmentOligomer(Polymer *, const QString & = QString(), 
		      const QString & = QString("NOT_SET"), 
		      const Ponderable & = Ponderable(),
		      int = -1, int = -1,
                     const CalcOptions & = CalcOptions());

    FragmentOligomer(Polymer *, const QString & = QString(), 
                     const QString & = QString("NOT_SET"), 
                     const Ponderable & = Ponderable(),
                     const IonizeRule & = IonizeRule(),
                     bool isIonized = false,
                     int = -1, int = -1,
                     const CalcOptions & = CalcOptions());
    
    FragmentOligomer(PolChemDef *, const QString &, 
                     const Ponderable &,
                     const IonizeRule &,
                     bool, int = -1, int = -1,
                     const CalcOptions & = CalcOptions());
    
    FragmentOligomer(Polymer *, const QString & = QString(), 
                     const QString & = QString("NOT_SET"), 
                     double = 0, double = 0, int = -1, int = -1,
                     const CalcOptions & = CalcOptions());
    
    FragmentOligomer(const FragmentOligomer &);
    
    virtual int setCharge(int);
    virtual int charge() const;

    virtual int ionize();
    virtual int ionize(const IonizeRule &);

    virtual int deionize();
    
    virtual double molecularMass(MassType);
    
    void setFragmentationPattern(const QString &);
    QString fragmentationPattern();
    
  };

} // namespace massXpert


#endif // FRAGMENT_OLIGOMER_HPP
