package org.apache.maven.plugin.ear;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.artifact.Artifact;
import org.codehaus.plexus.util.xml.XMLWriter;

/**
 * The {@link EarModule} implementation for a JBoss Hibernate archive.
 *
 * @author <a href="snicoll@apache.org">Stephane Nicoll</a>
 * @version $Id: HarModule.java 485857 2006-12-11 20:34:39Z snicoll $
 */
public class HarModule
    extends AbstractEarModule
    implements JbossEarModule
{
    public HarModule()
    {
    }

    public HarModule( Artifact a )
    {
        super( a );
    }

    public void appendModule( XMLWriter writer, String version )
    {
        // No entry is generated by this artifact ; it should be
        // defined in the jboss-app.xml.
        // See http://docs.jboss.org/jbossas/getting_started/v4/html/hibernate.html
    }

    public void appendJbossModule( XMLWriter writer, String version )
    {
        writer.startElement( MODULE_ELEMENT );
        writer.startElement( "har" );
        writer.writeText( getUri() );
        writer.endElement();
        writer.endElement();
    }

    public String getType()
    {
        return "har";
    }
}
