# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.open_gl_camera import OpenGLCamera


class ExternalOpenGLCamera(OpenGLCamera):
    r"""
    ExternalOpenGLCamera - open_gl camera
    
    Superclass: OpenGLCamera
    
    ExternalOpenGLCamera is a concrete implementation of the abstract
    class Camera.  ExternalOpenGLCamera interfaces to the open_gl
    rendering library. This class extends OpenGLCamera by introducing
    API wherein the camera matrices can be set explicitly by the
    application.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkExternalOpenGLCamera, obj, update, **traits)
    
    def get_projection_transform_matrix(self, *args):
        """
        get_projection_transform_matrix(self, aspect:float, nearz:float,
            farz:float) -> Matrix4x4
        C++: virtual Matrix4x4 *get_projection_transform_matrix(
            double aspect, double nearz, double farz)
        get_projection_transform_matrix(self, ren:Renderer)
            -> Matrix4x4
        C++: virtual Matrix4x4 *get_projection_transform_matrix(
            Renderer *ren)
        Return the projection transform matrix, which converts from
        camera coordinates to viewport coordinates.  The 'aspect' is the
        width/height for the viewport, and the nearz and farz are the
        Z-buffer values that map to the near and far clipping planes. The
        viewport coordinates of a point located inside the frustum are in
        the range ([-1,+1],[-1,+1],[nearz,farz]). aspect is ignored if
        use_explicit_aspect_ratio is true.
        @sa explicit_projection_transform_matrix
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetProjectionTransformMatrix, *my_args)
        return wrap_vtk(ret)

    def set_projection_transform_matrix(self, *args):
        """
        set_projection_transform_matrix(self, elements:(float, float, float,
            float, float, float, float, float, float, float, float, float,
             float, float, float, float)) -> None
        C++: void set_projection_transform_matrix(const double elements[16])
        Set the projection matrix
        """
        ret = self._wrap_call(self._vtk_obj.SetProjectionTransformMatrix, *args)
        return ret

    def _get_view_transform_matrix(self):
        return wrap_vtk(self._vtk_obj.GetViewTransformMatrix())
    def _set_view_transform_matrix(self, arg):
        old_val = self._get_view_transform_matrix()
        self._wrap_call(self._vtk_obj.SetViewTransformMatrix,
                        arg)
        self.trait_property_changed('view_transform_matrix', old_val, arg)
    view_transform_matrix = traits.Property(_get_view_transform_matrix, _set_view_transform_matrix, desc=\
        r"""
        For backward compatibility. Use get_model_view_transform_matrix()
        now. Return the matrix of the view transform. The view_transform
        depends on only three ivars:  the Position, the focal_point, and
        the view_up vector.  All the other methods are there simply for
        the sake of the users' convenience.
        """
    )

    _updateable_traits_ = \
    (('parallel_projection', 'GetParallelProjection'),
    ('use_explicit_aspect_ratio', 'GetUseExplicitAspectRatio'),
    ('use_explicit_projection_transform_matrix',
    'GetUseExplicitProjectionTransformMatrix'),
    ('use_horizontal_view_angle', 'GetUseHorizontalViewAngle'),
    ('use_off_axis_projection', 'GetUseOffAxisProjection'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('clipping_range', 'GetClippingRange'), ('distance', 'GetDistance'),
    ('explicit_aspect_ratio', 'GetExplicitAspectRatio'), ('eye_angle',
    'GetEyeAngle'), ('eye_separation', 'GetEyeSeparation'), ('focal_disk',
    'GetFocalDisk'), ('focal_distance', 'GetFocalDistance'),
    ('focal_point', 'GetFocalPoint'), ('freeze_focal_point',
    'GetFreezeFocalPoint'), ('left_eye', 'GetLeftEye'), ('parallel_scale',
    'GetParallelScale'), ('position', 'GetPosition'),
    ('screen_bottom_left', 'GetScreenBottomLeft'), ('screen_bottom_right',
    'GetScreenBottomRight'), ('screen_top_right', 'GetScreenTopRight'),
    ('shift_scale_threshold', 'GetShiftScaleThreshold'), ('thickness',
    'GetThickness'), ('use_scissor', 'GetUseScissor'), ('view_angle',
    'GetViewAngle'), ('view_shear', 'GetViewShear'), ('view_up',
    'GetViewUp'), ('window_center', 'GetWindowCenter'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'parallel_projection',
    'use_explicit_aspect_ratio',
    'use_explicit_projection_transform_matrix',
    'use_horizontal_view_angle', 'use_off_axis_projection',
    'clipping_range', 'distance', 'explicit_aspect_ratio', 'eye_angle',
    'eye_separation', 'focal_disk', 'focal_distance', 'focal_point',
    'freeze_focal_point', 'left_eye', 'object_name', 'parallel_scale',
    'position', 'screen_bottom_left', 'screen_bottom_right',
    'screen_top_right', 'shift_scale_threshold', 'thickness',
    'use_scissor', 'view_angle', 'view_shear', 'view_up',
    'window_center'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ExternalOpenGLCamera, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ExternalOpenGLCamera properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['parallel_projection', 'use_explicit_aspect_ratio',
            'use_explicit_projection_transform_matrix',
            'use_horizontal_view_angle', 'use_off_axis_projection'], [],
            ['clipping_range', 'distance', 'explicit_aspect_ratio', 'eye_angle',
            'eye_separation', 'focal_disk', 'focal_distance', 'focal_point',
            'freeze_focal_point', 'left_eye', 'object_name', 'parallel_scale',
            'position', 'screen_bottom_left', 'screen_bottom_right',
            'screen_top_right', 'shift_scale_threshold', 'thickness',
            'use_scissor', 'view_angle', 'view_shear', 'view_up',
            'window_center']),
            title='Edit ExternalOpenGLCamera properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ExternalOpenGLCamera properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

