# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.property import Property


class RIBProperty(Property):
    r"""
    RIBProperty - RIP Property
    
    Superclass: Property
    
    RIBProperty is a subclass of Property that allows the user to
    specify named shaders for use with render_man. Both surface and
    displacement shaders can be specified. Parameters for the shaders can
    be declared and set.
    
    @sa
    RIBExporter RIBLight
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkRIBProperty, obj, update, **traits)
    
    surface_shader_uses_default_parameters = tvtk_base.true_bool_trait(desc=\
        r"""
        If true (default) the surface shader uses the usual shader
        parameters: Ka - Ambient amount Kd - Diffuse amount Ks - Specular
        amount Roughness specular_color Additional surface shader
        parameters can be added with the Set/add_surface_shader_parameter
        methods. If false, all surface shader parameters must be
        specified
        """
    )

    def _surface_shader_uses_default_parameters_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSurfaceShaderUsesDefaultParameters,
                        self.surface_shader_uses_default_parameters_)

    displacement_shader = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        Specify the name of a displacement shader.
        """
    )

    def _displacement_shader_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDisplacementShader,
                        self.displacement_shader)

    surface_shader = traits.String('plastic', enter_set=True, auto_set=False, desc=\
        r"""
        Specify the name of a surface shader.
        """
    )

    def _surface_shader_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSurfaceShader,
                        self.surface_shader)

    def _get_declarations(self):
        return self._vtk_obj.GetDeclarations()
    declarations = traits.Property(_get_declarations, desc=\
        r"""
        Get variable declarations
        """
    )

    def _get_displacement_shader_parameters(self):
        return self._vtk_obj.GetDisplacementShaderParameters()
    displacement_shader_parameters = traits.Property(_get_displacement_shader_parameters, desc=\
        r"""
        
        """
    )

    def _get_parameters(self):
        return self._vtk_obj.GetParameters()
    parameters = traits.Property(_get_parameters, desc=\
        r"""
        Get parameters.
        """
    )

    def _get_surface_shader_parameters(self):
        return self._vtk_obj.GetSurfaceShaderParameters()
    surface_shader_parameters = traits.Property(_get_surface_shader_parameters, desc=\
        r"""
        
        """
    )

    def add_displacement_shader_parameter(self, *args):
        """
        add_displacement_shader_parameter(self, parameter:str, value:str)
            -> None
        C++: void add_displacement_shader_parameter(const char *parameter,
            const char *value)"""
        ret = self._wrap_call(self._vtk_obj.AddDisplacementShaderParameter, *args)
        return ret

    def add_parameter(self, *args):
        """
        add_parameter(self, parameter:str, value:str) -> None
        C++: void add_parameter(const char *parameter, const char *value)"""
        ret = self._wrap_call(self._vtk_obj.AddParameter, *args)
        return ret

    def add_surface_shader_parameter(self, *args):
        """
        add_surface_shader_parameter(self, parameter:str, value:str) -> None
        C++: void add_surface_shader_parameter(const char *parameter,
            const char *value)"""
        ret = self._wrap_call(self._vtk_obj.AddSurfaceShaderParameter, *args)
        return ret

    def add_variable(self, *args):
        """
        add_variable(self, variable:str, declaration:str) -> None
        C++: void add_variable(const char *variable,
            const char *declaration)"""
        ret = self._wrap_call(self._vtk_obj.AddVariable, *args)
        return ret

    def set_displacement_shader_parameter(self, *args):
        """
        set_displacement_shader_parameter(self, parameter:str, value:str)
            -> None
        C++: void set_displacement_shader_parameter(const char *parameter,
            const char *value)
        Specify parameter values for displacement shader parameters
        """
        ret = self._wrap_call(self._vtk_obj.SetDisplacementShaderParameter, *args)
        return ret

    def set_parameter(self, *args):
        """
        set_parameter(self, parameter:str, value:str) -> None
        C++: void set_parameter(const char *parameter, const char *value)
        Specify parameter values for variables. DEPRECATED: use
        (Set/Add)surface_shader_parameter instead.
        """
        ret = self._wrap_call(self._vtk_obj.SetParameter, *args)
        return ret

    def set_surface_shader_parameter(self, *args):
        """
        set_surface_shader_parameter(self, parameter:str, value:str) -> None
        C++: void set_surface_shader_parameter(const char *parameter,
            const char *value)
        Specify parameter values for surface shader parameters
        """
        ret = self._wrap_call(self._vtk_obj.SetSurfaceShaderParameter, *args)
        return ret

    def set_variable(self, *args):
        """
        set_variable(self, variable:str, declaration:str) -> None
        C++: void set_variable(const char *variable,
            const char *declaration)
        Specify declarations for variables.
        """
        ret = self._wrap_call(self._vtk_obj.SetVariable, *args)
        return ret

    _updateable_traits_ = \
    (('surface_shader_uses_default_parameters',
    'GetSurfaceShaderUsesDefaultParameters'), ('backface_culling',
    'GetBackfaceCulling'), ('edge_visibility', 'GetEdgeVisibility'),
    ('frontface_culling', 'GetFrontfaceCulling'), ('lighting',
    'GetLighting'), ('render_lines_as_tubes', 'GetRenderLinesAsTubes'),
    ('render_points_as_spheres', 'GetRenderPointsAsSpheres'), ('shading',
    'GetShading'), ('show_textures_on_backface',
    'GetShowTexturesOnBackface'), ('vertex_visibility',
    'GetVertexVisibility'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('interpolation', 'GetInterpolation'), ('representation',
    'GetRepresentation'), ('displacement_shader',
    'GetDisplacementShader'), ('surface_shader', 'GetSurfaceShader'),
    ('ambient', 'GetAmbient'), ('ambient_color', 'GetAmbientColor'),
    ('anisotropy', 'GetAnisotropy'), ('anisotropy_rotation',
    'GetAnisotropyRotation'), ('base_ior', 'GetBaseIOR'), ('coat_color',
    'GetCoatColor'), ('coat_ior', 'GetCoatIOR'), ('coat_normal_scale',
    'GetCoatNormalScale'), ('coat_roughness', 'GetCoatRoughness'),
    ('coat_strength', 'GetCoatStrength'), ('color', 'GetColor'),
    ('diffuse', 'GetDiffuse'), ('diffuse_color', 'GetDiffuseColor'),
    ('edge_color', 'GetEdgeColor'), ('edge_tint', 'GetEdgeTint'),
    ('emissive_factor', 'GetEmissiveFactor'), ('line_stipple_pattern',
    'GetLineStipplePattern'), ('line_stipple_repeat_factor',
    'GetLineStippleRepeatFactor'), ('line_width', 'GetLineWidth'),
    ('material_name', 'GetMaterialName'), ('metallic', 'GetMetallic'),
    ('normal_scale', 'GetNormalScale'), ('occlusion_strength',
    'GetOcclusionStrength'), ('opacity', 'GetOpacity'), ('point_size',
    'GetPointSize'), ('roughness', 'GetRoughness'), ('selection_color',
    'GetSelectionColor'), ('selection_line_width',
    'GetSelectionLineWidth'), ('selection_point_size',
    'GetSelectionPointSize'), ('specular', 'GetSpecular'),
    ('specular_color', 'GetSpecularColor'), ('specular_power',
    'GetSpecularPower'), ('vertex_color', 'GetVertexColor'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['backface_culling', 'debug', 'edge_visibility', 'frontface_culling',
    'global_warning_display', 'lighting', 'render_lines_as_tubes',
    'render_points_as_spheres', 'shading', 'show_textures_on_backface',
    'surface_shader_uses_default_parameters', 'vertex_visibility',
    'interpolation', 'representation', 'ambient', 'ambient_color',
    'anisotropy', 'anisotropy_rotation', 'base_ior', 'coat_color',
    'coat_ior', 'coat_normal_scale', 'coat_roughness', 'coat_strength',
    'color', 'diffuse', 'diffuse_color', 'displacement_shader',
    'edge_color', 'edge_tint', 'emissive_factor', 'line_stipple_pattern',
    'line_stipple_repeat_factor', 'line_width', 'material_name',
    'metallic', 'normal_scale', 'object_name', 'occlusion_strength',
    'opacity', 'point_size', 'roughness', 'selection_color',
    'selection_line_width', 'selection_point_size', 'specular',
    'specular_color', 'specular_power', 'surface_shader', 'vertex_color'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(RIBProperty, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit RIBProperty properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['backface_culling', 'edge_visibility', 'frontface_culling',
            'lighting', 'render_lines_as_tubes', 'render_points_as_spheres',
            'shading', 'show_textures_on_backface',
            'surface_shader_uses_default_parameters', 'vertex_visibility'],
            ['interpolation', 'representation'], ['ambient', 'ambient_color',
            'anisotropy', 'anisotropy_rotation', 'base_ior', 'coat_color',
            'coat_ior', 'coat_normal_scale', 'coat_roughness', 'coat_strength',
            'color', 'diffuse', 'diffuse_color', 'displacement_shader',
            'edge_color', 'edge_tint', 'emissive_factor', 'line_stipple_pattern',
            'line_stipple_repeat_factor', 'line_width', 'material_name',
            'metallic', 'normal_scale', 'object_name', 'occlusion_strength',
            'opacity', 'point_size', 'roughness', 'selection_color',
            'selection_line_width', 'selection_point_size', 'specular',
            'specular_color', 'specular_power', 'surface_shader',
            'vertex_color']),
            title='Edit RIBProperty properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit RIBProperty properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

