# Copyright 2019, 2020, Collabora, Ltd.
# Copyright 2019, 2020, Visual Computing Lab, ISTI - Italian National Research Council
# SPDX-License-Identifier: BSL-1.0

option(ALLOW_BUNDLED_SSYNTH "Allow use of bundled structure-synth source" ON)
set(SSYNTH_DIR ${CMAKE_CURRENT_LIST_DIR}/structuresynth-1.5)

if(ALLOW_BUNDLED_SSYNTH AND EXISTS "${SSYNTH_DIR}/ssynth/StructureSynth/Model/Action.h")
	message(STATUS "- structure-synth - using bundled source")
	# Can't use a system version because using StructureSynth as a library is not common
	add_library(
		external-ssynth STATIC
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/Action.h"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/AmbiguousRule.h"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/Builder.h"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/ColorPool.h"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/CustomRule.h"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/ExecutionStack.h"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/PrimitiveClass.h"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/PrimitiveRule.h"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/RandomStreams.h"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/Rule.h"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/RuleRef.h"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/RuleSet.h"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/State.h"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/Transformation.h"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/TransformationLoop.h"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Parser/EisenParser.h"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Parser/Preprocessor.h"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Parser/Tokenizer.h"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/Exceptions/Exception.h"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/Box.h"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/Dot.h"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/EngineWidget.h"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/Grid.h"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/Line.h"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/Mesh.h"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/Object3D.h"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/Raytracer/AtomicCounter.h"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/Raytracer/RayTracer.h"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/Raytracer/RenderThread.h"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/Raytracer/Sampler.h"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/Raytracer/VoxelStepper.h"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/RaytraceTriangle.h"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/Sphere.h"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/Triangle.h"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/Logging/ListWidgetLogger.h"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/Logging/Logging.h"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/Math/Matrix4.h"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/Math/Random.h"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/Math/Vector3.h"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/Misc/ColorUtils.h"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/Misc/MiniParser.h"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/Misc/Persistence.h"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/Misc/Version.h"
		"${SSYNTH_DIR}/ssynth/ThirdPartyCode/MersenneTwister/MersenneTwister.h"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/Rendering/OpenGLRenderer.h"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/Rendering/Renderer.h"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/Rendering/TemplateRenderer.h"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/Action.cpp"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/AmbiguousRule.cpp"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/Builder.cpp"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/ColorPool.cpp"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/CustomRule.cpp"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/ExecutionStack.cpp"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/PrimitiveClass.cpp"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/PrimitiveRule.cpp"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/RandomStreams.cpp"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/Rule.cpp"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/RuleRef.cpp"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/RuleSet.cpp"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/State.cpp"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/Transformation.cpp"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/TransformationLoop.cpp"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Parser/EisenParser.cpp"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Parser/Preprocessor.cpp"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Parser/Tokenizer.cpp"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/Box.cpp"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/Dot.cpp"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/Grid.cpp"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/Line.cpp"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/Mesh.cpp"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/Object3D.cpp"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/Raytracer/AtomicCounter.cpp"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/Raytracer/RenderThread.cpp"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/Raytracer/Sampler.cpp"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/Raytracer/VoxelStepper.cpp"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/RaytraceTriangle.cpp"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/Triangle.cpp"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/Logging/ListWidgetLogger.cpp"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/Logging/Logging.cpp"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/Math/Matrix4.cpp"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/Math/Random.cpp"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/Math/Vector3.cpp"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/Misc/ColorUtils.cpp"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/Misc/MiniParser.cpp"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/Misc/Persistence.cpp"
		"${SSYNTH_DIR}/ssynth/SyntopiaCore/Misc/Version.cpp"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/Rendering/Renderer.cpp"
		"${SSYNTH_DIR}/ssynth/StructureSynth/Model/Rendering/TemplateRenderer.cpp")

	# These sources were disabled in the .pro file: "${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/EngineWidget.cpp"
	# "${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/Raytracer/RayTracer.cpp"
	# "${SSYNTH_DIR}/ssynth/SyntopiaCore/GLEngine/Sphere.cpp"
	# "${SSYNTH_DIR}/ssynth/StructureSynth/Model/Rendering/OpenGLRenderer.cpp"
	target_include_directories(external-ssynth SYSTEM PUBLIC "${SSYNTH_DIR}/ssynth")
	target_link_libraries(external-ssynth PRIVATE Qt5::Core Qt5::Xml Qt5::OpenGL OpenGL::GLU)
	set_property(TARGET external-ssynth PROPERTY FOLDER External)
	set_property(TARGET external-ssynth PROPERTY AUTOMOC TRUE)
	target_link_libraries(external-ssynth PRIVATE external-disable-warnings)
endif()
