/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "ParamList.h"
#include <ctype.h>



ParamList::ParamList(Widget list,const Parameter& param):
	list_(list),
	param_(param)
{
	param.scan(*this);
	sort(selection_.begin(),selection_.end());
	list_.add(selection_);
	selection_.clear();
}

ParamList::~ParamList()
{
}

void ParamList::next(const Parameter&, const char* first,const char* second)
{
    if(isalnum(*first))
	{
		string a = first;
		string b = param_.beautifiedName(a);
		values_[b] = a;
		selection_.push_back(b);
	}	

    if(*first == '/')
        list_.multiple();
}

vector<string> ParamList::get()
{
	vector<string> v  = selection_;
	for(vector<string>::iterator j = v.begin(); j != v.end(); ++j)
		*j = values_[*j];
		

	return v;
}

void ParamList::set(const vector<string>& v)
{
	selection_ = v;
	for(vector<string>::iterator j = selection_.begin(); j != selection_.end(); ++j)
		(*j) = param_.beautifiedName(*j);


//	list_.addMissing(selection_);
	list_.deselect();
	list_.select(selection_);
	list_.showSelection();
}

void ParamList::changed()
{
	vector<string> v = list_.selection();
	::set<string> s(v.begin(),v.end());

	vector<string> w = selection_;

	selection_.clear();

	for(vector<string>::iterator j = w.begin(); j != w.end(); ++j)
		if(s.find(*j) != s.end())
		{
			selection_.push_back(*j);
			s.erase(*j);
		}
	
	copy(s.begin(),s.end(),back_inserter(selection_));
}

void ParamList::add(const string& s)
{
	list_.add(s);
	values_[s] = s;
}
