/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef TAB_H
#define TAB_H

#define XtNround   "round"
#define XtCRound   "Round"
#define XtNrows    "rows"
#define XtNcolumns "columns"
#define XtCRowCol  "RowCol"

#define XmNopenCallback  "openCallback"
#define XmNcloseCallback "closeCallback"

#define XmNdrawer "drawer"

extern WidgetClass  tabWidgetClass;

typedef struct _TabClassRec *TabWidgetClass;
typedef struct _TabRec      *TabWidget;

#ifdef _NO_PROTO

extern Widget CreateTab();

#else
 
#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

Widget    CreateTab(Widget,String,Arg*,int);
Widget    TabGetCurrent(Widget);
void      TabSetCurrent(Widget,Widget,Boolean);
void      TabSetName(Widget,Widget,const char*);

void TabOpen(Widget);
void TabClose(Widget);

Boolean TabClosed(Widget);


#if defined(__cplusplus) || defined(c_plusplus)
}
#endif
 
#endif /* _NO_PROTO */

typedef struct {
    int      reason;
    XEvent  *event;
    Widget   widget;
}TabCallbackStruct;

#define XtIsTab(w)	XtIsSubclass(w,tabWidgetClass)


#endif /* TAB_H */
