/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File RequestPanelLine.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef RequestPanelLine_H
#define RequestPanelLine_H

#include "UILine.h"
#include "RequestPanelItem.h"

class  Request;
class  RequestPanel;
class  IconObject;
class  IconObjectH;
class  RequestPanelHelp;

#include "Parameter.h"

class RequestPanelLine : public UILine_c, public RequestPanelItem {
public:

// -- Exceptions
	// None

// -- Contructors

	RequestPanelLine(RequestPanel&,const Parameter&);

// -- Destructor

	virtual ~RequestPanelLine(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods
	
	Widget where();

	virtual void init(Widget) = 0;

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods

	static RequestPanelLine* build(Widget,RequestPanel&,const Parameter&);
	
	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Overridden methods

	virtual void create(Widget,char* = 0);

private:

// No copy allowed

	RequestPanelLine(const RequestPanelLine&);
	RequestPanelLine& operator=(const RequestPanelLine&);

// -- Members
	
	RequestPanelHelp* help_;
	bool gray_;
	bool mark_;

// -- Methods

// -- Overridden methods

	// From XD

	virtual void setCB(Widget,XtPointer);
	virtual void comboCB(Widget,XtPointer);
	virtual void helpCB(Widget,XtPointer);

	// From RequestPanelItem

	virtual void gray(bool);
	virtual void mark(bool);
	virtual void getSizes(Dimension&,Dimension&);
	virtual void setSizes(Dimension,Dimension);

};


template<class T>
class XRequestPanelLine : public RequestPanelLine, public T {
public:

	XRequestPanelLine(RequestPanel& e,const Parameter& p): RequestPanelLine(e,p)
	{
	}

	void init(Widget w)
	{
		RequestPanelLine::create(w);
		T::create(where());
		XtManageChild(T::xd_rootwidget());
	}
};

#endif
