/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef DRAGP_H
#define DRAGP_H

#include        <Xm/DrawingAP.h>

typedef struct _IconRec {
    struct _IconRec *next;

	Widget      parent;

    XmString    label;
    String      class;
    String      name;

	/* Icons */

    XRectangle  r_all[2];
    XRectangle  r_icon[2];
    XRectangle  r_label[2];

    Pixmap      pix[2];
    Pixmap      selpix[2];
    Pixmap      mask[2];
    Pixmap      open_pix[2];

    String      mask_name[2];
    String      pix_name[2];
    String      open_name[2];


    Pixel       foreground;
    Pixel       background;
    Pixel       hiliteforeground;
    Pixel       hilitebackground;

    Boolean     selected;
    Boolean     visible;
    Boolean     delete;
    Boolean     opened;

    Boolean     isfolder;
	int         id;

    XtPointer   data;

} _IconRec;

typedef struct _DragClassPart {
    XtProc      print;
} DragClassPart;

typedef struct _DragClassRec {
    CoreClassPart           core_class;
    CompositeClassPart      composite_class;
    ConstraintClassPart     constraint_class;
    XmManagerClassPart      manager_class;
    XmDrawingAreaClassPart  drawing_area_class;
    DragClassPart           drag_class;
} DragClassRec;

extern DragClassRec dragClassRec;

typedef struct {
    Icon      icons;
    Icon      last;

    /* Boolean         moving; */

    XtCallbackList  build_message;
    XtCallbackList  drop_message;
    XtCallbackList  answer;
    XtCallbackList  moveicon;
    XtCallbackList  killicon;
    XtCallbackList  select;
    XtCallbackList  dblclick;
    XtCallbackList  other_drop;
    XtCallbackList  folder_move;
    XtCallbackList  rename;
    XtCallbackList  renamable;
    XtCallbackList  fly_over;
    XtCallbackList  getFullName;

    XmFontList      fontlist;
	char            *tag; /* font tag */
    int             string_height;

    GC              gc;
    GC              selgc;

    XRectangle      r_select;
    Boolean         selecting;
    Boolean         selextend;
    Boolean         justclick;
    int             lastx;
    int             lasty;
    int             startx;
    int             starty;

	Boolean         copy;

    XEvent          event;
    String          target;

	Time            last_click;

	Boolean			accept_keys;
	Time            key_threshold;
	Boolean			can_resize;
    Boolean         grid;
    int             gridx;
    int             gridy;

    int             marginx;
    int             marginy;

    int             shape_mode;

	int				(*sort)();

    Boolean         edit_names;
    Boolean         auto_move;
    Boolean         auto_clean;
    Boolean         auto_sort;
    Boolean         auto_place;
    Boolean         small_icons;
	Boolean			multi_drops;
	Boolean			can_select;
	Boolean			single_line;
	Boolean			auto_folder_move;

	Widget			clip;

	Widget			parent_folder;
	int             child_count;
	int             child_max;
	WidgetList		child_folders;

	Icon			last_added;
	Icon			blink_icon;
	Icon			edit_icon;
	Boolean         blink_state;
	XtIntervalId    blink_timeout;

	int             edit_timeout;
	Widget          edit_text;

} DragPart;


typedef struct _DragRec {
    CorePart            core;
    CompositePart       composite;
    ConstraintPart      constraint;
    XmManagerPart       manager;
    XmDrawingAreaPart   drawing_area;
    DragPart            drag;
}  DragRec;



#ifndef MIN
#define MIN(a,b) ((a)>(b)?(b):(a))
#endif
#ifndef MAX
#define MAX(a,b) ((a)<(b)?(b):(a))
#endif

#endif /* DRAGP_H */



