"use strict";

var helpers = require("../helpers/helpers");

exports["Portugal"] = {

	"guess:by:offset" : helpers.makeTestGuess("Portugal", { offset: true, expect: "Europe/London" }),

	"guess:by:abbr" : helpers.makeTestGuess("Portugal", { abbr: true, expect: "Europe/Lisbon" }),

	"1912" : helpers.makeTestYear("Portugal", [
		["1912-01-01T00:00:00+00:00", "00:00:00", "WET", 0]
	]),

	"1916" : helpers.makeTestYear("Portugal", [
		["1916-06-17T22:59:59+00:00", "22:59:59", "WET", 0],
		["1916-06-17T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1916-10-31T23:59:59+00:00", "00:59:59", "WEST", -60],
		["1916-11-01T00:00:00+00:00", "00:00:00", "WET", 0]
	]),

	"1917" : helpers.makeTestYear("Portugal", [
		["1917-02-28T22:59:59+00:00", "22:59:59", "WET", 0],
		["1917-02-28T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1917-10-14T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1917-10-14T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1918" : helpers.makeTestYear("Portugal", [
		["1918-03-01T22:59:59+00:00", "22:59:59", "WET", 0],
		["1918-03-01T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1918-10-14T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1918-10-14T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1919" : helpers.makeTestYear("Portugal", [
		["1919-02-28T22:59:59+00:00", "22:59:59", "WET", 0],
		["1919-02-28T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1919-10-14T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1919-10-14T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1920" : helpers.makeTestYear("Portugal", [
		["1920-02-29T22:59:59+00:00", "22:59:59", "WET", 0],
		["1920-02-29T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1920-10-14T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1920-10-14T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1921" : helpers.makeTestYear("Portugal", [
		["1921-02-28T22:59:59+00:00", "22:59:59", "WET", 0],
		["1921-02-28T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1921-10-14T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1921-10-14T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1924" : helpers.makeTestYear("Portugal", [
		["1924-04-16T22:59:59+00:00", "22:59:59", "WET", 0],
		["1924-04-16T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1924-10-14T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1924-10-14T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1926" : helpers.makeTestYear("Portugal", [
		["1926-04-17T22:59:59+00:00", "22:59:59", "WET", 0],
		["1926-04-17T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1926-10-02T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1926-10-02T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1927" : helpers.makeTestYear("Portugal", [
		["1927-04-09T22:59:59+00:00", "22:59:59", "WET", 0],
		["1927-04-09T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1927-10-01T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1927-10-01T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1928" : helpers.makeTestYear("Portugal", [
		["1928-04-14T22:59:59+00:00", "22:59:59", "WET", 0],
		["1928-04-14T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1928-10-06T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1928-10-06T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1929" : helpers.makeTestYear("Portugal", [
		["1929-04-20T22:59:59+00:00", "22:59:59", "WET", 0],
		["1929-04-20T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1929-10-05T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1929-10-05T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1931" : helpers.makeTestYear("Portugal", [
		["1931-04-18T22:59:59+00:00", "22:59:59", "WET", 0],
		["1931-04-18T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1931-10-03T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1931-10-03T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1932" : helpers.makeTestYear("Portugal", [
		["1932-04-02T22:59:59+00:00", "22:59:59", "WET", 0],
		["1932-04-02T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1932-10-01T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1932-10-01T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1934" : helpers.makeTestYear("Portugal", [
		["1934-04-07T22:59:59+00:00", "22:59:59", "WET", 0],
		["1934-04-07T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1934-10-06T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1934-10-06T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1935" : helpers.makeTestYear("Portugal", [
		["1935-03-30T22:59:59+00:00", "22:59:59", "WET", 0],
		["1935-03-30T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1935-10-05T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1935-10-05T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1936" : helpers.makeTestYear("Portugal", [
		["1936-04-18T22:59:59+00:00", "22:59:59", "WET", 0],
		["1936-04-18T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1936-10-03T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1936-10-03T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1937" : helpers.makeTestYear("Portugal", [
		["1937-04-03T22:59:59+00:00", "22:59:59", "WET", 0],
		["1937-04-03T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1937-10-02T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1937-10-02T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1938" : helpers.makeTestYear("Portugal", [
		["1938-03-26T22:59:59+00:00", "22:59:59", "WET", 0],
		["1938-03-26T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1938-10-01T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1938-10-01T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1939" : helpers.makeTestYear("Portugal", [
		["1939-04-15T22:59:59+00:00", "22:59:59", "WET", 0],
		["1939-04-15T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1939-11-18T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1939-11-18T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1940" : helpers.makeTestYear("Portugal", [
		["1940-02-24T22:59:59+00:00", "22:59:59", "WET", 0],
		["1940-02-24T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1940-10-05T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1940-10-05T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1941" : helpers.makeTestYear("Portugal", [
		["1941-04-05T22:59:59+00:00", "22:59:59", "WET", 0],
		["1941-04-05T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1941-10-05T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1941-10-05T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1942" : helpers.makeTestYear("Portugal", [
		["1942-03-14T22:59:59+00:00", "22:59:59", "WET", 0],
		["1942-03-14T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1942-04-25T21:59:59+00:00", "22:59:59", "WEST", -60],
		["1942-04-25T22:00:00+00:00", "00:00:00", "WEMT", -120],
		["1942-08-15T21:59:59+00:00", "23:59:59", "WEMT", -120],
		["1942-08-15T22:00:00+00:00", "23:00:00", "WEST", -60],
		["1942-10-24T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1942-10-24T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1943" : helpers.makeTestYear("Portugal", [
		["1943-03-13T22:59:59+00:00", "22:59:59", "WET", 0],
		["1943-03-13T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1943-04-17T21:59:59+00:00", "22:59:59", "WEST", -60],
		["1943-04-17T22:00:00+00:00", "00:00:00", "WEMT", -120],
		["1943-08-28T21:59:59+00:00", "23:59:59", "WEMT", -120],
		["1943-08-28T22:00:00+00:00", "23:00:00", "WEST", -60],
		["1943-10-30T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1943-10-30T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1944" : helpers.makeTestYear("Portugal", [
		["1944-03-11T22:59:59+00:00", "22:59:59", "WET", 0],
		["1944-03-11T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1944-04-22T21:59:59+00:00", "22:59:59", "WEST", -60],
		["1944-04-22T22:00:00+00:00", "00:00:00", "WEMT", -120],
		["1944-08-26T21:59:59+00:00", "23:59:59", "WEMT", -120],
		["1944-08-26T22:00:00+00:00", "23:00:00", "WEST", -60],
		["1944-10-28T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1944-10-28T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1945" : helpers.makeTestYear("Portugal", [
		["1945-03-10T22:59:59+00:00", "22:59:59", "WET", 0],
		["1945-03-10T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1945-04-21T21:59:59+00:00", "22:59:59", "WEST", -60],
		["1945-04-21T22:00:00+00:00", "00:00:00", "WEMT", -120],
		["1945-08-25T21:59:59+00:00", "23:59:59", "WEMT", -120],
		["1945-08-25T22:00:00+00:00", "23:00:00", "WEST", -60],
		["1945-10-27T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1945-10-27T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1946" : helpers.makeTestYear("Portugal", [
		["1946-04-06T22:59:59+00:00", "22:59:59", "WET", 0],
		["1946-04-06T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1946-10-05T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1946-10-05T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1947" : helpers.makeTestYear("Portugal", [
		["1947-04-06T01:59:59+00:00", "01:59:59", "WET", 0],
		["1947-04-06T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1947-10-05T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1947-10-05T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1948" : helpers.makeTestYear("Portugal", [
		["1948-04-04T01:59:59+00:00", "01:59:59", "WET", 0],
		["1948-04-04T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1948-10-03T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1948-10-03T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1949" : helpers.makeTestYear("Portugal", [
		["1949-04-03T01:59:59+00:00", "01:59:59", "WET", 0],
		["1949-04-03T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1949-10-02T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1949-10-02T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1950" : helpers.makeTestYear("Portugal", [
		["1950-04-02T01:59:59+00:00", "01:59:59", "WET", 0],
		["1950-04-02T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1950-10-01T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1950-10-01T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1951" : helpers.makeTestYear("Portugal", [
		["1951-04-01T01:59:59+00:00", "01:59:59", "WET", 0],
		["1951-04-01T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1951-10-07T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1951-10-07T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1952" : helpers.makeTestYear("Portugal", [
		["1952-04-06T01:59:59+00:00", "01:59:59", "WET", 0],
		["1952-04-06T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1952-10-05T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1952-10-05T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1953" : helpers.makeTestYear("Portugal", [
		["1953-04-05T01:59:59+00:00", "01:59:59", "WET", 0],
		["1953-04-05T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1953-10-04T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1953-10-04T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1954" : helpers.makeTestYear("Portugal", [
		["1954-04-04T01:59:59+00:00", "01:59:59", "WET", 0],
		["1954-04-04T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1954-10-03T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1954-10-03T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1955" : helpers.makeTestYear("Portugal", [
		["1955-04-03T01:59:59+00:00", "01:59:59", "WET", 0],
		["1955-04-03T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1955-10-02T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1955-10-02T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1956" : helpers.makeTestYear("Portugal", [
		["1956-04-01T01:59:59+00:00", "01:59:59", "WET", 0],
		["1956-04-01T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1956-10-07T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1956-10-07T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1957" : helpers.makeTestYear("Portugal", [
		["1957-04-07T01:59:59+00:00", "01:59:59", "WET", 0],
		["1957-04-07T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1957-10-06T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1957-10-06T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1958" : helpers.makeTestYear("Portugal", [
		["1958-04-06T01:59:59+00:00", "01:59:59", "WET", 0],
		["1958-04-06T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1958-10-05T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1958-10-05T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1959" : helpers.makeTestYear("Portugal", [
		["1959-04-05T01:59:59+00:00", "01:59:59", "WET", 0],
		["1959-04-05T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1959-10-04T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1959-10-04T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1960" : helpers.makeTestYear("Portugal", [
		["1960-04-03T01:59:59+00:00", "01:59:59", "WET", 0],
		["1960-04-03T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1960-10-02T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1960-10-02T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1961" : helpers.makeTestYear("Portugal", [
		["1961-04-02T01:59:59+00:00", "01:59:59", "WET", 0],
		["1961-04-02T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1961-10-01T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1961-10-01T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1962" : helpers.makeTestYear("Portugal", [
		["1962-04-01T01:59:59+00:00", "01:59:59", "WET", 0],
		["1962-04-01T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1962-10-07T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1962-10-07T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1963" : helpers.makeTestYear("Portugal", [
		["1963-04-07T01:59:59+00:00", "01:59:59", "WET", 0],
		["1963-04-07T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1963-10-06T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1963-10-06T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1964" : helpers.makeTestYear("Portugal", [
		["1964-04-05T01:59:59+00:00", "01:59:59", "WET", 0],
		["1964-04-05T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1964-10-04T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1964-10-04T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1965" : helpers.makeTestYear("Portugal", [
		["1965-04-04T01:59:59+00:00", "01:59:59", "WET", 0],
		["1965-04-04T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1965-10-03T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1965-10-03T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1966" : helpers.makeTestYear("Portugal", [
		["1966-04-03T01:59:59+00:00", "01:59:59", "WET", 0],
		["1966-04-03T02:00:00+00:00", "03:00:00", "CET", -60]
	]),

	"1976" : helpers.makeTestYear("Portugal", [
		["1976-09-25T23:59:59+00:00", "00:59:59", "CET", -60],
		["1976-09-26T00:00:00+00:00", "00:00:00", "WET", 0]
	]),

	"1977" : helpers.makeTestYear("Portugal", [
		["1977-03-26T23:59:59+00:00", "23:59:59", "WET", 0],
		["1977-03-27T00:00:00+00:00", "01:00:00", "WEST", -60],
		["1977-09-24T23:59:59+00:00", "00:59:59", "WEST", -60],
		["1977-09-25T00:00:00+00:00", "00:00:00", "WET", 0]
	]),

	"1978" : helpers.makeTestYear("Portugal", [
		["1978-04-01T23:59:59+00:00", "23:59:59", "WET", 0],
		["1978-04-02T00:00:00+00:00", "01:00:00", "WEST", -60],
		["1978-09-30T23:59:59+00:00", "00:59:59", "WEST", -60],
		["1978-10-01T00:00:00+00:00", "00:00:00", "WET", 0]
	]),

	"1979" : helpers.makeTestYear("Portugal", [
		["1979-03-31T23:59:59+00:00", "23:59:59", "WET", 0],
		["1979-04-01T00:00:00+00:00", "01:00:00", "WEST", -60],
		["1979-09-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1979-09-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1980" : helpers.makeTestYear("Portugal", [
		["1980-03-29T23:59:59+00:00", "23:59:59", "WET", 0],
		["1980-03-30T00:00:00+00:00", "01:00:00", "WEST", -60],
		["1980-09-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1980-09-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1981" : helpers.makeTestYear("Portugal", [
		["1981-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["1981-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1981-09-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1981-09-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1982" : helpers.makeTestYear("Portugal", [
		["1982-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["1982-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1982-09-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1982-09-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1983" : helpers.makeTestYear("Portugal", [
		["1983-03-27T01:59:59+00:00", "01:59:59", "WET", 0],
		["1983-03-27T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1983-09-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1983-09-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1984" : helpers.makeTestYear("Portugal", [
		["1984-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["1984-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1984-09-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1984-09-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1985" : helpers.makeTestYear("Portugal", [
		["1985-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["1985-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1985-09-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1985-09-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1986" : helpers.makeTestYear("Portugal", [
		["1986-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["1986-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1986-09-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1986-09-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1987" : helpers.makeTestYear("Portugal", [
		["1987-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["1987-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1987-09-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1987-09-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1988" : helpers.makeTestYear("Portugal", [
		["1988-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["1988-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1988-09-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1988-09-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1989" : helpers.makeTestYear("Portugal", [
		["1989-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["1989-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1989-09-24T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1989-09-24T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1990" : helpers.makeTestYear("Portugal", [
		["1990-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["1990-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1990-09-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1990-09-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1991" : helpers.makeTestYear("Portugal", [
		["1991-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["1991-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1991-09-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1991-09-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1992" : helpers.makeTestYear("Portugal", [
		["1992-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["1992-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1992-09-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1992-09-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1993" : helpers.makeTestYear("Portugal", [
		["1993-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["1993-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1993-09-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1993-09-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1994" : helpers.makeTestYear("Portugal", [
		["1994-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["1994-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1994-09-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1994-09-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1995" : helpers.makeTestYear("Portugal", [
		["1995-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["1995-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1995-09-24T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1995-09-24T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1996" : helpers.makeTestYear("Portugal", [
		["1996-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["1996-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1996-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1996-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1997" : helpers.makeTestYear("Portugal", [
		["1997-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["1997-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1997-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1997-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1998" : helpers.makeTestYear("Portugal", [
		["1998-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["1998-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1998-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1998-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1999" : helpers.makeTestYear("Portugal", [
		["1999-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["1999-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1999-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1999-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2000" : helpers.makeTestYear("Portugal", [
		["2000-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2000-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2000-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2000-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2001" : helpers.makeTestYear("Portugal", [
		["2001-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2001-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2001-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2001-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2002" : helpers.makeTestYear("Portugal", [
		["2002-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2002-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2002-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2002-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2003" : helpers.makeTestYear("Portugal", [
		["2003-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2003-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2003-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2003-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2004" : helpers.makeTestYear("Portugal", [
		["2004-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2004-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2004-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2004-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2005" : helpers.makeTestYear("Portugal", [
		["2005-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2005-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2005-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2005-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2006" : helpers.makeTestYear("Portugal", [
		["2006-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2006-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2006-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2006-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2007" : helpers.makeTestYear("Portugal", [
		["2007-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2007-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2007-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2007-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2008" : helpers.makeTestYear("Portugal", [
		["2008-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2008-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2008-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2008-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2009" : helpers.makeTestYear("Portugal", [
		["2009-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2009-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2009-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2009-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2010" : helpers.makeTestYear("Portugal", [
		["2010-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2010-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2010-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2010-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2011" : helpers.makeTestYear("Portugal", [
		["2011-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2011-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2011-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2011-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2012" : helpers.makeTestYear("Portugal", [
		["2012-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2012-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2012-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2012-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2013" : helpers.makeTestYear("Portugal", [
		["2013-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2013-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2013-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2013-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2014" : helpers.makeTestYear("Portugal", [
		["2014-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2014-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2014-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2014-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2015" : helpers.makeTestYear("Portugal", [
		["2015-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2015-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2015-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2015-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2016" : helpers.makeTestYear("Portugal", [
		["2016-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2016-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2016-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2016-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2017" : helpers.makeTestYear("Portugal", [
		["2017-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2017-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2017-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2017-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2018" : helpers.makeTestYear("Portugal", [
		["2018-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2018-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2018-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2018-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2019" : helpers.makeTestYear("Portugal", [
		["2019-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2019-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2019-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2019-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2020" : helpers.makeTestYear("Portugal", [
		["2020-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2020-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2020-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2020-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2021" : helpers.makeTestYear("Portugal", [
		["2021-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2021-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2021-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2021-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2022" : helpers.makeTestYear("Portugal", [
		["2022-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2022-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2022-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2022-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2023" : helpers.makeTestYear("Portugal", [
		["2023-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2023-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2023-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2023-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2024" : helpers.makeTestYear("Portugal", [
		["2024-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2024-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2024-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2024-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2025" : helpers.makeTestYear("Portugal", [
		["2025-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2025-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2025-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2025-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2026" : helpers.makeTestYear("Portugal", [
		["2026-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2026-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2026-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2026-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2027" : helpers.makeTestYear("Portugal", [
		["2027-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2027-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2027-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2027-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2028" : helpers.makeTestYear("Portugal", [
		["2028-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2028-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2028-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2028-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2029" : helpers.makeTestYear("Portugal", [
		["2029-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2029-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2029-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2029-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2030" : helpers.makeTestYear("Portugal", [
		["2030-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2030-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2030-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2030-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2031" : helpers.makeTestYear("Portugal", [
		["2031-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2031-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2031-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2031-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2032" : helpers.makeTestYear("Portugal", [
		["2032-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2032-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2032-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2032-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2033" : helpers.makeTestYear("Portugal", [
		["2033-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2033-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2033-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2033-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2034" : helpers.makeTestYear("Portugal", [
		["2034-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2034-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2034-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2034-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2035" : helpers.makeTestYear("Portugal", [
		["2035-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2035-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2035-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2035-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2036" : helpers.makeTestYear("Portugal", [
		["2036-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2036-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2036-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2036-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2037" : helpers.makeTestYear("Portugal", [
		["2037-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2037-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2037-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2037-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2038" : helpers.makeTestYear("Portugal", [
		["2038-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2038-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2038-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2038-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2039" : helpers.makeTestYear("Portugal", [
		["2039-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2039-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2039-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2039-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2040" : helpers.makeTestYear("Portugal", [
		["2040-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2040-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2040-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2040-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2041" : helpers.makeTestYear("Portugal", [
		["2041-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2041-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2041-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2041-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2042" : helpers.makeTestYear("Portugal", [
		["2042-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2042-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2042-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2042-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2043" : helpers.makeTestYear("Portugal", [
		["2043-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2043-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2043-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2043-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2044" : helpers.makeTestYear("Portugal", [
		["2044-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2044-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2044-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2044-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2045" : helpers.makeTestYear("Portugal", [
		["2045-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2045-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2045-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2045-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2046" : helpers.makeTestYear("Portugal", [
		["2046-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2046-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2046-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2046-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2047" : helpers.makeTestYear("Portugal", [
		["2047-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2047-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2047-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2047-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2048" : helpers.makeTestYear("Portugal", [
		["2048-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2048-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2048-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2048-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2049" : helpers.makeTestYear("Portugal", [
		["2049-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2049-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2049-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2049-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2050" : helpers.makeTestYear("Portugal", [
		["2050-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2050-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2050-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2050-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2051" : helpers.makeTestYear("Portugal", [
		["2051-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2051-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2051-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2051-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2052" : helpers.makeTestYear("Portugal", [
		["2052-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2052-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2052-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2052-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2053" : helpers.makeTestYear("Portugal", [
		["2053-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2053-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2053-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2053-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2054" : helpers.makeTestYear("Portugal", [
		["2054-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2054-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2054-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2054-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2055" : helpers.makeTestYear("Portugal", [
		["2055-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2055-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2055-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2055-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2056" : helpers.makeTestYear("Portugal", [
		["2056-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2056-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2056-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2056-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2057" : helpers.makeTestYear("Portugal", [
		["2057-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2057-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2057-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2057-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2058" : helpers.makeTestYear("Portugal", [
		["2058-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2058-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2058-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2058-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2059" : helpers.makeTestYear("Portugal", [
		["2059-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2059-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2059-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2059-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2060" : helpers.makeTestYear("Portugal", [
		["2060-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2060-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2060-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2060-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2061" : helpers.makeTestYear("Portugal", [
		["2061-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2061-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2061-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2061-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2062" : helpers.makeTestYear("Portugal", [
		["2062-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2062-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2062-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2062-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2063" : helpers.makeTestYear("Portugal", [
		["2063-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2063-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2063-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2063-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2064" : helpers.makeTestYear("Portugal", [
		["2064-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2064-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2064-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2064-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2065" : helpers.makeTestYear("Portugal", [
		["2065-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2065-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2065-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2065-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2066" : helpers.makeTestYear("Portugal", [
		["2066-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2066-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2066-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2066-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2067" : helpers.makeTestYear("Portugal", [
		["2067-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2067-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2067-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2067-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2068" : helpers.makeTestYear("Portugal", [
		["2068-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2068-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2068-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2068-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2069" : helpers.makeTestYear("Portugal", [
		["2069-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2069-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2069-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2069-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2070" : helpers.makeTestYear("Portugal", [
		["2070-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2070-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2070-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2070-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2071" : helpers.makeTestYear("Portugal", [
		["2071-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2071-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2071-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2071-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2072" : helpers.makeTestYear("Portugal", [
		["2072-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2072-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2072-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2072-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2073" : helpers.makeTestYear("Portugal", [
		["2073-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2073-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2073-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2073-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2074" : helpers.makeTestYear("Portugal", [
		["2074-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2074-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2074-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2074-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2075" : helpers.makeTestYear("Portugal", [
		["2075-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2075-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2075-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2075-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2076" : helpers.makeTestYear("Portugal", [
		["2076-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2076-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2076-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2076-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2077" : helpers.makeTestYear("Portugal", [
		["2077-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2077-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2077-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2077-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2078" : helpers.makeTestYear("Portugal", [
		["2078-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2078-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2078-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2078-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2079" : helpers.makeTestYear("Portugal", [
		["2079-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2079-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2079-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2079-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2080" : helpers.makeTestYear("Portugal", [
		["2080-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2080-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2080-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2080-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2081" : helpers.makeTestYear("Portugal", [
		["2081-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2081-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2081-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2081-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2082" : helpers.makeTestYear("Portugal", [
		["2082-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2082-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2082-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2082-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2083" : helpers.makeTestYear("Portugal", [
		["2083-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2083-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2083-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2083-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2084" : helpers.makeTestYear("Portugal", [
		["2084-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2084-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2084-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2084-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2085" : helpers.makeTestYear("Portugal", [
		["2085-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2085-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2085-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2085-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2086" : helpers.makeTestYear("Portugal", [
		["2086-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2086-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2086-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2086-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2087" : helpers.makeTestYear("Portugal", [
		["2087-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2087-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2087-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2087-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2088" : helpers.makeTestYear("Portugal", [
		["2088-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2088-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2088-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2088-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2089" : helpers.makeTestYear("Portugal", [
		["2089-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2089-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2089-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2089-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2090" : helpers.makeTestYear("Portugal", [
		["2090-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2090-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2090-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2090-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2091" : helpers.makeTestYear("Portugal", [
		["2091-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2091-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2091-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2091-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2092" : helpers.makeTestYear("Portugal", [
		["2092-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2092-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2092-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2092-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2093" : helpers.makeTestYear("Portugal", [
		["2093-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2093-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2093-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2093-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2094" : helpers.makeTestYear("Portugal", [
		["2094-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2094-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2094-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2094-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2095" : helpers.makeTestYear("Portugal", [
		["2095-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2095-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2095-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2095-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2096" : helpers.makeTestYear("Portugal", [
		["2096-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2096-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2096-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2096-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2097" : helpers.makeTestYear("Portugal", [
		["2097-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2097-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2097-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2097-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2098" : helpers.makeTestYear("Portugal", [
		["2098-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2098-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2098-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2098-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2099" : helpers.makeTestYear("Portugal", [
		["2099-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2099-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2099-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2099-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2100" : helpers.makeTestYear("Portugal", [
		["2100-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2100-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2100-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2100-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2101" : helpers.makeTestYear("Portugal", [
		["2101-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2101-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2101-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2101-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2102" : helpers.makeTestYear("Portugal", [
		["2102-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2102-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2102-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2102-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2103" : helpers.makeTestYear("Portugal", [
		["2103-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2103-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2103-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2103-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2104" : helpers.makeTestYear("Portugal", [
		["2104-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2104-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2104-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2104-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2105" : helpers.makeTestYear("Portugal", [
		["2105-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2105-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2105-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2105-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2106" : helpers.makeTestYear("Portugal", [
		["2106-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2106-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2106-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2106-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2107" : helpers.makeTestYear("Portugal", [
		["2107-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2107-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2107-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2107-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2108" : helpers.makeTestYear("Portugal", [
		["2108-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2108-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2108-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2108-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2109" : helpers.makeTestYear("Portugal", [
		["2109-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2109-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2109-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2109-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2110" : helpers.makeTestYear("Portugal", [
		["2110-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2110-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2110-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2110-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2111" : helpers.makeTestYear("Portugal", [
		["2111-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2111-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2111-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2111-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2112" : helpers.makeTestYear("Portugal", [
		["2112-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2112-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2112-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2112-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2113" : helpers.makeTestYear("Portugal", [
		["2113-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2113-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2113-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2113-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2114" : helpers.makeTestYear("Portugal", [
		["2114-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2114-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2114-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2114-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2115" : helpers.makeTestYear("Portugal", [
		["2115-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2115-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2115-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2115-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2116" : helpers.makeTestYear("Portugal", [
		["2116-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2116-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2116-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2116-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2117" : helpers.makeTestYear("Portugal", [
		["2117-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2117-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2117-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2117-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2118" : helpers.makeTestYear("Portugal", [
		["2118-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2118-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2118-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2118-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2119" : helpers.makeTestYear("Portugal", [
		["2119-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2119-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2119-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2119-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2120" : helpers.makeTestYear("Portugal", [
		["2120-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2120-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2120-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2120-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2121" : helpers.makeTestYear("Portugal", [
		["2121-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2121-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2121-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2121-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2122" : helpers.makeTestYear("Portugal", [
		["2122-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2122-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2122-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2122-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2123" : helpers.makeTestYear("Portugal", [
		["2123-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2123-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2123-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2123-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2124" : helpers.makeTestYear("Portugal", [
		["2124-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2124-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2124-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2124-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2125" : helpers.makeTestYear("Portugal", [
		["2125-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2125-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2125-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2125-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2126" : helpers.makeTestYear("Portugal", [
		["2126-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2126-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2126-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2126-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2127" : helpers.makeTestYear("Portugal", [
		["2127-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2127-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2127-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2127-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2128" : helpers.makeTestYear("Portugal", [
		["2128-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2128-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2128-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2128-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2129" : helpers.makeTestYear("Portugal", [
		["2129-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2129-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2129-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2129-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2130" : helpers.makeTestYear("Portugal", [
		["2130-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2130-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2130-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2130-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2131" : helpers.makeTestYear("Portugal", [
		["2131-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2131-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2131-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2131-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2132" : helpers.makeTestYear("Portugal", [
		["2132-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2132-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2132-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2132-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2133" : helpers.makeTestYear("Portugal", [
		["2133-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2133-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2133-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2133-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2134" : helpers.makeTestYear("Portugal", [
		["2134-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2134-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2134-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2134-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2135" : helpers.makeTestYear("Portugal", [
		["2135-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2135-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2135-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2135-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2136" : helpers.makeTestYear("Portugal", [
		["2136-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2136-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2136-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2136-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2137" : helpers.makeTestYear("Portugal", [
		["2137-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2137-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2137-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2137-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2138" : helpers.makeTestYear("Portugal", [
		["2138-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2138-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2138-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2138-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2139" : helpers.makeTestYear("Portugal", [
		["2139-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2139-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2139-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2139-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2140" : helpers.makeTestYear("Portugal", [
		["2140-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2140-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2140-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2140-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2141" : helpers.makeTestYear("Portugal", [
		["2141-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2141-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2141-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2141-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2142" : helpers.makeTestYear("Portugal", [
		["2142-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2142-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2142-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2142-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2143" : helpers.makeTestYear("Portugal", [
		["2143-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2143-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2143-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2143-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2144" : helpers.makeTestYear("Portugal", [
		["2144-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2144-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2144-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2144-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2145" : helpers.makeTestYear("Portugal", [
		["2145-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2145-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2145-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2145-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2146" : helpers.makeTestYear("Portugal", [
		["2146-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2146-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2146-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2146-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2147" : helpers.makeTestYear("Portugal", [
		["2147-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2147-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2147-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2147-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2148" : helpers.makeTestYear("Portugal", [
		["2148-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2148-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2148-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2148-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2149" : helpers.makeTestYear("Portugal", [
		["2149-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2149-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2149-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2149-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2150" : helpers.makeTestYear("Portugal", [
		["2150-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2150-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2150-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2150-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2151" : helpers.makeTestYear("Portugal", [
		["2151-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2151-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2151-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2151-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2152" : helpers.makeTestYear("Portugal", [
		["2152-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2152-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2152-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2152-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2153" : helpers.makeTestYear("Portugal", [
		["2153-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2153-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2153-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2153-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2154" : helpers.makeTestYear("Portugal", [
		["2154-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2154-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2154-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2154-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2155" : helpers.makeTestYear("Portugal", [
		["2155-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2155-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2155-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2155-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2156" : helpers.makeTestYear("Portugal", [
		["2156-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2156-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2156-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2156-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2157" : helpers.makeTestYear("Portugal", [
		["2157-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2157-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2157-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2157-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2158" : helpers.makeTestYear("Portugal", [
		["2158-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2158-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2158-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2158-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2159" : helpers.makeTestYear("Portugal", [
		["2159-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2159-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2159-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2159-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2160" : helpers.makeTestYear("Portugal", [
		["2160-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2160-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2160-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2160-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2161" : helpers.makeTestYear("Portugal", [
		["2161-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2161-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2161-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2161-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2162" : helpers.makeTestYear("Portugal", [
		["2162-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2162-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2162-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2162-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2163" : helpers.makeTestYear("Portugal", [
		["2163-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2163-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2163-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2163-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2164" : helpers.makeTestYear("Portugal", [
		["2164-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2164-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2164-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2164-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2165" : helpers.makeTestYear("Portugal", [
		["2165-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2165-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2165-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2165-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2166" : helpers.makeTestYear("Portugal", [
		["2166-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2166-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2166-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2166-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2167" : helpers.makeTestYear("Portugal", [
		["2167-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2167-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2167-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2167-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2168" : helpers.makeTestYear("Portugal", [
		["2168-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2168-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2168-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2168-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2169" : helpers.makeTestYear("Portugal", [
		["2169-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2169-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2169-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2169-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2170" : helpers.makeTestYear("Portugal", [
		["2170-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2170-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2170-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2170-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2171" : helpers.makeTestYear("Portugal", [
		["2171-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2171-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2171-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2171-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2172" : helpers.makeTestYear("Portugal", [
		["2172-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2172-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2172-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2172-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2173" : helpers.makeTestYear("Portugal", [
		["2173-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2173-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2173-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2173-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2174" : helpers.makeTestYear("Portugal", [
		["2174-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2174-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2174-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2174-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2175" : helpers.makeTestYear("Portugal", [
		["2175-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2175-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2175-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2175-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2176" : helpers.makeTestYear("Portugal", [
		["2176-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2176-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2176-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2176-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2177" : helpers.makeTestYear("Portugal", [
		["2177-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2177-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2177-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2177-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2178" : helpers.makeTestYear("Portugal", [
		["2178-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2178-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2178-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2178-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2179" : helpers.makeTestYear("Portugal", [
		["2179-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2179-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2179-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2179-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2180" : helpers.makeTestYear("Portugal", [
		["2180-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2180-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2180-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2180-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2181" : helpers.makeTestYear("Portugal", [
		["2181-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2181-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2181-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2181-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2182" : helpers.makeTestYear("Portugal", [
		["2182-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2182-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2182-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2182-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2183" : helpers.makeTestYear("Portugal", [
		["2183-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2183-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2183-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2183-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2184" : helpers.makeTestYear("Portugal", [
		["2184-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2184-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2184-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2184-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2185" : helpers.makeTestYear("Portugal", [
		["2185-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2185-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2185-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2185-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2186" : helpers.makeTestYear("Portugal", [
		["2186-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2186-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2186-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2186-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2187" : helpers.makeTestYear("Portugal", [
		["2187-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2187-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2187-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2187-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2188" : helpers.makeTestYear("Portugal", [
		["2188-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2188-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2188-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2188-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2189" : helpers.makeTestYear("Portugal", [
		["2189-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2189-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2189-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2189-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2190" : helpers.makeTestYear("Portugal", [
		["2190-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2190-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2190-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2190-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2191" : helpers.makeTestYear("Portugal", [
		["2191-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2191-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2191-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2191-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2192" : helpers.makeTestYear("Portugal", [
		["2192-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2192-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2192-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2192-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2193" : helpers.makeTestYear("Portugal", [
		["2193-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2193-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2193-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2193-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2194" : helpers.makeTestYear("Portugal", [
		["2194-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2194-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2194-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2194-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2195" : helpers.makeTestYear("Portugal", [
		["2195-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2195-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2195-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2195-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2196" : helpers.makeTestYear("Portugal", [
		["2196-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2196-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2196-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2196-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2197" : helpers.makeTestYear("Portugal", [
		["2197-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2197-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2197-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2197-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2198" : helpers.makeTestYear("Portugal", [
		["2198-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2198-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2198-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2198-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2199" : helpers.makeTestYear("Portugal", [
		["2199-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2199-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2199-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2199-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2200" : helpers.makeTestYear("Portugal", [
		["2200-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2200-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2200-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2200-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2201" : helpers.makeTestYear("Portugal", [
		["2201-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2201-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2201-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2201-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2202" : helpers.makeTestYear("Portugal", [
		["2202-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2202-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2202-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2202-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2203" : helpers.makeTestYear("Portugal", [
		["2203-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2203-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2203-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2203-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2204" : helpers.makeTestYear("Portugal", [
		["2204-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2204-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2204-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2204-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2205" : helpers.makeTestYear("Portugal", [
		["2205-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2205-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2205-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2205-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2206" : helpers.makeTestYear("Portugal", [
		["2206-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2206-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2206-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2206-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2207" : helpers.makeTestYear("Portugal", [
		["2207-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2207-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2207-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2207-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2208" : helpers.makeTestYear("Portugal", [
		["2208-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2208-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2208-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2208-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2209" : helpers.makeTestYear("Portugal", [
		["2209-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2209-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2209-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2209-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2210" : helpers.makeTestYear("Portugal", [
		["2210-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2210-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2210-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2210-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2211" : helpers.makeTestYear("Portugal", [
		["2211-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2211-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2211-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2211-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2212" : helpers.makeTestYear("Portugal", [
		["2212-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2212-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2212-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2212-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2213" : helpers.makeTestYear("Portugal", [
		["2213-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2213-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2213-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2213-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2214" : helpers.makeTestYear("Portugal", [
		["2214-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2214-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2214-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2214-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2215" : helpers.makeTestYear("Portugal", [
		["2215-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2215-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2215-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2215-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2216" : helpers.makeTestYear("Portugal", [
		["2216-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2216-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2216-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2216-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2217" : helpers.makeTestYear("Portugal", [
		["2217-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2217-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2217-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2217-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2218" : helpers.makeTestYear("Portugal", [
		["2218-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2218-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2218-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2218-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2219" : helpers.makeTestYear("Portugal", [
		["2219-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2219-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2219-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2219-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2220" : helpers.makeTestYear("Portugal", [
		["2220-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2220-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2220-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2220-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2221" : helpers.makeTestYear("Portugal", [
		["2221-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2221-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2221-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2221-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2222" : helpers.makeTestYear("Portugal", [
		["2222-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2222-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2222-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2222-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2223" : helpers.makeTestYear("Portugal", [
		["2223-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2223-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2223-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2223-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2224" : helpers.makeTestYear("Portugal", [
		["2224-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2224-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2224-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2224-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2225" : helpers.makeTestYear("Portugal", [
		["2225-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2225-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2225-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2225-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2226" : helpers.makeTestYear("Portugal", [
		["2226-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2226-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2226-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2226-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2227" : helpers.makeTestYear("Portugal", [
		["2227-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2227-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2227-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2227-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2228" : helpers.makeTestYear("Portugal", [
		["2228-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2228-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2228-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2228-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2229" : helpers.makeTestYear("Portugal", [
		["2229-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2229-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2229-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2229-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2230" : helpers.makeTestYear("Portugal", [
		["2230-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2230-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2230-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2230-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2231" : helpers.makeTestYear("Portugal", [
		["2231-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2231-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2231-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2231-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2232" : helpers.makeTestYear("Portugal", [
		["2232-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2232-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2232-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2232-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2233" : helpers.makeTestYear("Portugal", [
		["2233-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2233-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2233-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2233-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2234" : helpers.makeTestYear("Portugal", [
		["2234-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2234-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2234-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2234-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2235" : helpers.makeTestYear("Portugal", [
		["2235-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2235-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2235-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2235-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2236" : helpers.makeTestYear("Portugal", [
		["2236-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2236-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2236-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2236-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2237" : helpers.makeTestYear("Portugal", [
		["2237-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2237-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2237-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2237-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2238" : helpers.makeTestYear("Portugal", [
		["2238-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2238-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2238-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2238-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2239" : helpers.makeTestYear("Portugal", [
		["2239-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2239-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2239-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2239-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2240" : helpers.makeTestYear("Portugal", [
		["2240-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2240-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2240-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2240-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2241" : helpers.makeTestYear("Portugal", [
		["2241-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2241-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2241-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2241-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2242" : helpers.makeTestYear("Portugal", [
		["2242-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2242-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2242-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2242-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2243" : helpers.makeTestYear("Portugal", [
		["2243-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2243-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2243-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2243-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2244" : helpers.makeTestYear("Portugal", [
		["2244-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2244-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2244-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2244-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2245" : helpers.makeTestYear("Portugal", [
		["2245-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2245-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2245-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2245-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2246" : helpers.makeTestYear("Portugal", [
		["2246-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2246-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2246-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2246-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2247" : helpers.makeTestYear("Portugal", [
		["2247-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2247-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2247-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2247-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2248" : helpers.makeTestYear("Portugal", [
		["2248-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2248-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2248-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2248-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2249" : helpers.makeTestYear("Portugal", [
		["2249-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2249-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2249-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2249-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2250" : helpers.makeTestYear("Portugal", [
		["2250-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2250-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2250-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2250-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2251" : helpers.makeTestYear("Portugal", [
		["2251-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2251-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2251-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2251-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2252" : helpers.makeTestYear("Portugal", [
		["2252-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2252-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2252-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2252-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2253" : helpers.makeTestYear("Portugal", [
		["2253-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2253-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2253-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2253-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2254" : helpers.makeTestYear("Portugal", [
		["2254-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2254-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2254-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2254-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2255" : helpers.makeTestYear("Portugal", [
		["2255-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2255-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2255-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2255-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2256" : helpers.makeTestYear("Portugal", [
		["2256-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2256-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2256-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2256-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2257" : helpers.makeTestYear("Portugal", [
		["2257-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2257-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2257-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2257-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2258" : helpers.makeTestYear("Portugal", [
		["2258-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2258-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2258-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2258-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2259" : helpers.makeTestYear("Portugal", [
		["2259-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2259-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2259-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2259-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2260" : helpers.makeTestYear("Portugal", [
		["2260-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2260-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2260-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2260-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2261" : helpers.makeTestYear("Portugal", [
		["2261-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2261-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2261-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2261-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2262" : helpers.makeTestYear("Portugal", [
		["2262-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2262-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2262-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2262-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2263" : helpers.makeTestYear("Portugal", [
		["2263-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2263-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2263-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2263-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2264" : helpers.makeTestYear("Portugal", [
		["2264-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2264-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2264-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2264-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2265" : helpers.makeTestYear("Portugal", [
		["2265-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2265-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2265-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2265-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2266" : helpers.makeTestYear("Portugal", [
		["2266-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2266-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2266-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2266-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2267" : helpers.makeTestYear("Portugal", [
		["2267-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2267-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2267-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2267-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2268" : helpers.makeTestYear("Portugal", [
		["2268-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2268-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2268-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2268-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2269" : helpers.makeTestYear("Portugal", [
		["2269-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2269-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2269-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2269-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2270" : helpers.makeTestYear("Portugal", [
		["2270-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2270-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2270-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2270-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2271" : helpers.makeTestYear("Portugal", [
		["2271-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2271-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2271-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2271-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2272" : helpers.makeTestYear("Portugal", [
		["2272-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2272-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2272-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2272-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2273" : helpers.makeTestYear("Portugal", [
		["2273-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2273-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2273-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2273-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2274" : helpers.makeTestYear("Portugal", [
		["2274-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2274-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2274-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2274-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2275" : helpers.makeTestYear("Portugal", [
		["2275-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2275-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2275-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2275-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2276" : helpers.makeTestYear("Portugal", [
		["2276-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2276-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2276-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2276-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2277" : helpers.makeTestYear("Portugal", [
		["2277-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2277-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2277-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2277-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2278" : helpers.makeTestYear("Portugal", [
		["2278-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2278-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2278-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2278-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2279" : helpers.makeTestYear("Portugal", [
		["2279-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2279-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2279-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2279-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2280" : helpers.makeTestYear("Portugal", [
		["2280-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2280-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2280-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2280-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2281" : helpers.makeTestYear("Portugal", [
		["2281-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2281-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2281-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2281-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2282" : helpers.makeTestYear("Portugal", [
		["2282-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2282-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2282-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2282-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2283" : helpers.makeTestYear("Portugal", [
		["2283-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2283-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2283-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2283-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2284" : helpers.makeTestYear("Portugal", [
		["2284-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2284-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2284-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2284-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2285" : helpers.makeTestYear("Portugal", [
		["2285-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2285-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2285-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2285-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2286" : helpers.makeTestYear("Portugal", [
		["2286-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2286-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2286-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2286-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2287" : helpers.makeTestYear("Portugal", [
		["2287-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2287-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2287-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2287-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2288" : helpers.makeTestYear("Portugal", [
		["2288-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2288-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2288-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2288-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2289" : helpers.makeTestYear("Portugal", [
		["2289-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2289-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2289-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2289-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2290" : helpers.makeTestYear("Portugal", [
		["2290-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2290-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2290-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2290-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2291" : helpers.makeTestYear("Portugal", [
		["2291-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2291-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2291-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2291-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2292" : helpers.makeTestYear("Portugal", [
		["2292-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2292-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2292-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2292-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2293" : helpers.makeTestYear("Portugal", [
		["2293-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2293-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2293-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2293-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2294" : helpers.makeTestYear("Portugal", [
		["2294-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2294-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2294-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2294-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2295" : helpers.makeTestYear("Portugal", [
		["2295-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2295-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2295-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2295-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2296" : helpers.makeTestYear("Portugal", [
		["2296-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2296-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2296-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2296-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2297" : helpers.makeTestYear("Portugal", [
		["2297-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2297-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2297-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2297-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2298" : helpers.makeTestYear("Portugal", [
		["2298-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2298-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2298-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2298-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2299" : helpers.makeTestYear("Portugal", [
		["2299-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2299-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2299-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2299-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2300" : helpers.makeTestYear("Portugal", [
		["2300-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2300-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2300-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2300-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2301" : helpers.makeTestYear("Portugal", [
		["2301-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2301-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2301-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2301-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2302" : helpers.makeTestYear("Portugal", [
		["2302-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2302-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2302-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2302-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2303" : helpers.makeTestYear("Portugal", [
		["2303-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2303-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2303-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2303-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2304" : helpers.makeTestYear("Portugal", [
		["2304-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2304-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2304-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2304-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2305" : helpers.makeTestYear("Portugal", [
		["2305-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2305-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2305-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2305-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2306" : helpers.makeTestYear("Portugal", [
		["2306-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2306-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2306-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2306-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2307" : helpers.makeTestYear("Portugal", [
		["2307-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2307-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2307-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2307-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2308" : helpers.makeTestYear("Portugal", [
		["2308-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2308-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2308-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2308-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2309" : helpers.makeTestYear("Portugal", [
		["2309-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2309-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2309-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2309-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2310" : helpers.makeTestYear("Portugal", [
		["2310-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2310-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2310-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2310-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2311" : helpers.makeTestYear("Portugal", [
		["2311-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2311-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2311-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2311-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2312" : helpers.makeTestYear("Portugal", [
		["2312-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2312-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2312-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2312-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2313" : helpers.makeTestYear("Portugal", [
		["2313-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2313-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2313-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2313-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2314" : helpers.makeTestYear("Portugal", [
		["2314-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2314-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2314-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2314-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2315" : helpers.makeTestYear("Portugal", [
		["2315-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2315-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2315-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2315-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2316" : helpers.makeTestYear("Portugal", [
		["2316-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2316-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2316-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2316-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2317" : helpers.makeTestYear("Portugal", [
		["2317-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2317-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2317-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2317-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2318" : helpers.makeTestYear("Portugal", [
		["2318-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2318-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2318-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2318-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2319" : helpers.makeTestYear("Portugal", [
		["2319-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2319-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2319-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2319-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2320" : helpers.makeTestYear("Portugal", [
		["2320-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2320-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2320-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2320-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2321" : helpers.makeTestYear("Portugal", [
		["2321-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2321-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2321-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2321-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2322" : helpers.makeTestYear("Portugal", [
		["2322-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2322-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2322-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2322-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2323" : helpers.makeTestYear("Portugal", [
		["2323-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2323-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2323-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2323-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2324" : helpers.makeTestYear("Portugal", [
		["2324-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2324-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2324-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2324-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2325" : helpers.makeTestYear("Portugal", [
		["2325-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2325-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2325-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2325-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2326" : helpers.makeTestYear("Portugal", [
		["2326-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2326-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2326-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2326-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2327" : helpers.makeTestYear("Portugal", [
		["2327-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2327-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2327-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2327-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2328" : helpers.makeTestYear("Portugal", [
		["2328-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2328-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2328-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2328-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2329" : helpers.makeTestYear("Portugal", [
		["2329-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2329-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2329-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2329-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2330" : helpers.makeTestYear("Portugal", [
		["2330-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2330-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2330-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2330-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2331" : helpers.makeTestYear("Portugal", [
		["2331-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2331-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2331-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2331-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2332" : helpers.makeTestYear("Portugal", [
		["2332-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2332-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2332-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2332-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2333" : helpers.makeTestYear("Portugal", [
		["2333-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2333-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2333-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2333-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2334" : helpers.makeTestYear("Portugal", [
		["2334-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2334-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2334-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2334-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2335" : helpers.makeTestYear("Portugal", [
		["2335-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2335-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2335-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2335-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2336" : helpers.makeTestYear("Portugal", [
		["2336-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2336-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2336-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2336-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2337" : helpers.makeTestYear("Portugal", [
		["2337-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2337-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2337-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2337-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2338" : helpers.makeTestYear("Portugal", [
		["2338-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2338-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2338-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2338-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2339" : helpers.makeTestYear("Portugal", [
		["2339-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2339-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2339-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2339-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2340" : helpers.makeTestYear("Portugal", [
		["2340-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2340-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2340-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2340-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2341" : helpers.makeTestYear("Portugal", [
		["2341-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2341-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2341-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2341-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2342" : helpers.makeTestYear("Portugal", [
		["2342-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2342-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2342-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2342-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2343" : helpers.makeTestYear("Portugal", [
		["2343-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2343-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2343-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2343-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2344" : helpers.makeTestYear("Portugal", [
		["2344-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2344-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2344-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2344-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2345" : helpers.makeTestYear("Portugal", [
		["2345-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2345-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2345-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2345-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2346" : helpers.makeTestYear("Portugal", [
		["2346-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2346-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2346-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2346-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2347" : helpers.makeTestYear("Portugal", [
		["2347-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2347-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2347-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2347-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2348" : helpers.makeTestYear("Portugal", [
		["2348-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2348-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2348-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2348-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2349" : helpers.makeTestYear("Portugal", [
		["2349-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2349-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2349-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2349-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2350" : helpers.makeTestYear("Portugal", [
		["2350-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2350-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2350-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2350-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2351" : helpers.makeTestYear("Portugal", [
		["2351-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2351-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2351-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2351-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2352" : helpers.makeTestYear("Portugal", [
		["2352-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2352-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2352-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2352-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2353" : helpers.makeTestYear("Portugal", [
		["2353-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2353-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2353-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2353-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2354" : helpers.makeTestYear("Portugal", [
		["2354-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2354-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2354-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2354-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2355" : helpers.makeTestYear("Portugal", [
		["2355-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2355-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2355-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2355-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2356" : helpers.makeTestYear("Portugal", [
		["2356-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2356-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2356-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2356-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2357" : helpers.makeTestYear("Portugal", [
		["2357-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2357-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2357-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2357-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2358" : helpers.makeTestYear("Portugal", [
		["2358-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2358-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2358-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2358-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2359" : helpers.makeTestYear("Portugal", [
		["2359-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2359-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2359-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2359-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2360" : helpers.makeTestYear("Portugal", [
		["2360-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2360-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2360-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2360-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2361" : helpers.makeTestYear("Portugal", [
		["2361-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2361-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2361-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2361-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2362" : helpers.makeTestYear("Portugal", [
		["2362-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2362-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2362-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2362-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2363" : helpers.makeTestYear("Portugal", [
		["2363-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2363-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2363-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2363-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2364" : helpers.makeTestYear("Portugal", [
		["2364-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2364-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2364-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2364-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2365" : helpers.makeTestYear("Portugal", [
		["2365-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2365-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2365-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2365-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2366" : helpers.makeTestYear("Portugal", [
		["2366-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2366-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2366-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2366-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2367" : helpers.makeTestYear("Portugal", [
		["2367-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2367-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2367-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2367-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2368" : helpers.makeTestYear("Portugal", [
		["2368-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2368-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2368-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2368-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2369" : helpers.makeTestYear("Portugal", [
		["2369-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2369-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2369-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2369-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2370" : helpers.makeTestYear("Portugal", [
		["2370-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2370-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2370-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2370-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2371" : helpers.makeTestYear("Portugal", [
		["2371-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2371-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2371-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2371-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2372" : helpers.makeTestYear("Portugal", [
		["2372-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2372-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2372-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2372-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2373" : helpers.makeTestYear("Portugal", [
		["2373-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2373-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2373-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2373-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2374" : helpers.makeTestYear("Portugal", [
		["2374-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2374-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2374-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2374-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2375" : helpers.makeTestYear("Portugal", [
		["2375-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2375-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2375-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2375-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2376" : helpers.makeTestYear("Portugal", [
		["2376-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2376-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2376-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2376-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2377" : helpers.makeTestYear("Portugal", [
		["2377-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2377-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2377-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2377-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2378" : helpers.makeTestYear("Portugal", [
		["2378-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2378-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2378-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2378-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2379" : helpers.makeTestYear("Portugal", [
		["2379-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2379-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2379-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2379-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2380" : helpers.makeTestYear("Portugal", [
		["2380-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2380-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2380-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2380-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2381" : helpers.makeTestYear("Portugal", [
		["2381-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2381-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2381-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2381-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2382" : helpers.makeTestYear("Portugal", [
		["2382-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2382-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2382-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2382-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2383" : helpers.makeTestYear("Portugal", [
		["2383-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2383-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2383-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2383-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2384" : helpers.makeTestYear("Portugal", [
		["2384-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2384-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2384-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2384-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2385" : helpers.makeTestYear("Portugal", [
		["2385-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2385-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2385-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2385-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2386" : helpers.makeTestYear("Portugal", [
		["2386-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2386-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2386-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2386-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2387" : helpers.makeTestYear("Portugal", [
		["2387-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2387-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2387-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2387-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2388" : helpers.makeTestYear("Portugal", [
		["2388-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2388-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2388-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2388-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2389" : helpers.makeTestYear("Portugal", [
		["2389-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2389-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2389-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2389-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2390" : helpers.makeTestYear("Portugal", [
		["2390-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2390-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2390-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2390-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2391" : helpers.makeTestYear("Portugal", [
		["2391-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2391-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2391-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2391-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2392" : helpers.makeTestYear("Portugal", [
		["2392-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2392-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2392-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2392-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2393" : helpers.makeTestYear("Portugal", [
		["2393-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2393-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2393-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2393-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2394" : helpers.makeTestYear("Portugal", [
		["2394-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2394-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2394-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2394-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2395" : helpers.makeTestYear("Portugal", [
		["2395-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2395-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2395-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2395-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2396" : helpers.makeTestYear("Portugal", [
		["2396-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2396-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2396-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2396-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2397" : helpers.makeTestYear("Portugal", [
		["2397-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2397-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2397-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2397-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2398" : helpers.makeTestYear("Portugal", [
		["2398-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2398-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2398-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2398-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2399" : helpers.makeTestYear("Portugal", [
		["2399-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2399-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2399-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2399-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2400" : helpers.makeTestYear("Portugal", [
		["2400-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2400-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2400-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2400-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2401" : helpers.makeTestYear("Portugal", [
		["2401-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2401-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2401-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2401-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2402" : helpers.makeTestYear("Portugal", [
		["2402-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2402-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2402-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2402-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2403" : helpers.makeTestYear("Portugal", [
		["2403-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2403-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2403-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2403-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2404" : helpers.makeTestYear("Portugal", [
		["2404-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2404-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2404-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2404-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2405" : helpers.makeTestYear("Portugal", [
		["2405-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2405-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2405-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2405-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2406" : helpers.makeTestYear("Portugal", [
		["2406-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2406-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2406-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2406-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2407" : helpers.makeTestYear("Portugal", [
		["2407-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2407-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2407-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2407-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2408" : helpers.makeTestYear("Portugal", [
		["2408-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2408-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2408-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2408-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2409" : helpers.makeTestYear("Portugal", [
		["2409-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2409-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2409-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2409-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2410" : helpers.makeTestYear("Portugal", [
		["2410-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2410-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2410-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2410-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2411" : helpers.makeTestYear("Portugal", [
		["2411-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2411-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2411-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2411-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2412" : helpers.makeTestYear("Portugal", [
		["2412-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2412-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2412-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2412-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2413" : helpers.makeTestYear("Portugal", [
		["2413-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2413-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2413-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2413-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2414" : helpers.makeTestYear("Portugal", [
		["2414-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2414-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2414-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2414-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2415" : helpers.makeTestYear("Portugal", [
		["2415-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2415-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2415-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2415-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2416" : helpers.makeTestYear("Portugal", [
		["2416-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2416-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2416-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2416-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2417" : helpers.makeTestYear("Portugal", [
		["2417-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2417-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2417-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2417-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2418" : helpers.makeTestYear("Portugal", [
		["2418-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2418-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2418-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2418-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2419" : helpers.makeTestYear("Portugal", [
		["2419-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2419-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2419-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2419-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2420" : helpers.makeTestYear("Portugal", [
		["2420-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2420-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2420-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2420-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2421" : helpers.makeTestYear("Portugal", [
		["2421-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2421-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2421-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2421-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2422" : helpers.makeTestYear("Portugal", [
		["2422-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2422-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2422-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2422-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2423" : helpers.makeTestYear("Portugal", [
		["2423-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2423-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2423-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2423-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2424" : helpers.makeTestYear("Portugal", [
		["2424-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2424-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2424-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2424-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2425" : helpers.makeTestYear("Portugal", [
		["2425-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2425-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2425-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2425-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2426" : helpers.makeTestYear("Portugal", [
		["2426-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2426-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2426-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2426-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2427" : helpers.makeTestYear("Portugal", [
		["2427-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2427-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2427-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2427-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2428" : helpers.makeTestYear("Portugal", [
		["2428-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2428-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2428-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2428-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2429" : helpers.makeTestYear("Portugal", [
		["2429-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2429-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2429-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2429-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2430" : helpers.makeTestYear("Portugal", [
		["2430-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2430-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2430-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2430-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2431" : helpers.makeTestYear("Portugal", [
		["2431-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2431-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2431-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2431-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2432" : helpers.makeTestYear("Portugal", [
		["2432-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2432-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2432-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2432-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2433" : helpers.makeTestYear("Portugal", [
		["2433-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2433-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2433-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2433-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2434" : helpers.makeTestYear("Portugal", [
		["2434-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2434-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2434-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2434-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2435" : helpers.makeTestYear("Portugal", [
		["2435-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2435-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2435-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2435-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2436" : helpers.makeTestYear("Portugal", [
		["2436-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2436-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2436-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2436-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2437" : helpers.makeTestYear("Portugal", [
		["2437-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2437-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2437-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2437-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2438" : helpers.makeTestYear("Portugal", [
		["2438-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2438-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2438-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2438-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2439" : helpers.makeTestYear("Portugal", [
		["2439-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2439-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2439-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2439-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2440" : helpers.makeTestYear("Portugal", [
		["2440-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2440-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2440-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2440-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2441" : helpers.makeTestYear("Portugal", [
		["2441-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2441-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2441-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2441-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2442" : helpers.makeTestYear("Portugal", [
		["2442-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2442-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2442-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2442-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2443" : helpers.makeTestYear("Portugal", [
		["2443-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2443-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2443-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2443-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2444" : helpers.makeTestYear("Portugal", [
		["2444-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2444-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2444-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2444-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2445" : helpers.makeTestYear("Portugal", [
		["2445-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2445-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2445-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2445-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2446" : helpers.makeTestYear("Portugal", [
		["2446-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2446-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2446-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2446-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2447" : helpers.makeTestYear("Portugal", [
		["2447-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2447-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2447-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2447-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2448" : helpers.makeTestYear("Portugal", [
		["2448-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2448-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2448-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2448-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2449" : helpers.makeTestYear("Portugal", [
		["2449-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2449-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2449-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2449-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2450" : helpers.makeTestYear("Portugal", [
		["2450-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2450-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2450-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2450-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2451" : helpers.makeTestYear("Portugal", [
		["2451-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2451-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2451-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2451-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2452" : helpers.makeTestYear("Portugal", [
		["2452-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2452-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2452-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2452-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2453" : helpers.makeTestYear("Portugal", [
		["2453-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2453-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2453-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2453-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2454" : helpers.makeTestYear("Portugal", [
		["2454-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2454-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2454-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2454-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2455" : helpers.makeTestYear("Portugal", [
		["2455-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2455-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2455-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2455-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2456" : helpers.makeTestYear("Portugal", [
		["2456-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2456-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2456-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2456-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2457" : helpers.makeTestYear("Portugal", [
		["2457-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2457-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2457-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2457-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2458" : helpers.makeTestYear("Portugal", [
		["2458-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2458-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2458-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2458-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2459" : helpers.makeTestYear("Portugal", [
		["2459-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2459-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2459-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2459-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2460" : helpers.makeTestYear("Portugal", [
		["2460-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2460-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2460-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2460-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2461" : helpers.makeTestYear("Portugal", [
		["2461-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2461-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2461-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2461-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2462" : helpers.makeTestYear("Portugal", [
		["2462-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2462-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2462-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2462-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2463" : helpers.makeTestYear("Portugal", [
		["2463-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2463-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2463-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2463-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2464" : helpers.makeTestYear("Portugal", [
		["2464-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2464-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2464-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2464-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2465" : helpers.makeTestYear("Portugal", [
		["2465-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2465-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2465-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2465-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2466" : helpers.makeTestYear("Portugal", [
		["2466-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2466-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2466-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2466-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2467" : helpers.makeTestYear("Portugal", [
		["2467-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2467-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2467-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2467-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2468" : helpers.makeTestYear("Portugal", [
		["2468-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2468-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2468-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2468-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2469" : helpers.makeTestYear("Portugal", [
		["2469-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2469-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2469-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2469-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2470" : helpers.makeTestYear("Portugal", [
		["2470-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2470-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2470-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2470-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2471" : helpers.makeTestYear("Portugal", [
		["2471-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2471-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2471-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2471-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2472" : helpers.makeTestYear("Portugal", [
		["2472-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2472-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2472-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2472-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2473" : helpers.makeTestYear("Portugal", [
		["2473-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2473-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2473-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2473-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2474" : helpers.makeTestYear("Portugal", [
		["2474-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2474-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2474-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2474-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2475" : helpers.makeTestYear("Portugal", [
		["2475-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2475-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2475-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2475-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2476" : helpers.makeTestYear("Portugal", [
		["2476-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2476-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2476-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2476-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2477" : helpers.makeTestYear("Portugal", [
		["2477-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2477-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2477-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2477-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2478" : helpers.makeTestYear("Portugal", [
		["2478-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2478-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2478-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2478-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2479" : helpers.makeTestYear("Portugal", [
		["2479-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2479-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2479-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2479-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2480" : helpers.makeTestYear("Portugal", [
		["2480-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2480-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2480-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2480-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2481" : helpers.makeTestYear("Portugal", [
		["2481-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2481-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2481-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2481-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2482" : helpers.makeTestYear("Portugal", [
		["2482-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2482-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2482-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2482-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2483" : helpers.makeTestYear("Portugal", [
		["2483-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2483-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2483-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2483-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2484" : helpers.makeTestYear("Portugal", [
		["2484-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2484-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2484-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2484-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2485" : helpers.makeTestYear("Portugal", [
		["2485-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2485-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2485-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2485-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2486" : helpers.makeTestYear("Portugal", [
		["2486-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2486-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2486-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2486-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2487" : helpers.makeTestYear("Portugal", [
		["2487-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2487-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2487-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2487-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2488" : helpers.makeTestYear("Portugal", [
		["2488-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2488-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2488-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2488-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2489" : helpers.makeTestYear("Portugal", [
		["2489-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2489-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2489-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2489-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2490" : helpers.makeTestYear("Portugal", [
		["2490-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2490-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2490-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2490-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2491" : helpers.makeTestYear("Portugal", [
		["2491-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2491-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2491-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2491-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2492" : helpers.makeTestYear("Portugal", [
		["2492-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2492-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2492-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2492-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2493" : helpers.makeTestYear("Portugal", [
		["2493-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2493-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2493-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2493-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2494" : helpers.makeTestYear("Portugal", [
		["2494-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2494-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2494-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2494-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2495" : helpers.makeTestYear("Portugal", [
		["2495-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2495-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2495-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2495-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2496" : helpers.makeTestYear("Portugal", [
		["2496-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2496-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2496-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2496-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2497" : helpers.makeTestYear("Portugal", [
		["2497-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2497-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2497-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2497-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2498" : helpers.makeTestYear("Portugal", [
		["2498-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2498-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2498-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2498-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2499" : helpers.makeTestYear("Portugal", [
		["2499-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2499-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2499-10-25T00:59:59+00:00", "01:59:59", "WEST", -60]
	])
};