#!/bin/sh

# Moves the following files out of the way so they
# are auto rebuilt.
FILES="language.c language.h lexer.c"

set -e

domv() {
    echo "Moving $1 -> $2"
    if [ -f "$1" ] ; then
        mv "$1" "$2" || exit 1
    else
        echo "not needed."
    fi
}

prebuild() {
    for FILE in $FILES ; do
        domv "src/$FILE" debian/
    done
}

clean() {
    for FILE in $FILES ; do
        domv "debian/$FILE" src/
    done
}

if [ "$1" = prebuild ] ; then
    prebuild
elif [ "$1" = clean ] ; then
    clean
else
    echo "Unknown argument $1" >&2
    exit 1
fi

