/*  BEGIN software license
 *
 *  msXpertSuite - mass spectrometry software suite
 *  -----------------------------------------------
 *  Copyright(C) 2009, 2017 Filippo Rusconi
 *
 *  http://www.msxpertsuite.org
 *
 *  This file is part of the msXpertSuite project.
 *
 *  The msXpertSuite project is the successor of the massXpert project. This
 *  project now includes various independent modules:
 *  
 *  - massXpert, model polymer chemistries and simulate mass spectrometric data;
 *  - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * END software license
 */


#pragma once


/////////////////////// Qt includes
#include <QString>
#include <QObject>
#include <QScriptable>
#include <QScriptValue>
#include <QScriptString>
#include <QScriptClass>


/////////////////////// Local includes
#include <libmass/MassSpectrum.hpp>


namespace msXpSlibmass
{
	class MassSpectrum;

	class MassSpectrumJsPrototype
		:
			public QObject,
			public QScriptable
	{
		Q_OBJECT

		private:

			MassSpectrum *thisMassSpectrum() const;

		public:	

			MassSpectrumJsPrototype(QObject *parent = 0);
			~MassSpectrumJsPrototype();

			public slots:

				int initializeWithTrace();

				int initializeWithString(const QString &xyFormatString);

			int initializeWithLists(const QList<double> &mzList, const QList<double> &iList);

			int initializeWithRangedLists(const QList<double> &mzList, const QList<double> &iList,
					double mzStart, double mzEnd);

			int initializeWithListsAndRt(const QList<double> &mzList, const QList<double> &iList,
					double rt);

			int initializeWithListsAndDt(const QList<double> &mzList, const QList<double> &iList,
					double dt);

			int initializeWithRangedListsAndRt(const QList<double> &mzList, const QList<double> &iList,
					double rt, double mzStart, double mzEnd);

			int initializeWithRangedListsAndDt(const QList<double> &mzList, const QList<double> &iList,
					double dt, double mzStart, double mzEnd);

			QList<double> mzArray() const;
			QList<double> iArray() const;

			QString asText();

			double tic() const; 

			int combine();
			int subtract();

			QScriptValue valueOf() const;
	};

} // namespace msXpSlibmass

