dnl *
dnl * for supporting --with-emacs=EMACS, --with-lispdir=DIR
dnl *
dnl * Imported from Lookup [1999-11-02]

dnl Copyright (C) 1999 NISHIDA Keisuke <knishida@ring.aist.go.jp>
dnl
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2, or (at your option)
dnl any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
dnl 02111-1307, USA.

AC_DEFUN(AM_PATH_LISPDIR,
 [dnl #
  dnl # Check Emacs
  dnl #
  AC_ARG_WITH(emacs,
    [  --with-emacs=EMACS      compile with EMACS [EMACS=emacs, xemacs...]],
    [case "${withval}" in
       yes)	EMACS= ;;
       no)	EMACS="no" ;;
       *)	EMACS=${withval} ;;
     esac], EMACS=)
  if test "x$EMACS" = "xt" -o "x$EMACS" = x; then
    AC_PATH_PROGS(EMACS, emacs xemacs mule, no)
  fi
  dnl # 
  dnl # Check Emacs directories
  dnl #
  if test $EMACS != "no"; then
    AC_MSG_CHECKING([where emacs files are in])
    EMACS_BASENAME="`echo x$EMACS | sed -e 's/x//' -e 's/^.*\///'`"
    if test "x$emacsdir" = x; then
      if test "x$prefix" = "xNONE"; then
        tmpprefix=$ac_default_prefix
      else
	tmpprefix=$prefix
      fi
      emacsdir="\$(datadir)/emacs"
      case "$EMACS_BASENAME" in
      emacs|emacs-*)
        if test -d $tmpprefix/lib/emacs; then
  	emacsdir="\$(prefix)/lib/emacs"
        fi
        if test -d $tmpprefix/share/emacs; then
  	emacsdir="\$(prefix)/share/emacs"
        fi
        ;;
      xemacs|xemacs-*)
        if test -d $tmpprefix/lib/xemacs; then
  	emacsdir="\$(prefix)/lib/xemacs"
        fi
        if test -d $tmpprefix/share/xemacs; then
  	emacsdir="\$(prefix)/share/xemacs"
        fi
        ;;
      mule|mule-*)
        if test -d $tmpprefix/lib/emacs; then
  	emacsdir="\$(prefix)/lib/emacs"
        fi
        if test -d $tmpprefix/share/emacs; then
  	emacsdir="\$(prefix)/share/emacs"
        fi
        if test -d $tmpprefix/lib/mule; then
  	emacsdir="\$(prefix)/lib/mule"
        fi
        if test -d $tmpprefix/share/mule; then
  	emacsdir="\$(prefix)/share/mule"
        fi
        ;;
      esac
    fi
    AC_MSG_RESULT($emacsdir)
    dnl # 
    dnl # Check Emacs site-lisp directories
    dnl #
    AC_ARG_WITH(lispdir,
      [  --with-lispdir=DIR      emacs lisp are in DIR [guessed]],
      [case "${withval}" in
         yes)	lispdir= ;;
         no)	lispdir="no" ;;
         *)	lispdir=${withval} ;;
       esac], lispdir=)
    AC_MSG_CHECKING([where .elc files should go])
    if test $EMACS != "no"; then
      if test "x$lispdir" = x; then
        lispdir="$emacsdir/site-lisp"
        if test -d $emacsdir/lisp; then
          lispdir="$emacsdir/lisp"
        fi
        case "$EMACS_BASENAME" in
        xemacs|xemacs-*)
          lispdir="$lispdir/namazu"
          ;;
        esac
      fi
      AC_MSG_RESULT($lispdir)
    fi
  fi
AC_SUBST(lispdir)])

## AM_WITH_CCMALLOC - based on AM_WITH_DMALLOC in automake-1.4.
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##
## As a special exception to the GNU General Public License, if you
## distribute this file as part of a program that contains a
## configuration script generated by Autoconf, you may include it under
## the same distribution terms that you use for the rest of that program.

AC_DEFUN(AM_WITH_CCMALLOC,
[AC_MSG_CHECKING(if malloc debugging is wanted)
AC_ARG_WITH(ccmalloc,
[  --with-ccmalloc         use ccmalloc, as in
                           http://www.inf.ethz.ch/personal/biere/projects/ccmalloc/],
[if test "$withval" = yes; then
  AC_MSG_RESULT(yes)
  AC_DEFINE(WITH_CCMALLOC,1,
            [Define if using the ccmalloc debugging malloc package])
  LIBS="$LIBS -lccmalloc -ldl"
  LDFLAGS="$LDFLAGS -g"
else
  AC_MSG_RESULT(no)
fi], [AC_MSG_RESULT(no)])
])

## libnmz adaptation by Ryuji Abe <rug@namazu.org>, 09/05/2000
##
## NMZ_REPLACE_FUNCS - Similar to AC_REPLACE_FUNCS but set NMZ_LIBOBJS
## instead of LIBOBJS.

AC_DEFUN(NMZ_REPLACE_FUNCS,
[AC_CHECK_FUNCS([$1], , [NMZ_LIBOBJS="$NMZ_LIBOBJS ${ac_func}.lo"])
AC_SUBST(NMZ_LIBOBJS)dnl
])

## NMZ_FUNC_MEMCMP - based on Jim Meyering's jm_FUNC_MEMCMP.

dnl A replacement for autoconf's AC_FUNC_MEMCMP that detects
dnl the losing memcmp on some x86 Next systems.
AC_DEFUN(NMZ_CHECK_MEMCMP,
[AC_CACHE_CHECK([for working memcmp], nmz_cv_func_memcmp_working,
[AC_TRY_RUN(
changequote(<<, >>)dnl
<<
main()
{
  /* Some versions of memcmp are not 8-bit clean.  */
  char c0 = 0x40, c1 = 0x80, c2 = 0x81;
  if (memcmp(&c0, &c2, 1) >= 0 || memcmp(&c1, &c2, 1) >= 0)
    exit (1);

  /* The Next x86 OpenStep bug shows up only when comparing 16 bytes
     or more and with at least one buffer not starting on a 4-byte boundary.
     William Lewis provided this test program.   */
  {
    char foo[21];
    char bar[21];
    int i;
    for (i = 0; i < 4; i++)
      {
	char *a = foo + i;
	char *b = bar + i;
	strcpy (a, "--------01111111");
	strcpy (b, "--------10000000");
	if (memcmp (a, b, 16) >= 0)
	  exit (1);
      }
    exit (0);
  }
}
>>,
changequote([, ])dnl
   nmz_cv_func_memcmp_working=yes,
   nmz_cv_func_memcmp_working=no,
   nmz_cv_func_memcmp_working=no)])
test $nmz_cv_func_memcmp_working = no \
  && NMZ_LIBOBJS="$NMZ_LIBOBJS memcmp.lo"
AC_SUBST(NMZ_LIBOBJS)dnl
])

AC_DEFUN(NMZ_FUNC_MEMCMP,
[AC_REQUIRE([NMZ_CHECK_MEMCMP])dnl
 if test $nmz_cv_func_memcmp_working = no; then
   AC_DEFINE_UNQUOTED(memcmp, _nmz_memcmp,
     [Define to _nmz_memcmp if the replacement function should be used.])
 fi
])
