/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.cnd.completion.cplusplus.ext;
import java.beans.PropertyVetoException;
import java.io.*;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.cnd.completion.cplusplus.CsmCompletionProvider;
import org.openide.filesystems.FileObject;
import org.netbeans.editor.*;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.test.CndCoreTestUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.filesystems.FileLock;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

/**
 * <FONT COLOR="#CC3333" FACE="Courier New, Monospaced" SIZE="+1">
 * <B>
 * Completion module API test: completion/CompletionTestPerformer
 * </B>
 * </FONT>
 * 
 * <P>
 * <B>What it tests:</B><BR>
 * The purpose of this test is to test C/C++ code completion. This test
 * is done on some layer between user and API. It uses file and completion
 * is called on the top of the file, but it is never shown.
 * </P>
 * 
 * <P>
 * <B>How it works:</B><BR>
 * TestFile is opened, given text is written to it, and code completion is
 * asked to return response for (row, col) position of document.
 * The type of completion is defined by the type of the file. 
 * Unfortunately, it is not possible to ask completion for response
 * without opening the file.
 * </P>
 * 
 * <P>
 * <B>Settings:</B><BR>
 * This test is not complete test, it's only stub, so for concrete test instance
 * it's necessary to provide text to add and whether the response should be
 * sorted. No more settings needed, when runned on clean build.
 * </P>
 * 
 * <P>
 * <B>Output:</B><BR>
 * The output should be completion reponse in human readable form.
 * </P>
 * 
 * <P>
 * <B>Possible reasons of failure:</B><BR>
 * <UL>
 * <LI>An exception when obtaining indent engine (for example if it doesn't exist).</LI>
 * <LI>An exception when writting to indent engine.</LI>
 * <LI>Possibly unrecognized MIME type.</LI>
 * <LI>Indent engine error.</LI>
 * <LI>The file can not be opened. This test must be able to open the file.
 * The test will fail if it is not able to open the file. In case it starts
 * opening sequence, but the editor is not opened, it may lock.</LI>
 * </UL>
 * </P>
 * 
 * 
 * (copy of Jan Lahoda CompletionTest.java)
 * 
 * @author Vladimir Voskresensky
 * @version 1.0
 */
public class CompletionTestPerformer {
    
    private static final long OPENING_TIMEOUT = 60 * 1000;
    private static final long SLEEP_TIME = 1000;
    
    private final CsmCompletionQuery.QueryScope queryScope;
    /**
     * Creates new CompletionTestPerformer
     */
    public CompletionTestPerformer() {
        this(CsmCompletionQuery.QueryScope.GLOBAL_QUERY);
    }
    
    public CompletionTestPerformer(CsmCompletionQuery.QueryScope queryScope) {
        this.queryScope = queryScope;
    }
    
    protected CompletionItem[] completionQuery(
            PrintWriter  log,
            JEditorPane  editor,
            BaseDocument doc,
            int caretOffset,
            boolean      unsorted) {
        doc = doc == null ? Utilities.getDocument(editor) : doc;
        CsmFile csmFile = CsmUtilities.getCsmFile(doc, false, false);
        assert csmFile != null : "Must be csmFile for document " + doc;        
        CsmCompletionQuery query = CsmCompletionProvider.getCompletionQuery(csmFile, this.queryScope, null);
        CsmCompletionQuery.CsmCompletionResult res = query.query(editor, doc, caretOffset, false, !unsorted, true);
        
        CompletionItem[] array =  res == null ? new CompletionItem[0] : res.getItems().toArray(new CompletionItem[res.getItems().size()]);
        assert array != null;
        return array;
    }
    
    /**Currently, this method is supposed to be runned inside the AWT thread.
     * If this condition is not fullfilled, an IllegalStateException is
     * thrown. Do NOT modify this behaviour, or deadlock (or even Swing
     * or NetBeans winsys data corruption) may occur.
     *
     * Currently threading model of this method is compatible with
     * editor code completion threading model. Revise if this changes
     * in future.
     */
    private CompletionItem[] testPerform(PrintWriter log,
            JEditorPane editor,
            BaseDocument doc,
            boolean unsorted,
            final String textToInsert, int offsetAfterInsertion, 
            int lineIndex,
            int colIndex) throws BadLocationException, IOException {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("The testPerform method may be called only inside AWT event dispatch thread.");
        }
        Logger.getLogger(FileLock.class.getName()).setLevel(Level.SEVERE);
        doc = doc == null ? Utilities.getDocument(editor) : doc;
        assert doc != null;
        int offset = CndCoreTestUtils.getDocumentOffset(doc, lineIndex, colIndex);
        
        if (textToInsert.length() > 0) {
            final int insOffset = offset;
            final BaseDocument insDoc = doc;
            final BadLocationException ex[] = new BadLocationException[] { null };
            insDoc.runAtomic(new Runnable() {

                public void run() {
                    try {
                        insDoc.insertString(insOffset, textToInsert, null);
                    } catch (BadLocationException e) {
                        ex[0] = e;
                    }
                }
            });
            if (ex[0] != null) {
                throw ex[0];
            }
            String text = doc.getText(0, doc.getLength());
            parseModifiedFile((DataObject) doc.getProperty(BaseDocument.StreamDescriptionProperty),text);
            offset += textToInsert.length() + offsetAfterInsertion;
        }
        if (editor != null) {
            editor.grabFocus();
            editor.getCaret().setDot(offset);
        }        
        return completionQuery(log, editor, doc, offset, unsorted);
    }
    
    public CompletionItem[] test(final PrintWriter log,
            final String textToInsert, final int offsetAfterInsertion, final boolean unsorted,
            final File testSourceFile, final int line, final int col) throws Exception {
        try {
            final CompletionItem[][] array = new CompletionItem[][] {null};
            log.println("Completion test start.");
            log.flush();
            
            FileObject testFileObject = getTestFile(testSourceFile, log);
            final DataObject testFile = DataObject.find(testFileObject);
            if (testFile == null) {
                throw new DataObjectNotFoundException(testFileObject);
            }
            try {
                final Throwable[] asserts = new Throwable[] { null };
                final BaseDocument doc = CndCoreTestUtils.getBaseDocument(testFile);
                Runnable run = new Runnable() {
                    public void run() {
                        try {
                            array[0] = testPerform(log, null, doc, unsorted, textToInsert, offsetAfterInsertion, line, col);
                        } catch (IOException ex) {
                            ex.printStackTrace(log);
                        } catch (BadLocationException ex) {
                            ex.printStackTrace(log);
                        } catch (Throwable as) {
                            asserts[0] = as;
                        }
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    run.run();
                } else {
                    try {
                        SwingUtilities.invokeAndWait(run);
                    } catch (InvocationTargetException invocationTargetException) {
                        if (invocationTargetException.getCause() != null) {
                            invocationTargetException.getCause().printStackTrace(System.err);
                        }
                    }
                }
                if (asserts[0] != null) {
                    new Exception("\nhappens in ", asserts[0]).printStackTrace(System.err);
                }
            } finally {
                testFile.setModified(false);
                log.flush();
            }
            //((CloseCookie) testFile.getCookie(CloseCookie.class)).close();
            return array[0] == null ? new CompletionItem[0] : array[0];
        } catch (Exception e) {
            e.printStackTrace(log);
            throw e;
        }
    }
    
    private FileObject getTestFile(File testFile, PrintWriter log) throws IOException, InterruptedException, PropertyVetoException {
        FileObject test = CndFileUtils.toFileObject(testFile);
        CsmFile csmFile = CsmModelAccessor.getModel().findFile(FSPath.toFSPath(test), true, false);
        if (test == null || !test.isValid() || csmFile == null) {
            throw new IllegalStateException("Given test file does not exist, file:" + testFile + ", FO: " + test + ", CsmFile: " + csmFile);
        }
        log.println("File found: " + csmFile);
        return test;
    }
    
    private static void parseModifiedFile(DataObject dob,String docText) throws IOException { //!!!WARNING: if this exception is thrown, the test may be locked (the file in editor may be modified, but not saved. problems with IDE finishing are supposed in this case).
//        SaveCookie sc = dob.getCookie(SaveCookie.class);
//        assert sc != null : "document must have save cookie " + dob;
//        if (sc != null) {
//            sc.save();
//        }
//        FileObject fo = dob.getPrimaryFile();
//        if (fo != null) {
//            InputStream is = fo.getInputStream();
//            int ch;
//            StringBuilder fileText = new StringBuilder();
//            while ((ch = is.read()) != -1) {
//                fileText.append((char)ch);
//            }
//            is.close();
//            String text = fileText.toString();
//            if (!text.equals(docText) && false) {
//                System.err.println("file after cookie saving " + fo.getPath() + "\ntext:\n" + fileText);
//                System.err.println("document after cookie saving " + fo.getPath() + "\ntext:\n" + docText);
//            }
//        }
        CsmFile csmFile = CsmUtilities.getCsmFile(dob, false, false);
        if (csmFile == null) {
            csmFile = CsmUtilities.getCsmFile(dob, false, false);
        }
        assert csmFile != null : "Must be csmFile for data object " + dob;
        CsmProject prj = csmFile.getProject();
        assert prj != null : "Must be project for csm file " + csmFile;
        prj.waitParse();
        assert csmFile.isParsed() : " file must be parsed: " + csmFile;
        assert prj.isStable(null) : " full project must be parsed" + prj;
    }
}
