/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2009 Sun Microsystems, Inc.
 */

/*
 * EditOneDependencyPanel.java
 *
 * Created on Aug 23, 2009, 10:30:48 PM
 */

package org.netbeans.modules.javacard.project.deps.ui;

import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import org.netbeans.modules.javacard.common.GuiUtils;
import org.netbeans.modules.javacard.project.deps.ArtifactKind;
import org.netbeans.modules.javacard.project.deps.DeploymentStrategy;
import org.netbeans.modules.javacard.project.deps.ResolvedDependency;
import org.openide.util.HelpCtx;

/**
 *
 * @author Tim Boudreau
 */
final class EditOneDependencyPanel extends javax.swing.JPanel {
    private final ResolvedDependency dep;

    /** Creates new form EditOneDependencyPanel */
    public EditOneDependencyPanel(ResolvedDependency dep) {
        initComponents();
        this.dep = dep;
        ComboBoxModel mdl = new DefaultComboBoxModel(
            dep.getDependency().getKind().supportedDeploymentStrategies().toArray(
            new DeploymentStrategy[0]));
        mdl.setSelectedItem(dep.getDeploymentStrategy());
        initComponents();
        GuiUtils.prepareContainer(this);
        deploymentStrategyBox.setModel(mdl);
        pathField.setText (dep.getPath(ArtifactKind.ORIGIN));
        HelpCtx.setHelpIDString(this, "org.netbeans.modules.javacard.ChangeLibraryDeploymentStrategy"); //NOI18N
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        deploymentStrategyLabel = new javax.swing.JLabel();
        pathLabel = new javax.swing.JLabel();
        pathField = new javax.swing.JTextField();
        deploymentStrategyBox = new javax.swing.JComboBox();

        deploymentStrategyLabel.setText(org.openide.util.NbBundle.getMessage(EditOneDependencyPanel.class, "EditOneDependencyPanel.deploymentStrategyLabel.text")); // NOI18N

        pathLabel.setText(org.openide.util.NbBundle.getMessage(EditOneDependencyPanel.class, "EditOneDependencyPanel.pathLabel.text")); // NOI18N

        pathField.setEditable(false);
        pathField.setText(org.openide.util.NbBundle.getMessage(EditOneDependencyPanel.class, "EditOneDependencyPanel.pathField.text")); // NOI18N

        deploymentStrategyBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        deploymentStrategyBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onChangeDeploymentStrategy(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(pathLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                        .add(pathField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 341, Short.MAX_VALUE))
                    .add(layout.createSequentialGroup()
                        .add(deploymentStrategyLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                        .add(deploymentStrategyBox, 0, 261, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(pathLabel)
                    .add(pathField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(deploymentStrategyLabel)
                    .add(deploymentStrategyBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void onChangeDeploymentStrategy(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onChangeDeploymentStrategy
        DeploymentStrategy strat = (DeploymentStrategy) deploymentStrategyBox.getSelectedItem();
        dep.setDeploymentStrategy(strat);
    }//GEN-LAST:event_onChangeDeploymentStrategy


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox deploymentStrategyBox;
    private javax.swing.JLabel deploymentStrategyLabel;
    private javax.swing.JTextField pathField;
    private javax.swing.JLabel pathLabel;
    // End of variables declaration//GEN-END:variables

}
