/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2013 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2013 Sun Microsystems, Inc.
 */
package org.netbeans.modules.javafx2.project.ui;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.DialogDescriptor;

/**
 *
 * @author Petr Somol
 */
public class JFXRequestRuntimePanel extends javax.swing.JPanel implements DocumentListener{

    private DialogDescriptor desc;

    /**
     * Creates new form JFXRequestRuntimePanel
     */
    public JFXRequestRuntimePanel() {
        initComponents();
        textFieldRT.setText(null);
    }

    public void registerListener() {
        textFieldRT.getDocument().addDocumentListener(this);
    }
    
    public void unregisterListener() {
        textFieldRT.getDocument().removeDocumentListener(this);
    }

    public void setDialogDescriptor(DialogDescriptor desc) {
        this.desc = desc;
        updateButtons();
    }
    
    public String getInputText() {
        return textFieldRT.getText();
    }
    
    public void setInputText(String text) {
        textFieldRT.setText(text);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        labelRT = new javax.swing.JLabel();
        textFieldRT = new javax.swing.JTextField();

        labelRT.setLabelFor(textFieldRT);
        org.openide.awt.Mnemonics.setLocalizedText(labelRT, org.openide.util.NbBundle.getMessage(JFXRequestRuntimePanel.class, "JFXRequestRuntimePanel.labelRT.text")); // NOI18N
        labelRT.setToolTipText(org.openide.util.NbBundle.getMessage(JFXRequestRuntimePanel.class, "AD_JFXDeploymentPanel.textFieldRT.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(labelRT)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(textFieldRT, javax.swing.GroupLayout.DEFAULT_SIZE, 231, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(labelRT)
                    .addComponent(textFieldRT, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        textFieldRT.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(JFXRequestRuntimePanel.class, "AN_JFXDeploymentPanel.textFieldRT.text")); // NOI18N
        textFieldRT.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JFXRequestRuntimePanel.class, "AD_JFXDeploymentPanel.textFieldRT.text")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel labelRT;
    private javax.swing.JTextField textFieldRT;
    // End of variables declaration//GEN-END:variables

    @Override
    public void insertUpdate(DocumentEvent e) {
        updateButtons();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        updateButtons();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        updateButtons();
    }
    
    private void updateButtons() {
        String s = textFieldRT.getText();
        if(s == null || s.trim().isEmpty()) {
           desc.setValid(false);
        } else {
           desc.setValid(true);
        }
    }
}
