<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/charts.d.plugin/nut/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/charts.d.plugin/nut/metadata.yaml"
sidebar_label: "Network UPS Tools (NUT)"
learn_status: "Published"
learn_rel_path: "Data Collection/UPS"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Network UPS Tools (NUT)


<img src="https://netdata.cloud/img/plug-circle-bolt.svg" width="150"/>


Plugin: charts.d.plugin
Module: nut

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Examine UPS/PDU metrics with Netdata for insights into power device performance. Improve your power device performance with comprehensive dashboards and anomaly detection.

This collector uses the `nut` (Network UPS Tools) to query statistics for multiple UPS devices.

This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per ups

Metrics related to UPS. Each UPS provides its own set of the following metrics.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| nut.charge | charge | percentage |
| nut.runtime | runtime | seconds |
| nut.battery.voltage | voltage, high, low, nominal | Volts |
| nut.input.voltage | voltage, fault, nominal | Volts |
| nut.input.current | nominal | Ampere |
| nut.input.frequency | frequency, nominal | Hz |
| nut.output.voltage | voltage | Volts |
| nut.load | load | percentage |
| nut.load_usage | load_usage | Watts |
| nut.temperature | temp | temperature |
| nut.clients | clients | clients |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ nut_ups_charge ](https://github.com/netdata/netdata/blob/master/health/health.d/nut.conf) | nut.charge | average UPS charge over the last minute |
| [ nut_10min_ups_load ](https://github.com/netdata/netdata/blob/master/health/health.d/nut.conf) | nut.load | average UPS load over the last 10 minutes |
| [ nut_last_collected_secs ](https://github.com/netdata/netdata/blob/master/health/health.d/nut.conf) | nut.load | number of seconds since the last successful data collection |


## Setup

### Prerequisites

#### Install charts.d plugin

If [using our official native DEB/RPM packages](https://github.com/netdata/netdata/blob/master/packaging/installer/UPDATE.md#determine-which-installation-method-you-used), make sure `netdata-plugin-chartsd` is installed.


#### Required software

Make sure the Network UPS Tools (`nut`) is installed and can detect your UPS devices.


### Configuration

#### File

The configuration file name for this integration is `charts.d/nut.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/configure/nodes.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config charts.d/nut.conf
```
#### Options

The config file is sourced by the charts.d plugin. It's a standard bash file.

The following collapsed table contains all the options that can be configured for the nut collector.


<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| nut_ups | A space separated list of UPS names. If empty, the list returned by `upsc -l` will be used. |  | False |
| nut_names | Each line represents an alias for one UPS. If empty, the FQDN will be used. |  | False |
| nut_timeout | How long to wait for nut to respond. | 2 | False |
| nut_clients_chart | Set this to 1 to enable another chart showing the number of UPS clients connected to `upsd`. | 1 | False |
| nut_update_every | The data collection frequency. If unset, will inherit the netdata update frequency. | 2 | False |
| nut_priority | The charts priority on the dashboard | 90000 | False |
| nut_retries | The number of retries to do in case of failure before disabling the collector. | 10 | False |

</details>

#### Examples

##### Provide names to UPS devices

Map aliases to UPS devices

<details><summary>Config</summary>

```yaml
# a space separated list of UPS names
# if empty, the list returned by 'upsc -l' will be used
#nut_ups=

# each line represents an alias for one UPS
# if empty, the FQDN will be used
nut_names["XXXXXX"]="UPS-office"
nut_names["YYYYYY"]="UPS-rack"

# how much time in seconds, to wait for nut to respond
#nut_timeout=2

# set this to 1, to enable another chart showing the number
# of UPS clients connected to upsd
#nut_clients_chart=1

# the data collection frequency
# if unset, will inherit the netdata update frequency
#nut_update_every=2

# the charts priority on the dashboard
#nut_priority=90000

# the number of retries to do in case of failure
# before disabling the module
#nut_retries=10

```
</details>



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `nut` collector, run the `charts.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `charts.d.plugin` to debug the collector:

  ```bash
  ./charts.d.plugin debug 1 nut
  ```


