/*
 * $Id: TimePoint.java,v 1.1.1.1 2007/09/07 06:32:06 koennecke Exp $
 *
 * This software is provided by NOAA for full, free and open release.  It is
 * understood by the recipient/user that NOAA assumes no liability for any
 * errors contained in the code.  Although this software is released without
 * conditions or restrictions in its use, it is expected that appropriate
 * credit be given to its author and to the National Oceanic and Atmospheric
 * Administration should the software be included by the recipient as an
 * element in other product development.
 */

package  gov.noaa.pmel.util;

/**
 * TimePoint allows specification of a time-space point.
 *
 * @author Donald Denbo
 * @version $Revision: 1.1.1.1 $, $Date: 2007/09/07 06:32:06 $
 * @since sgt 1.0
 *
 * @deprecated As of sgt 3.0, replaced by {@link gov.noaa.pmel.util.SoTPoint SoTPoint}.
 */
public class TimePoint {
  /** Space coordinate  */
  public double x;
  /** Time coordinate */
  public GeoDate t;
  /**
   * Default constructor.
   */
  public TimePoint() {
  }
  /**
   * Construct a TimePoint.
   *
   * @param x space coordinate
   * @param t time coordinate
   */
  public TimePoint(double x,GeoDate t) {
    this.x = x;
    this.t = t;
  }
  /**
   * Test for equality.  Both x and t must be equal for equality.
   */
  public boolean equals(TimePoint tp) {
    if(t != null && tp.t != null) {
      return (x == tp.x && t.equals(tp.t));
    } else {
      return false;
    }
  }
  /**
   * Convert TimePoint to a default string
   *
   * @return string representation of the TimePoint.
   */
  public String toString() {
    return new String("(" + x + ", " + t.toString() + ")");
  }
}
