import compatData from "../packages/babel-plugin-polyfill-corejs3/core-js-compat/data.js";
import fs from "node:fs";

const path = new URL(
  "../packages/babel-plugin-polyfill-corejs3/src/shipped-proposals.ts",
  import.meta.url
);

const template = features => `// This file is automatically generated by scripts/build-corejs3-shipped-proposals.mjs

export default new Set<string>([
${features.map(f => `  "${f}",\n`).join("")}]);
`;

const shippedProposals = [];

for (const feature in compatData) {
  if (!feature.startsWith("esnext.")) continue;
  const esName = "es." + feature.slice(7);
  if (esName in compatData) continue;
  if (Object.keys(compatData[feature]).length === 0) continue;
  shippedProposals.push(feature);
}

fs.writeFileSync(path, template(shippedProposals));
