## API Report File for "@microsoft/fast-foundation"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { CaptureType } from '@microsoft/fast-element';
import { Constructable } from '@microsoft/fast-element';
import { CSSDirective } from '@microsoft/fast-element';
import { Direction } from '@microsoft/fast-web-utilities';
import type { ElementsFilter } from '@microsoft/fast-element';
import { ElementStyles } from '@microsoft/fast-element';
import { ElementViewTemplate } from '@microsoft/fast-element';
import { FASTElement } from '@microsoft/fast-element';
import { FASTElementDefinition } from '@microsoft/fast-element';
import { HostBehavior } from '@microsoft/fast-element';
import { HostController } from '@microsoft/fast-element';
import { HTMLDirective } from '@microsoft/fast-element';
import { Orientation } from '@microsoft/fast-web-utilities';
import type { SyntheticViewTemplate } from '@microsoft/fast-element';
import { ViewTemplate } from '@microsoft/fast-element';

// @public
export const AccordionExpandMode: {
    readonly single: "single";
    readonly multi: "multi";
};

// @public
export type AccordionExpandMode = ValuesOf<typeof AccordionExpandMode>;

// @public
export type AccordionItemOptions = StartEndOptions<FASTAccordionItem> & {
    expandCollapseIcon?: StaticallyComposableHTML<FASTAccordionItem>;
};

// @public
export function accordionItemTemplate<T extends FASTAccordionItem>(options?: AccordionItemOptions): ElementViewTemplate<T>;

// @public
export function accordionTemplate<T extends FASTAccordion>(): ElementViewTemplate<T>;

// @public
export interface AnchoredRegionConfig {
    readonly autoUpdateMode?: AutoUpdateMode;
    readonly fixedPlacement?: boolean;
    readonly horizontalDefaultPosition?: HorizontalPosition;
    readonly horizontalInset?: boolean;
    readonly horizontalPositioningMode?: AxisPositioningMode;
    readonly horizontalScaling?: AxisScalingMode;
    readonly horizontalThreshold?: number;
    readonly horizontalViewportLock?: boolean;
    readonly verticalDefaultPosition?: VerticalPosition;
    readonly verticalInset?: boolean;
    readonly verticalPositioningMode?: AxisPositioningMode;
    readonly verticalScaling?: AxisScalingMode;
    readonly verticalThreshold?: number;
    readonly verticalViewportLock?: boolean;
}

// @public
export const AnchoredRegionPositionLabel: {
    readonly start: "start";
    readonly insetStart: "insetStart";
    readonly insetEnd: "insetEnd";
    readonly end: "end";
    readonly center: "center";
};

// @public
export type AnchoredRegionPositionLabel = ValuesOf<typeof AnchoredRegionPositionLabel>;

// @public
export function anchoredRegionTemplate<T extends FASTAnchoredRegion>(): ElementViewTemplate<T>;

// @public
export type AnchorOptions = StartEndOptions<FASTAnchor>;

// @public
export const AnchorTarget: {
    readonly _self: "_self";
    readonly _blank: "_blank";
    readonly _parent: "_parent";
    readonly _top: "_top";
};

// @public
export type AnchorTarget = ValuesOf<typeof AnchorTarget>;

// @public
export function anchorTemplate<T extends FASTAnchor>(options?: AnchorOptions): ViewTemplate<T>;

// @public
export class ARIAGlobalStatesAndProperties {
    ariaAtomic: "true" | "false" | string | null;
    ariaBusy: "true" | "false" | string | null;
    ariaControls: string | null;
    ariaCurrent: "page" | "step" | "location" | "date" | "time" | "true" | "false" | string | null;
    ariaDescribedby: string | null;
    ariaDetails: string | null;
    ariaDisabled: "true" | "false" | string | null;
    ariaErrormessage: string | null;
    ariaFlowto: string | null;
    ariaHaspopup: "false" | "true" | "menu" | "listbox" | "tree" | "grid" | "dialog" | string | null;
    ariaHidden: "false" | "true" | string | null;
    ariaInvalid: "false" | "true" | "grammar" | "spelling" | string | null;
    ariaKeyshortcuts: string | null;
    ariaLabel: string | null;
    ariaLabelledby: string | null;
    ariaLive: "assertive" | "off" | "polite" | string | null;
    ariaOwns: string | null;
    ariaRelevant: "additions" | "additions text" | "all" | "removals" | "text" | string | null;
    ariaRoledescription: string | null;
}

// @public
export const AutoUpdateMode: {
    readonly anchor: "anchor";
    readonly auto: "auto";
};

// @public
export type AutoUpdateMode = ValuesOf<typeof AutoUpdateMode>;

// @public
export type AvatarOptions = {
    media?: StaticallyComposableHTML<FASTAvatar>;
};

// @public
export function avatarTemplate<T extends FASTAvatar>(options?: AvatarOptions): ElementViewTemplate<T>;

// @public
export const AxisPositioningMode: {
    readonly uncontrolled: "uncontrolled";
    readonly locktodefault: "locktodefault";
    readonly dynamic: "dynamic";
};

// @public
export type AxisPositioningMode = ValuesOf<typeof AxisPositioningMode>;

// @public
export const AxisScalingMode: {
    readonly anchor: "anchor";
    readonly content: "content";
    readonly fill: "fill";
};

// @public
export type AxisScalingMode = ValuesOf<typeof AxisScalingMode>;

// @public
export type BadgeOptions = StartEndOptions;

// @public
export function badgeTemplate<T extends FASTBadge>(options?: BadgeOptions): ElementViewTemplate<T>;

// @public
export type BreadcrumbItemOptions = StartEndOptions<FASTBreadcrumbItem> & {
    separator?: StaticallyComposableHTML<FASTBreadcrumbItem>;
};

// @public
export function breadcrumbItemTemplate<T extends FASTBreadcrumbItem>(options?: BreadcrumbItemOptions): ElementViewTemplate<T>;

// @public
export type BreadcrumbOptions = StartEndOptions;

// @public
export function breadcrumbTemplate<T extends FASTBreadcrumb>(options?: BreadcrumbOptions): ElementViewTemplate<T>;

// @public
export type ButtonOptions = StartEndOptions<FASTButton>;

// @public
export function buttonTemplate<T extends FASTButton>(options?: ButtonOptions): ElementViewTemplate<T>;

// @public
export const ButtonType: {
    readonly submit: "submit";
    readonly reset: "reset";
    readonly button: "button";
};

// @public
export type ButtonType = ValuesOf<typeof ButtonType>;

// @public
export function calendarCellTemplate(options: CalendarOptions, todayString: string): ViewTemplate<CalendarDateInfo>;

// @public
export type CalendarDateInfo = {
    day: number;
    month: number;
    year: number;
    disabled?: boolean;
    selected?: boolean;
};

// @public
export type CalendarInfo = MonthInfo & {
    previous: MonthInfo;
    next: MonthInfo;
};

// @public
export type CalendarOptions = StartEndOptions<FASTCalendar> & {
    dataGridCell: TemplateElementDependency;
    dataGridRow: TemplateElementDependency;
    dataGrid: TemplateElementDependency;
    title?: StaticallyComposableHTML<FASTCalendar>;
};

// @public (undocumented)
export function calendarRowTemplate(options: CalendarOptions, todayString: string): ViewTemplate;

// @public
export function calendarTemplate<T extends FASTCalendar>(options: CalendarOptions): ElementViewTemplate<T>;

// @public
export function calendarTitleTemplate<T extends FASTCalendar>(): ViewTemplate<T>;

// @public
export function calendarWeekdayTemplate(options: CalendarOptions): ViewTemplate<WeekdayText>;

// @public
export function cardTemplate<T extends FASTCard>(): ElementViewTemplate<T>;

// @public
export type CellItemTemplateOptions = {
    dataGridCell: TemplateElementDependency;
};

// @beta
export function CheckableFormAssociated<T extends ConstructableFormAssociated>(BaseCtor: T): T;

// @beta
export interface CheckableFormAssociated extends FormAssociated {
    // (undocumented)
    checked: boolean;
    // (undocumented)
    checkedAttribute: boolean;
    // (undocumented)
    checkedChanged(oldValue: boolean | undefined, newValue: boolean): void;
    // (undocumented)
    currentChecked: boolean;
    // (undocumented)
    defaultChecked: boolean;
    // (undocumented)
    defaultCheckedChanged(oldValue: boolean | undefined, newValue: boolean): void;
    // (undocumented)
    dirtyChecked: boolean;
}

// @beta
export type CheckableFormAssociatedElement = FormAssociatedElement & CheckableFormAssociated & {
    proxy: HTMLInputElement;
};

// @public
export type CheckboxOptions = {
    checkedIndicator?: StaticallyComposableHTML<FASTCheckbox>;
    indeterminateIndicator?: StaticallyComposableHTML<FASTCheckbox>;
};

// @public
export function checkboxTemplate<T extends FASTCheckbox>(options?: CheckboxOptions): ElementViewTemplate<T>;

// @public
export interface ColumnDefinition {
    cellFocusTargetCallback?: (cell: FASTDataGridCell) => HTMLElement | null;
    cellInternalFocusQueue?: boolean;
    cellTemplate?: ViewTemplate | SyntheticViewTemplate;
    columnDataKey: string;
    gridColumn?: string;
    headerCellFocusTargetCallback?: (cell: FASTDataGridCell) => HTMLElement | null;
    headerCellInternalFocusQueue?: boolean;
    headerCellTemplate?: ViewTemplate | SyntheticViewTemplate;
    isRowHeader?: boolean;
    title?: string;
}

// @public
export const ComboboxAutocomplete: {
    readonly inline: "inline";
    readonly list: "list";
    readonly both: "both";
    readonly none: "none";
};

// @public
export type ComboboxAutocomplete = ValuesOf<typeof ComboboxAutocomplete>;

// @public
export type ComboboxOptions = StartEndOptions<FASTCombobox> & {
    indicator?: StaticallyComposableHTML<FASTCombobox>;
};

// @public
export function comboboxTemplate<T extends FASTCombobox>(options?: ComboboxOptions): ElementViewTemplate<T>;

// @beta
export type ConstructableFormAssociated = Constructable<HTMLElement & FASTElement>;

// @public (undocumented)
export class CSSDesignToken<T> extends DesignToken<T> implements CSSDirective, HTMLDirective {
    constructor(configuration: CSSDesignTokenConfiguration);
    createCSS(): string;
    createHTML(): string;
    readonly cssCustomProperty: string;
}

// @public (undocumented)
export interface CSSDesignTokenConfiguration extends DesignTokenConfiguration {
    cssCustomPropertyName: string;
}

// @public
export type CSSDisplayPropertyValue = "block" | "contents" | "flex" | "grid" | "inherit" | "initial" | "inline" | "inline-block" | "inline-flex" | "inline-grid" | "inline-table" | "list-item" | "none" | "run-in" | "table" | "table-caption" | "table-cell" | "table-column" | "table-column-group" | "table-footer-group" | "table-header-group" | "table-row" | "table-row-group";

// @public
export const darkModeStylesheetBehavior: (styles: ElementStyles) => MatchMediaStyleSheetBehavior;

// @public
export function dataGridCellTemplate<T extends FASTDataGridCell>(): ElementViewTemplate<T>;

// @public
export const DataGridCellTypes: {
    readonly default: "default";
    readonly columnHeader: "columnheader";
    readonly rowHeader: "rowheader";
};

// @public
export type DataGridCellTypes = ValuesOf<typeof DataGridCellTypes>;

// @public
export type DataGridOptions = {
    dataGridRow: TemplateElementDependency;
};

// @public
export function dataGridRowTemplate<T extends FASTDataGridRow>(options: CellItemTemplateOptions): ElementViewTemplate<T>;

// @public
export const DataGridRowTypes: {
    readonly default: "default";
    readonly header: "header";
    readonly stickyHeader: "sticky-header";
};

// @public
export type DataGridRowTypes = ValuesOf<typeof DataGridRowTypes>;

// @public
export const DataGridSelectionBehavior: {
    readonly programmatic: "programmatic";
    readonly keyboardOnly: "keyboard-only";
    readonly auto: "auto";
};

// @public
export type DataGridSelectionBehavior = ValuesOf<typeof DataGridSelectionBehavior>;

// @public
export const DataGridSelectionMode: {
    readonly none: "none";
    readonly singleRow: "single-row";
    readonly multiRow: "multi-row";
};

// @public
export type DataGridSelectionMode = ValuesOf<typeof DataGridSelectionMode>;

// @public
export function dataGridTemplate<T extends FASTDataGrid>(options: DataGridOptions): ElementViewTemplate<T>;

// @public
export class DateFormatter {
    constructor(config?: {});
    date: Date;
    dayFormat: DayFormat;
    // (undocumented)
    getDate(date?: {
        day: number;
        month: number;
        year: number;
    } | string | Date, format?: Intl.DateTimeFormatOptions, locale?: string): string;
    getDateObject(date: {
        day: number;
        month: number;
        year: number;
    } | string | Date): Date;
    // (undocumented)
    getDay(day?: number, format?: DayFormat, locale?: string): string;
    // (undocumented)
    getMonth(month?: number, format?: MonthFormat, locale?: string): string;
    // (undocumented)
    getWeekday(weekday?: number, format?: WeekdayFormat, locale?: string): string;
    // (undocumented)
    getWeekdays(format?: WeekdayFormat, locale?: string): string[];
    // (undocumented)
    getYear(year?: number, format?: YearFormat, locale?: string): string;
    locale: string;
    monthFormat: MonthFormat;
    weekdayFormat: WeekdayFormat;
    yearFormat: YearFormat;
}

// @public
export const DayFormat: {
    readonly "2-digit": "2-digit";
    readonly numeric: "numeric";
};

// @public
export type DayFormat = ValuesOf<typeof DayFormat>;

// @public (undocumented)
export const defaultCellFocusTargetCallback: (cell: FASTDataGridCell) => HTMLElement | null;

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "DelegatesARIAButton" because one of its declarations is marked as @internal
//
// @public
export class DelegatesARIAButton {
    ariaExpanded: "true" | "false" | string | null;
    ariaPressed: "true" | "false" | "mixed" | string | null;
}

// @internal
export interface DelegatesARIAButton extends ARIAGlobalStatesAndProperties {
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "DelegatesARIACombobox" because one of its declarations is marked as @internal
//
// @public
export class DelegatesARIACombobox {
    ariaAutoComplete: "inline" | "list" | "both" | "none" | string | null;
    ariaControls: string | null;
}

// @internal
export interface DelegatesARIACombobox extends DelegatesARIAListbox {
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "DelegatesARIALink" because one of its declarations is marked as @internal
//
// @public
export class DelegatesARIALink {
    ariaExpanded: "true" | "false" | string | null;
}

// @internal
export interface DelegatesARIALink extends ARIAGlobalStatesAndProperties {
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "DelegatesARIAListbox" because one of its declarations is marked as @internal
//
// @public
export class DelegatesARIAListbox {
    ariaActiveDescendant: string | null;
    ariaDisabled: "true" | "false" | string | null;
    ariaExpanded: "true" | "false" | string | null;
    ariaMultiSelectable: "true" | "false" | string | null;
}

// @internal
export interface DelegatesARIAListbox extends ARIAGlobalStatesAndProperties {
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "DelegatesARIAListboxOption" because one of its declarations is marked as @internal
//
// @public
export class DelegatesARIAListboxOption {
    ariaChecked: "true" | "false" | string | null;
    ariaPosInSet: string | null;
    ariaSelected: "true" | "false" | string | null;
    ariaSetSize: string | null;
}

// @internal (undocumented)
export interface DelegatesARIAListboxOption extends ARIAGlobalStatesAndProperties {
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "DelegatesARIASearch" because one of its declarations is marked as @internal
//
// @public
export class DelegatesARIASearch {
}

// @internal
export interface DelegatesARIASearch extends ARIAGlobalStatesAndProperties {
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "DelegatesARIASelect" because one of its declarations is marked as @internal
//
// @public
export class DelegatesARIASelect {
    ariaControls: string | null;
}

// @internal
export interface DelegatesARIASelect extends DelegatesARIAListbox {
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "DelegatesARIATextbox" because one of its declarations is marked as @internal
//
// @public
export class DelegatesARIATextbox {
}

// @internal
export interface DelegatesARIATextbox extends ARIAGlobalStatesAndProperties {
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "DelegatesARIAToolbar" because one of its declarations is marked as @internal
//
// @public
export class DelegatesARIAToolbar {
    ariaLabel: string | null;
    ariaLabelledby: string | null;
}

// @internal
export interface DelegatesARIAToolbar extends ARIAGlobalStatesAndProperties {
}

// @public
export type DerivedDesignTokenValue<T> = (resolve: DesignTokenResolver) => T;

// @public (undocumented)
export class DesignToken<T> {
    get $value(): T | undefined;
    constructor(configuration: DesignTokenConfiguration);
    // (undocumented)
    static create<T>(name: string): CSSDesignToken<T>;
    // (undocumented)
    static create<T>(config: DesignTokenConfiguration): DesignToken<T>;
    // (undocumented)
    static create<T>(config: CSSDesignTokenConfiguration): CSSDesignToken<T>;
    get default(): T | undefined;
    deleteValueFor(target: FASTElement): this;
    getValueFor(target: FASTElement): T;
    name: string;
    static registerDefaultStyleTarget(target?: FASTElement | Document | PropertyTarget): void;
    // Warning: (ae-forgotten-export) The symbol "DesignTokenValue" needs to be exported by the entry point index.d.ts
    setValueFor(target: FASTElement, value: DesignToken<T> | DesignTokenValue<T>): void;
    subscribe(subscriber: DesignTokenSubscriber<this>): void;
    static unregisterDefaultStyleTarget(target?: FASTElement | Document | PropertyTarget): void;
    unsubscribe(subscriber: DesignTokenSubscriber<this>): void;
    withDefault(value: DesignToken<T> | DesignTokenValue<T>): this;
    // Warning: (ae-forgotten-export) The symbol "DesignTokenResolutionStrategy" needs to be exported by the entry point index.d.ts
    static withStrategy(strategy: DesignTokenResolutionStrategy): void;
}

// @public (undocumented)
export interface DesignTokenChangeRecord<T extends DesignToken<any>> {
    target: FASTElement | "default";
    token: T;
}

// @public
export interface DesignTokenConfiguration {
    name: string;
}

// @public
export const DesignTokenEventResolutionStrategy: DesignTokenResolutionStrategy;

// @public (undocumented)
export const enum DesignTokenMutationType {
    // (undocumented)
    add = 0,
    // (undocumented)
    change = 1,
    // (undocumented)
    delete = 2
}

// Warning: (ae-forgotten-export) The symbol "DesignToken" needs to be exported by the entry point index.d.ts
//
// @public
export type DesignTokenResolver = <T>(token: DesignToken_2<T>) => T;

// @public
export class DesignTokenStyleTarget implements PropertyTarget {
    get cssText(): string;
    // (undocumented)
    removeProperty(name: string): void;
    // (undocumented)
    setProperty(name: string, value: string): void;
    get values(): Array<[string, string]>;
}

// @public
export interface DesignTokenSubscriber<T extends DesignToken<any>> {
    // (undocumented)
    handleChange(token: T, record: DesignTokenChangeRecord<T>): void;
}

// @public
export function dialogTemplate<T extends FASTDialog>(): ElementViewTemplate<T>;

// Warning: (ae-internal-missing-underscore) The name "Dimension" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal (undocumented)
export interface Dimension {
    // (undocumented)
    height: number;
    // (undocumented)
    width: number;
}

// @public @deprecated
export const disabledCursor = "not-allowed";

// @public
export type DisclosureOptions = StartEndOptions<FASTDisclosure>;

// @public
export function disclosureTemplate<T extends FASTDisclosure>(options?: DisclosureOptions): ElementViewTemplate<T>;

// @public
export function display(displayValue: CSSDisplayPropertyValue): string;

// @public
export const DividerOrientation: {
    readonly horizontal: "horizontal";
    readonly vertical: "vertical";
};

// @public
export type DividerOrientation = ValuesOf<typeof DividerOrientation>;

// @public
export const DividerRole: {
    readonly separator: "separator";
    readonly presentation: "presentation";
};

// @public
export type DividerRole = ValuesOf<typeof DividerRole>;

// @public
export function dividerTemplate<T extends FASTDivider>(): ElementViewTemplate<T>;

// @public
export type EndOptions<TSource = any, TParent = any> = {
    end?: StaticallyComposableHTML<TSource, TParent>;
};

// @public
export function endSlotTemplate<TSource extends StartEnd = StartEnd, TParent = any>(options: EndOptions<TSource, TParent>): CaptureType<TSource, TParent>;

// @public
export class FASTAccordion extends FASTElement {
    // (undocumented)
    protected accordionItems: Element[];
    expandmode: AccordionExpandMode;
    // (undocumented)
    expandmodeChanged(prev: AccordionExpandMode, next: AccordionExpandMode): void;
    // @internal (undocumented)
    handleChange(source: any, propertyName: string): void;
    // @internal (undocumented)
    slottedAccordionItems: HTMLElement[];
    // @internal (undocumented)
    slottedAccordionItemsChanged(oldValue: HTMLElement[], newValue: HTMLElement[]): void;
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "FASTAccordionItem" because one of its declarations is marked as @internal
//
// @public
export class FASTAccordionItem extends FASTElement {
    // @internal (undocumented)
    clickHandler: (e: MouseEvent) => void;
    disabled: boolean;
    // @internal (undocumented)
    expandbutton: HTMLElement;
    expanded: boolean;
    headinglevel: 1 | 2 | 3 | 4 | 5 | 6;
    id: string;
}

// @internal
export interface FASTAccordionItem extends StartEnd {
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "FASTAnchor" because one of its declarations is marked as @internal
//
// @public
export class FASTAnchor extends FASTElement {
    control: HTMLAnchorElement;
    // @internal
    defaultSlottedContent: HTMLElement[];
    download: string;
    href: string;
    hreflang: string;
    ping: string;
    referrerpolicy: string;
    rel: string;
    target: AnchorTarget;
    type: string;
}

// @internal
export interface FASTAnchor extends StartEnd, DelegatesARIALink {
}

// @public
export class FASTAnchoredRegion extends FASTElement {
    // @internal (undocumented)
    adoptedCallback(): void;
    anchor: string;
    // (undocumented)
    protected anchorChanged(): void;
    anchorElement: HTMLElement | null;
    // (undocumented)
    protected anchorElementChanged(): void;
    autoUpdateMode: AutoUpdateMode;
    // (undocumented)
    protected autoUpdateModeChanged(prevMode: AutoUpdateMode, newMode: AutoUpdateMode): void;
    // @internal (undocumented)
    connectedCallback(): void;
    // @internal (undocumented)
    disconnectedCallback(): void;
    fixedPlacement: boolean;
    // (undocumented)
    protected fixedPlacementChanged(): void;
    horizontalDefaultPosition: HorizontalPosition;
    // (undocumented)
    protected horizontalDefaultPositionChanged(): void;
    horizontalInset: boolean;
    // (undocumented)
    protected horizontalInsetChanged(): void;
    horizontalPosition: AnchoredRegionPositionLabel | undefined;
    horizontalPositioningMode: AxisPositioningMode;
    // (undocumented)
    protected horizontalPositioningModeChanged(): void;
    horizontalScaling: AxisScalingMode;
    // (undocumented)
    protected horizontalScalingChanged(): void;
    horizontalThreshold: number;
    // (undocumented)
    protected horizontalThresholdChanged(): void;
    horizontalViewportLock: boolean;
    // (undocumented)
    protected horizontalViewportLockChanged(): void;
    // @internal
    initialLayoutComplete: boolean;
    update: () => void;
    verticalDefaultPosition: VerticalPosition;
    // (undocumented)
    protected verticalDefaultPositionChanged(): void;
    verticalInset: boolean;
    // (undocumented)
    protected verticalInsetChanged(): void;
    verticalPosition: AnchoredRegionPositionLabel | undefined;
    verticalPositioningMode: AxisPositioningMode;
    // (undocumented)
    protected verticalPositioningModeChanged(): void;
    verticalScaling: AxisScalingMode;
    // (undocumented)
    protected verticalScalingChanged(): void;
    verticalThreshold: number;
    // (undocumented)
    protected verticalThresholdChanged(): void;
    verticalViewportLock: boolean;
    // (undocumented)
    protected verticalViewportLockChanged(): void;
    viewport: string;
    // (undocumented)
    protected viewportChanged(): void;
    viewportElement: HTMLElement | null;
    // (undocumented)
    protected viewportElementChanged(): void;
}

// @public
export class FASTAvatar extends FASTElement {
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "FASTBadge" because one of its declarations is marked as @internal
//
// @public
export class FASTBadge extends FASTElement {
}

// @internal
export interface FASTBadge extends StartEnd {
}

// @public
export class FASTBaseProgress extends FASTElement {
    // @internal (undocumented)
    connectedCallback(): void;
    max: number;
    // (undocumented)
    protected maxChanged(): void;
    min: number;
    // (undocumented)
    protected minChanged(): void;
    // @internal
    percentComplete: number;
    value: number | null;
    // (undocumented)
    protected valueChanged(): void;
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "FASTBreadcrumb" because one of its declarations is marked as @internal
//
// @public
export class FASTBreadcrumb extends FASTElement {
    // @internal (undocumented)
    slottedBreadcrumbItems: HTMLElement[];
    // (undocumented)
    protected slottedBreadcrumbItemsChanged(): void;
}

// @internal
export interface FASTBreadcrumb extends StartEnd {
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "FASTBreadcrumbItem" because one of its declarations is marked as @internal
//
// @public
export class FASTBreadcrumbItem extends FASTAnchor {
    // @internal (undocumented)
    separator: boolean;
}

// @internal
export interface FASTBreadcrumbItem extends StartEnd, DelegatesARIALink {
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-forgotten-export) The symbol "FormAssociatedButton" needs to be exported by the entry point index.d.ts
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "FASTButton" because one of its declarations is marked as @internal
//
// @public
export class FASTButton extends FormAssociatedButton {
    autofocus: boolean;
    // @internal (undocumented)
    connectedCallback(): void;
    // (undocumented)
    control: HTMLButtonElement;
    defaultSlottedContent: HTMLElement[];
    formaction: string;
    // (undocumented)
    protected formactionChanged(): void;
    formenctype: string;
    // (undocumented)
    protected formenctypeChanged(): void;
    formId: string;
    formmethod: string;
    // (undocumented)
    protected formmethodChanged(): void;
    formnovalidate: boolean;
    // (undocumented)
    protected formnovalidateChanged(): void;
    formtarget: "_self" | "_blank" | "_parent" | "_top";
    // (undocumented)
    protected formtargetChanged(): void;
    type: ButtonType;
    // (undocumented)
    protected typeChanged(previous: ButtonType | undefined, next: ButtonType): void;
    validate(): void;
}

// @internal
export interface FASTButton extends StartEnd, DelegatesARIAButton {
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "FASTCalendar" because one of its declarations is marked as @internal
//
// @public
export class FASTCalendar extends FASTElement {
    dateFormatter: DateFormatter;
    dateInString(date: Date | string, datesString: string): boolean;
    dayFormat: DayFormat;
    // (undocumented)
    protected dayFormatChanged(): void;
    disabledDates: string;
    firstDay: number;
    getDayClassNames(date: CalendarDateInfo, todayString?: string): string;
    getDays(info?: CalendarInfo, minWeeks?: number): CalendarDateInfo[][];
    getMonthInfo(month?: number, year?: number): CalendarInfo;
    getWeekdayText(): WeekdayText[];
    handleDateSelect(event: Event, day: CalendarDateInfo): void;
    handleKeydown(event: KeyboardEvent, date: CalendarDateInfo): boolean;
    locale: string;
    // (undocumented)
    protected localeChanged(): void;
    minWeeks: number;
    month: number;
    monthFormat: MonthFormat;
    // (undocumented)
    protected monthFormatChanged(): void;
    readonly: boolean;
    selectedDates: string;
    weekdayFormat: WeekdayFormat;
    // (undocumented)
    protected weekdayFormatChanged(): void;
    year: number;
    yearFormat: YearFormat;
    // (undocumented)
    protected yearFormatChanged(): void;
}

// @internal
export interface FASTCalendar extends StartEnd {
}

// @public
export class FASTCard extends FASTElement {
}

// Warning: (ae-forgotten-export) The symbol "FormAssociatedCheckbox" needs to be exported by the entry point index.d.ts
//
// @public
export class FASTCheckbox extends FormAssociatedCheckbox {
    constructor();
    // @internal (undocumented)
    clickHandler: (e: MouseEvent) => void;
    // @internal (undocumented)
    defaultSlottedNodes: Node[];
    indeterminate: boolean;
    // @internal
    initialValue: string;
    // @internal (undocumented)
    keypressHandler: (e: KeyboardEvent) => void;
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-forgotten-export) The symbol "FormAssociatedCombobox" needs to be exported by the entry point index.d.ts
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "FASTCombobox" because one of its declarations is marked as @internal
//
// @public
export class FASTCombobox extends FormAssociatedCombobox {
    autocomplete: ComboboxAutocomplete | undefined;
    cleanup: () => void;
    // @internal
    clickHandler(e: MouseEvent): boolean | void;
    // (undocumented)
    connectedCallback(): void;
    // @internal
    control: HTMLInputElement;
    // @internal
    disabledChanged(prev: boolean, next: boolean): void;
    // (undocumented)
    disconnectedCallback(): void;
    filteredOptions: FASTListboxOption[];
    filterOptions(): void;
    // @internal
    protected focusAndScrollOptionIntoView(): void;
    // @internal
    focusoutHandler(e: FocusEvent): boolean | void;
    // @internal
    formResetCallback(): void;
    // @internal
    inputHandler(e: InputEvent): boolean | void;
    // @internal
    keydownHandler(e: Event & KeyboardEvent): boolean | void;
    // @internal
    keyupHandler(e: KeyboardEvent): boolean | void;
    // @internal
    listbox: HTMLDivElement;
    // @internal
    listboxId: string;
    open: boolean;
    // @internal
    protected openChanged(): void;
    get options(): FASTListboxOption[];
    set options(value: FASTListboxOption[]);
    placeholder: string;
    // @internal
    protected placeholderChanged(): void;
    // @internal
    selectedIndexChanged(prev: number | undefined, next: number): void;
    // @internal
    selectedOptionsChanged(prev: FASTListboxOption[] | undefined, next: FASTListboxOption[]): void;
    // @internal
    selectPreviousOption(): void;
    // @internal
    setDefaultSelectedOption(): void;
    setPositioning(): void;
    // @internal
    slottedOptionsChanged(prev: Element[] | undefined, next: Element[]): void;
    validate(): void;
    get value(): string;
    set value(next: string);
}

// @internal
export interface FASTCombobox extends StartEnd, DelegatesARIACombobox {
}

// @public
export class FASTDataGrid extends FASTElement {
    cellItemTemplate?: ViewTemplate;
    columnDefinitions: ColumnDefinition[] | null;
    // (undocumented)
    protected columnDefinitionsChanged(): void;
    // @internal (undocumented)
    connectedCallback(): void;
    // @internal
    defaultRowItemTemplate: ViewTemplate;
    // @internal (undocumented)
    disconnectedCallback(): void;
    focusColumnIndex: number;
    focusRowIndex: number;
    static generateColumns(row: object): ColumnDefinition[];
    generateHeader: GenerateHeaderOptions;
    gridTemplateColumns: string;
    // (undocumented)
    protected gridTemplateColumnsChanged(): void;
    // @internal (undocumented)
    handleFocus(e: FocusEvent): void;
    // @internal (undocumented)
    handleFocusOut(e: FocusEvent): void;
    // @internal (undocumented)
    handleKeydown(e: KeyboardEvent): void;
    // @internal (undocumented)
    handleRowFocus(e: Event): void;
    // (undocumented)
    handleRowSelectedChange(e: CustomEvent): void;
    headerCellItemTemplate?: ViewTemplate;
    initialRowSelection: string;
    noTabbing: boolean;
    // (undocumented)
    protected noTabbingChanged(): void;
    pageSize: number | undefined;
    // @internal
    rowElements: HTMLElement[];
    rowElementTag: string;
    rowItemTemplate: ViewTemplate;
    rowsData: object[];
    // (undocumented)
    protected rowsDataChanged(): void;
    rowSelectableCallback: (rowIndex: number, grid: FASTDataGrid) => boolean;
    get selectedRowIndexes(): number[];
    set selectedRowIndexes(next: number[]);
    selectionBehavior: DataGridSelectionBehavior;
    selectionMode: DataGridSelectionMode;
}

// @public
export class FASTDataGridCell extends FASTElement {
    cellType: DataGridCellTypes;
    columnDefinition: ColumnDefinition | null;
    // (undocumented)
    protected columnDefinitionChanged(oldValue: ColumnDefinition | null, newValue: ColumnDefinition | null): void;
    // @internal (undocumented)
    connectedCallback(): void;
    // @internal (undocumented)
    disconnectedCallback(): void;
    gridColumn: string;
    // (undocumented)
    protected gridColumnChanged(): void;
    // (undocumented)
    handleFocusin(e: FocusEvent): void;
    // (undocumented)
    handleFocusout(e: FocusEvent): void;
    // (undocumented)
    handleKeydown(e: KeyboardEvent): void;
    rowData: object | null;
}

// @public
export class FASTDataGridRow extends FASTElement {
    // @internal
    activeCellItemTemplate?: ViewTemplate;
    // @internal
    cellElements: HTMLElement[];
    cellItemTemplate?: ViewTemplate;
    columnDefinitions: ColumnDefinition[] | null;
    // @internal (undocumented)
    connectedCallback(): void;
    // @internal
    defaultCellItemTemplate?: ViewTemplate;
    // @internal
    defaultHeaderCellItemTemplate?: ViewTemplate;
    // @internal (undocumented)
    disconnectedCallback(): void;
    // @internal (undocumented)
    focusColumnIndex: number;
    gridTemplateColumns: string;
    // (undocumented)
    protected gridTemplateColumnsChanged(): void;
    // @internal (undocumented)
    handleCellFocus(e: Event): void;
    // @internal (undocumented)
    handleClick(e: MouseEvent): void;
    // (undocumented)
    handleFocusout(e: FocusEvent): void;
    // @internal (undocumented)
    handleKeydown(e: KeyboardEvent): void;
    headerCellItemTemplate?: ViewTemplate;
    // @internal
    isActiveRow: boolean;
    rowData: object | null;
    // (undocumented)
    protected rowDataChanged(): void;
    rowIndex: number;
    rowType: DataGridRowTypes;
    // @internal
    selected: boolean;
    // @internal
    selectionBehavior: DataGridSelectionBehavior;
    // @internal (undocumented)
    slottedCellElements: HTMLElement[];
    // Warning: (ae-forgotten-export) The symbol "DataGridSelectionChangeDetail" needs to be exported by the entry point index.d.ts
    toggleSelected(detail: DataGridSelectionChangeDetail): void;
}

// @public
export class FASTDialog extends FASTElement {
    ariaDescribedby: string;
    ariaLabel: string;
    ariaLabelledby: string;
    // @internal (undocumented)
    connectedCallback(): void;
    // @internal (undocumented)
    dialog: HTMLDivElement;
    // @internal (undocumented)
    disconnectedCallback(): void;
    // @internal (undocumented)
    dismiss(): void;
    // @internal (undocumented)
    handleChange(source: any, propertyName: string): void;
    hidden: boolean;
    hide(): void;
    modal: boolean;
    noFocusTrap: boolean;
    show(): void;
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "FASTDisclosure" because one of its declarations is marked as @internal
//
// @public
export class FASTDisclosure extends FASTElement {
    // @internal (undocumented)
    connectedCallback(): void;
    // @internal (undocumented)
    details: HTMLDetailsElement;
    // @internal (undocumented)
    disconnectedCallback(): void;
    expanded: boolean;
    hide(): void;
    protected onToggle(): void;
    protected setup(): void;
    show(): void;
    summary: string;
    toggle(): void;
}

// @internal
export interface FASTDisclosure extends StartEnd {
}

// @public
export class FASTDivider extends FASTElement {
    orientation: DividerOrientation;
    role: DividerRole;
}

// @public
export class FASTFlipper extends FASTElement {
    direction: FlipperDirection;
    disabled: boolean;
    hiddenFromAT: boolean;
    keyupHandler(e: Event & KeyboardEvent): void;
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "FASTHorizontalScroll" because one of its declarations is marked as @internal
//
// @public
export class FASTHorizontalScroll extends FASTElement {
    // (undocumented)
    connectedCallback(): void;
    content: HTMLDivElement;
    // (undocumented)
    disconnectedCallback(): void;
    duration: string;
    easing: ScrollEasing | string;
    flippersHiddenFromAT: boolean;
    keyupHandler(e: Event & KeyboardEvent): void;
    nextFlipperContainer: HTMLDivElement;
    previousFlipperContainer: HTMLDivElement;
    resized(): void;
    scrollContainer: HTMLDivElement;
    scrolled(): void;
    // @internal
    scrollingChanged(prev: unknown, next: boolean): void;
    scrollInView(item: HTMLElement | number, padding?: number, rightPadding?: number): void;
    scrollItems: HTMLElement[];
    scrollItemsChanged(previous: HTMLElement[], next: HTMLElement[]): void;
    scrollToNext(): void;
    scrollToPosition(newPosition: number, position?: number): void;
    scrollToPrevious(): void;
    speed: number;
    view: HorizontalScrollView;
}

// @internal
export interface FASTHorizontalScroll extends StartEnd {
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "FASTListbox" because one of its declarations is marked as @internal
//
// @public
export abstract class FASTListbox extends FASTElement {
    // @internal
    clickHandler(e: MouseEvent): boolean | void;
    disabled: boolean;
    // @internal
    get firstSelectedOption(): FASTListboxOption;
    // @internal
    protected focusAndScrollOptionIntoView(optionToFocus?: FASTListboxOption | null): void;
    // @internal
    focusinHandler(e: FocusEvent): void;
    // @internal
    protected getSelectableIndex(prev: number | undefined, next: number): number;
    // @internal
    protected getTypeaheadMatches(): FASTListboxOption[];
    // @internal
    handleChange(source: any, propertyName: string): void;
    // @internal
    handleTypeAhead(key: string): void;
    // @internal
    protected get hasSelectableOptions(): boolean;
    // @internal
    keydownHandler(e: KeyboardEvent): boolean | void;
    get length(): number;
    // @internal
    mousedownHandler(e: MouseEvent): boolean | void;
    // @internal
    multipleChanged(prev: boolean | undefined, next: boolean): void;
    get options(): FASTListboxOption[];
    set options(value: FASTListboxOption[]);
    // @internal
    protected _options: FASTListboxOption[];
    selectedIndex: number;
    // @internal
    selectedIndexChanged(prev: number | undefined, next: number): void;
    selectedOptions: FASTListboxOption[];
    // @internal
    protected selectedOptionsChanged(prev: FASTListboxOption[] | undefined, next: FASTListboxOption[]): void;
    selectFirstOption(): void;
    // @internal
    selectLastOption(): void;
    // @internal
    selectNextOption(): void;
    // @internal
    selectPreviousOption(): void;
    // @internal
    protected setDefaultSelectedOption(): void;
    protected setSelectedOptions(): void;
    // @internal
    protected shouldSkipFocus: boolean;
    static slottedOptionFilter(n: HTMLElement): boolean;
    // @internal
    slottedOptions: Element[];
    // @internal
    slottedOptionsChanged(prev: Element[] | undefined, next: Element[]): void;
    // @internal
    protected static readonly TYPE_AHEAD_TIMEOUT_MS = 1000;
    // @internal
    protected typeaheadBuffer: string;
    // @internal
    typeaheadBufferChanged(prev: string, next: string): void;
    // @internal @deprecated
    protected get typeAheadExpired(): boolean;
    protected set typeAheadExpired(value: boolean);
    // @internal
    protected typeaheadExpired: boolean;
    // @internal
    protected typeaheadTimeout: number;
}

// @internal (undocumented)
export interface FASTListbox extends DelegatesARIAListbox {
}

// @public
export class FASTListboxElement extends FASTListbox {
    // @internal
    protected activeIndex: number;
    // @internal
    protected activeIndexChanged(prev: number | undefined, next: number): void;
    // @internal
    get activeOption(): FASTListboxOption | null;
    // @internal
    protected checkActiveIndex(): void;
    // @internal
    protected get checkedOptions(): FASTListboxOption[];
    // @internal
    protected checkFirstOption(preserveChecked?: boolean): void;
    // @internal
    protected checkLastOption(preserveChecked?: boolean): void;
    // @internal
    protected checkNextOption(preserveChecked?: boolean): void;
    // @internal
    protected checkPreviousOption(preserveChecked?: boolean): void;
    // @internal @override
    clickHandler(e: MouseEvent): boolean | void;
    // @internal @override (undocumented)
    connectedCallback(): void;
    // @internal @override (undocumented)
    disconnectedCallback(): void;
    // @internal
    get firstSelectedOptionIndex(): number;
    // @internal @override (undocumented)
    protected focusAndScrollOptionIntoView(): void;
    // @internal @override
    focusinHandler(e: FocusEvent): boolean | void;
    // @internal
    focusoutHandler(e: FocusEvent): void;
    // @internal @override
    keydownHandler(e: KeyboardEvent): boolean | void;
    // @internal @override
    mousedownHandler(e: MouseEvent): boolean | void;
    multiple: boolean;
    // @internal
    multipleChanged(prev: boolean | undefined, next: boolean): void;
    // @internal
    protected rangeStartIndex: number;
    // @override
    protected setSelectedOptions(): void;
    size: number;
    // @internal
    protected sizeChanged(prev: number | unknown, next: number): void;
    // @internal
    toggleSelectedForAllCheckedOptions(): void;
    // @internal @override (undocumented)
    typeaheadBufferChanged(prev: string, next: string): void;
    // @internal
    protected uncheckAllOptions(preserveChecked?: boolean): void;
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "FASTListboxOption" because one of its declarations is marked as @internal
//
// @public
export class FASTListboxOption extends FASTElement {
    constructor(text?: string, value?: string, defaultSelected?: boolean, selected?: boolean);
    checked?: boolean;
    protected checkedChanged(prev: boolean | unknown, next?: boolean): void;
    content: Node[];
    // @internal
    protected contentChanged(prev: undefined | Node[], next: Node[]): void;
    defaultSelected: boolean;
    // (undocumented)
    protected defaultSelectedChanged(): void;
    dirtyValue: boolean;
    disabled: boolean;
    // (undocumented)
    protected disabledChanged(prev: boolean, next: boolean): void;
    // (undocumented)
    get form(): HTMLFormElement | null;
    protected initialValue: string;
    // (undocumented)
    initialValueChanged(previous: string, next: string): void;
    // (undocumented)
    get label(): string;
    // @internal (undocumented)
    proxy: HTMLOptionElement;
    selected: boolean;
    selectedAttribute: boolean;
    // (undocumented)
    protected selectedAttributeChanged(): void;
    // (undocumented)
    protected selectedChanged(): void;
    // (undocumented)
    get text(): string;
    set value(next: string);
    // (undocumented)
    get value(): string;
}

// @internal (undocumented)
export interface FASTListboxOption extends StartEnd, DelegatesARIAListboxOption {
}

// @public
export class FASTMenu extends FASTElement {
    collapseExpandedItem(): void;
    // @internal (undocumented)
    connectedCallback(): void;
    // @internal (undocumented)
    disconnectedCallback(): void;
    focus(): void;
    // (undocumented)
    handleChange(source: any, propertyName: string): void;
    // @internal
    handleFocusOut: (e: FocusEvent) => void;
    // @internal (undocumented)
    handleMenuKeyDown(e: KeyboardEvent): void | boolean;
    protected isMenuItemElement: (el: Element) => el is HTMLElement;
    // @internal (undocumented)
    readonly isNestedMenu: () => boolean;
    // @internal (undocumented)
    items: HTMLElement[];
    // (undocumented)
    protected itemsChanged(oldValue: HTMLElement[], newValue: HTMLElement[]): void;
    // (undocumented)
    protected menuItems: Element[] | undefined;
    // (undocumented)
    protected setItems(): void;
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "FASTMenuItem" because one of its declarations is marked as @internal
//
// @public
export class FASTMenuItem extends FASTElement {
    checked: boolean;
    // (undocumented)
    protected checkedChanged(oldValue: boolean, newValue: boolean): void;
    cleanup: () => void;
    disabled: boolean;
    // @internal (undocumented)
    disconnectedCallback(): void;
    expanded: boolean;
    // (undocumented)
    protected expandedChanged(prev: boolean | undefined, next: boolean): void;
    // @internal (undocumented)
    handleMenuItemClick: (e: MouseEvent) => boolean;
    // @internal (undocumented)
    handleMenuItemKeyDown: (e: KeyboardEvent) => boolean;
    // @internal (undocumented)
    handleMouseOut: (e: MouseEvent) => boolean;
    // @internal (undocumented)
    handleMouseOver: (e: MouseEvent) => boolean;
    // @internal (undocumented)
    get hasSubmenu(): boolean;
    hidden: boolean;
    role: MenuItemRole;
    // @internal
    slottedSubmenu: HTMLElement[];
    // @internal
    protected slottedSubmenuChanged(prev: HTMLElement[] | undefined, next: HTMLElement[]): void;
    // @internal (undocumented)
    submenu: HTMLElement | undefined;
    // @internal
    submenuContainer: HTMLDivElement;
    // @internal (undocumented)
    submenuLoaded: () => void;
    updateSubmenu(): void;
}

// @internal
export interface FASTMenuItem extends StartEnd {
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-forgotten-export) The symbol "FormAssociatedNumberField" needs to be exported by the entry point index.d.ts
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "FASTNumberField" because one of its declarations is marked as @internal
//
// @public
export class FASTNumberField extends FormAssociatedNumberField {
    autofocus: boolean;
    // @internal
    connectedCallback(): void;
    // @internal
    defaultSlottedNodes: Node[];
    // @internal
    field: HTMLInputElement;
    // @internal
    handleBlur(): void;
    // @internal
    handleChange(): void;
    // @internal
    handleKeyDown(e: KeyboardEvent): boolean;
    // @internal
    handleTextInput(): void;
    hideStep: boolean;
    list: string;
    max: number;
    // @internal
    maxChanged(previous: number, next: number): void;
    maxlength: number;
    min: number;
    // @internal
    minChanged(previous: number, next: number): void;
    minlength: number;
    placeholder: string;
    readOnly: boolean;
    select(): void;
    size: number;
    step: number;
    stepDown(): void;
    stepUp(): void;
    validate(): void;
    get valueAsNumber(): number;
    set valueAsNumber(next: number);
    // @internal
    valueChanged(previous: string, next: string): void;
}

// @internal
export interface FASTNumberField extends StartEnd, DelegatesARIATextbox {
}

// Warning: (ae-forgotten-export) The symbol "FormAssociatedPicker" needs to be exported by the entry point index.d.ts
//
// @beta
export class FASTPicker extends FormAssociatedPicker {
    // @internal
    activeListItemTemplate?: ViewTemplate;
    // @internal
    activeMenuOptionTemplate?: ViewTemplate;
    // @internal (undocumented)
    connectedCallback(): void;
    defaultListItemTemplate?: ViewTemplate;
    // (undocumented)
    protected defaultListItemTemplateChanged(): void;
    defaultMenuOptionTemplate?: ViewTemplate;
    // (undocumented)
    protected defaultMenuOptionTemplateChanged(): void;
    // (undocumented)
    disconnectedCallback(): void;
    // @internal
    filteredOptionsList: string[];
    // (undocumented)
    protected filteredOptionsListChanged(): void;
    filterQuery: boolean;
    filterSelected: boolean;
    // @internal
    flyoutOpen: boolean;
    // (undocumented)
    protected flyoutOpenChanged(): void;
    // @public
    focus(): void;
    handleFocusIn(e: FocusEvent): boolean;
    handleFocusOut(e: FocusEvent): boolean;
    handleItemInvoke(e: Event): boolean;
    handleKeyDown(e: KeyboardEvent): boolean;
    handleOptionInvoke(e: Event): boolean;
    handleRegionLoaded(e: Event): void;
    handleSelectionChange(): void;
    // @internal
    inputElement: HTMLInputElement;
    itemsPlaceholderElement: Node;
    label: string;
    labelledBy: string;
    // @internal
    listElement: FASTPickerList;
    listItemContentsTemplate: ViewTemplate;
    listItemTemplate: ViewTemplate;
    // (undocumented)
    protected listItemTemplateChanged(): void;
    loadingText: string;
    maxSelected: number | null;
    // @internal
    menuConfig: AnchoredRegionConfig;
    // @internal
    menuElement: FASTPickerMenu;
    // @internal
    menuFocusIndex: number;
    // @internal
    menuFocusOptionId: string | undefined;
    // @internal
    menuId: string;
    menuOptionContentsTemplate: ViewTemplate;
    menuOptionTemplate: ViewTemplate;
    // (undocumented)
    protected menuOptionTemplateChanged(): void;
    menuPlacement: MenuPlacement;
    // (undocumented)
    protected menuPlacementChanged(): void;
    // @internal
    menuTag: string;
    noSuggestionsText: string;
    options: string;
    // (undocumented)
    protected optionsChanged(): void;
    optionsList: string[];
    placeholder: string;
    query: string;
    // (undocumented)
    protected queryChanged(): void;
    // @internal
    region: FASTAnchoredRegion;
    // @internal (undocumented)
    selectedItems: string[];
    // @internal
    selectedListTag: string;
    selection: string;
    // (undocumented)
    protected selectionChanged(): void;
    showLoading: boolean;
    // (undocumented)
    protected showLoadingChanged(): void;
    // @internal
    showNoOptions: boolean;
    suggestionsAvailableText: string;
}

// @beta
export class FASTPickerList extends FASTElement {
}

// @beta
export class FASTPickerListItem extends FASTElement {
    // @internal (undocumented)
    connectedCallback(): void;
    contentsTemplate: ViewTemplate;
    // (undocumented)
    protected contentsTemplateChanged(): void;
    // @internal (undocumented)
    disconnectedCallback(): void;
    // (undocumented)
    handleClick(e: MouseEvent): boolean;
    // (undocumented)
    handleKeyDown(e: KeyboardEvent): boolean;
    value: string;
}

// @beta
export class FASTPickerMenu extends FASTElement {
    // @internal
    footerElements: HTMLElement[];
    // (undocumented)
    footerElementsChanged(): void;
    // @internal
    headerElements: HTMLElement[];
    // (undocumented)
    headerElementsChanged(): void;
    // @internal
    menuElements: HTMLElement[];
    // (undocumented)
    menuElementsChanged(): void;
    // @internal
    optionElements: HTMLElement[];
    suggestionsAvailableText: string;
}

// @beta
export class FASTPickerMenuOption extends FASTElement {
    // @internal (undocumented)
    connectedCallback(): void;
    contentsTemplate: ViewTemplate;
    // (undocumented)
    protected contentsTemplateChanged(): void;
    // @internal (undocumented)
    disconnectedCallback(): void;
    // (undocumented)
    handleClick(e: MouseEvent): boolean;
    value: string;
}

// @public
export class FASTProgress extends FASTBaseProgress {
}

// @public
export class FASTProgressRing extends FASTBaseProgress {
}

// Warning: (ae-forgotten-export) The symbol "FormAssociatedRadio" needs to be exported by the entry point index.d.ts
//
// @public
export class FASTRadio extends FormAssociatedRadio implements RadioControl {
    constructor();
    // @internal (undocumented)
    connectedCallback(): void;
    // @internal (undocumented)
    defaultCheckedChanged(): void;
    // @internal (undocumented)
    defaultSlottedNodes: Node[];
    // @internal
    initialValue: string;
    // @beta
    keypressHandler(e: KeyboardEvent): boolean | void;
    name: string;
}

// @public
export class FASTRadioGroup extends FASTElement {
    // (undocumented)
    childItems: HTMLElement[];
    // @internal (undocumented)
    clickHandler: (e: MouseEvent) => void | boolean;
    // @internal (undocumented)
    connectedCallback(): void;
    disabled: boolean;
    // (undocumented)
    protected disabledChanged(): void;
    // (undocumented)
    disconnectedCallback(): void;
    // @internal (undocumented)
    focusOutHandler: (e: FocusEvent) => boolean | void;
    // @internal (undocumented)
    handleDisabledClick: (e: MouseEvent) => void | boolean;
    // @internal
    keydownHandler: (e: KeyboardEvent) => boolean | void;
    name: string;
    // (undocumented)
    protected nameChanged(): void;
    orientation: RadioGroupOrientation;
    readOnly: boolean;
    // @internal (undocumented)
    slottedRadioButtons: HTMLElement[];
    // (undocumented)
    protected slottedRadioButtonsChanged(oldValue: unknown, newValue: HTMLElement[]): void;
    value: string;
    // (undocumented)
    protected valueChanged(): void;
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-forgotten-export) The symbol "FormAssociatedSearch" needs to be exported by the entry point index.d.ts
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "FASTSearch" because one of its declarations is marked as @internal
//
// @public
export class FASTSearch extends FormAssociatedSearch {
    autofocus: boolean;
    // (undocumented)
    protected autofocusChanged(): void;
    // @internal (undocumented)
    connectedCallback(): void;
    // @internal (undocumented)
    defaultSlottedNodes: Node[];
    // @internal
    field: HTMLInputElement;
    // @internal
    handleChange(): void;
    handleClearInput(): void;
    // @internal
    handleTextInput(): void;
    list: string;
    // (undocumented)
    protected listChanged(): void;
    maxlength: number;
    // (undocumented)
    protected maxlengthChanged(): void;
    minlength: number;
    // (undocumented)
    protected minlengthChanged(): void;
    pattern: string;
    // (undocumented)
    protected patternChanged(): void;
    placeholder: string;
    // (undocumented)
    protected placeholderChanged(): void;
    readOnly: boolean;
    // (undocumented)
    protected readOnlyChanged(): void;
    size: number;
    // (undocumented)
    protected sizeChanged(): void;
    spellcheck: boolean;
    // (undocumented)
    protected spellcheckChanged(): void;
    validate(): void;
}

// @internal
export interface FASTSearch extends StartEnd, DelegatesARIASearch {
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-forgotten-export) The symbol "FormAssociatedSelect" needs to be exported by the entry point index.d.ts
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "FASTSelect" because one of its declarations is marked as @internal
//
// @public
export class FASTSelect extends FormAssociatedSelect {
    cleanup: () => void;
    // @internal
    clickHandler(e: MouseEvent): boolean | void;
    // @internal
    get collapsible(): boolean;
    // (undocumented)
    connectedCallback(): void;
    // @internal
    control: HTMLElement;
    // @internal
    disabledChanged(prev: boolean, next: boolean): void;
    // (undocumented)
    disconnectedCallback(): void;
    get displayValue(): string;
    // @internal
    focusoutHandler(e: FocusEvent): boolean | void;
    // @internal
    formResetCallback(): void;
    // @internal @override
    handleChange(source: any, propertyName: string): void;
    // @internal
    keydownHandler(e: KeyboardEvent): boolean | void;
    // @internal
    listbox: HTMLDivElement;
    // @internal
    listboxId: string;
    // @internal @override
    mousedownHandler(e: MouseEvent): boolean | void;
    multipleChanged(prev: boolean | undefined, next: boolean): void;
    open: boolean;
    // @internal
    protected openChanged(prev: boolean | undefined, next: boolean): void;
    // @internal
    selectedIndexChanged(prev: number | undefined, next: number): void;
    // @internal @override
    protected selectedOptionsChanged(prev: FASTListboxOption[] | undefined, next: FASTListboxOption[]): void;
    // @internal @override
    protected setDefaultSelectedOption(): void;
    setPositioning(): void;
    // @internal @override
    protected sizeChanged(prev: number | undefined, next: number): void;
    // @internal
    slottedOptionsChanged(prev: Element[] | undefined, next: Element[]): void;
    get value(): string;
    set value(next: string);
}

// @internal (undocumented)
export interface FASTSelect extends StartEnd, DelegatesARIASelect {
}

// @public
export class FASTSkeleton extends FASTElement {
    fill: string;
    pattern: string;
    shape: SkeletonShape;
    shimmer: boolean;
}

// Warning: (ae-forgotten-export) The symbol "FormAssociatedSlider" needs to be exported by the entry point index.d.ts
//
// @public
export class FASTSlider extends FormAssociatedSlider implements SliderConfiguration {
    // @internal
    calculateNewValue(rawValue: number): number;
    // @internal (undocumented)
    connectedCallback(): void;
    decrement(): void;
    // @internal (undocumented)
    direction: Direction;
    // @internal (undocumented)
    disconnectedCallback(): void;
    increment(): void;
    // @internal (undocumented)
    initialValue: string;
    // @internal (undocumented)
    isDragging: boolean;
    // (undocumented)
    protected keypressHandler: (e: KeyboardEvent) => void;
    max: number;
    // (undocumented)
    protected maxChanged(): void;
    min: number;
    // (undocumented)
    protected minChanged(): void;
    mode: SliderMode;
    orientation: Orientation;
    // (undocumented)
    protected orientationChanged(): void;
    // @internal (undocumented)
    position: string;
    readOnly: boolean;
    // (undocumented)
    protected readOnlyChanged(): void;
    step: number | undefined;
    // (undocumented)
    protected stepChanged(): void;
    // @internal (undocumented)
    stepMultiplier: number;
    // @internal (undocumented)
    thumbContainer: HTMLDivElement;
    // @internal (undocumented)
    track: HTMLDivElement;
    // @internal (undocumented)
    trackHeight: number;
    // @internal (undocumented)
    trackLeft: number;
    // @internal (undocumented)
    trackMinHeight: number;
    // @internal (undocumented)
    trackMinWidth: number;
    // @internal (undocumented)
    trackWidth: number;
    get valueAsNumber(): number;
    set valueAsNumber(next: number);
    // @internal (undocumented)
    valueChanged(previous: string, next: string): void;
    valueTextFormatter: (value: string) => string | null;
}

// @public
export class FASTSliderLabel extends FASTElement {
    // @internal (undocumented)
    connectedCallback(): void;
    // @internal (undocumented)
    container: HTMLDivElement;
    disabled: boolean;
    // @internal (undocumented)
    disconnectedCallback(): void;
    // @internal (undocumented)
    handleChange(source: any, propertyName: string): void;
    hideMark: boolean;
    // @deprecated
    orientation: SliderOrientation;
    // @internal (undocumented)
    protected orientationChanged(): void;
    position: string;
    // (undocumented)
    protected positionChanged(): void;
    // @internal (undocumented)
    positionStyle: string;
    // @internal (undocumented)
    sliderDirection: Direction;
    // @internal (undocumented)
    sliderMaxPosition: number;
    // @internal (undocumented)
    sliderMinPosition: number;
}

// Warning: (ae-forgotten-export) The symbol "FormAssociatedSwitch" needs to be exported by the entry point index.d.ts
//
// @public
export class FASTSwitch extends FormAssociatedSwitch {
    constructor();
    // @internal (undocumented)
    clickHandler: (e: MouseEvent) => void;
    // @internal (undocumented)
    defaultSlottedNodes: Node[];
    // @internal
    initialValue: string;
    // @internal (undocumented)
    keypressHandler: (e: KeyboardEvent) => void;
    readOnly: boolean;
    // (undocumented)
    protected readOnlyChanged(): void;
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "FASTTab" because one of its declarations is marked as @internal
//
// @public
export class FASTTab extends FASTElement {
    disabled: boolean;
}

// @internal
export interface FASTTab extends StartEnd {
}

// @public
export class FASTTabPanel extends FASTElement {
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "FASTTabs" because one of its declarations is marked as @internal
//
// @public
export class FASTTabs extends FASTElement {
    activeid: string;
    // @internal (undocumented)
    activeidChanged(oldValue: string, newValue: string): void;
    activetab: HTMLElement;
    adjust(adjustment: number): void;
    // @internal (undocumented)
    connectedCallback(): void;
    orientation: TabsOrientation;
    // @internal (undocumented)
    orientationChanged(): void;
    protected setTabs(): void;
    // @internal (undocumented)
    tabpanels: HTMLElement[];
    // @internal (undocumented)
    tabpanelsChanged(): void;
    // @internal (undocumented)
    tabs: HTMLElement[];
    // @internal (undocumented)
    tabsChanged(): void;
}

// @internal
export interface FASTTabs extends StartEnd {
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-forgotten-export) The symbol "FormAssociatedTextArea" needs to be exported by the entry point index.d.ts
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "FASTTextArea" because one of its declarations is marked as @internal
//
// @public
export class FASTTextArea extends FormAssociatedTextArea {
    autofocus: boolean;
    // (undocumented)
    protected autofocusChanged(): void;
    cols: number;
    // @internal (undocumented)
    defaultSlottedNodes: Node[];
    // @internal
    field: HTMLTextAreaElement;
    formId: string;
    // @internal
    handleChange(): void;
    // @internal (undocumented)
    handleTextInput: () => void;
    list: string;
    // (undocumented)
    protected listChanged(): void;
    maxlength: number;
    // (undocumented)
    protected maxlengthChanged(): void;
    minlength: number;
    // (undocumented)
    protected minlengthChanged(): void;
    name: string;
    placeholder: string;
    readOnly: boolean;
    // (undocumented)
    protected readOnlyChanged(): void;
    resize: TextAreaResize;
    rows: number;
    select(): void;
    spellcheck: boolean;
    // (undocumented)
    protected spellcheckChanged(): void;
    validate(): void;
}

// @internal
export interface FASTTextArea extends StartEnd, DelegatesARIATextbox {
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-forgotten-export) The symbol "FormAssociatedTextField" needs to be exported by the entry point index.d.ts
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "FASTTextField" because one of its declarations is marked as @internal
//
// @public
export class FASTTextField extends FormAssociatedTextField {
    autofocus: boolean;
    // (undocumented)
    protected autofocusChanged(): void;
    // @internal (undocumented)
    connectedCallback(): void;
    // @internal (undocumented)
    defaultSlottedNodes: Node[];
    // @internal
    field: HTMLInputElement;
    // @internal
    handleChange(): void;
    // @internal
    handleTextInput(): void;
    list: string;
    // (undocumented)
    protected listChanged(): void;
    maxlength: number;
    // (undocumented)
    protected maxlengthChanged(): void;
    minlength: number;
    // (undocumented)
    protected minlengthChanged(): void;
    pattern: string;
    // (undocumented)
    protected patternChanged(): void;
    placeholder: string;
    // (undocumented)
    protected placeholderChanged(): void;
    readOnly: boolean;
    // (undocumented)
    protected readOnlyChanged(): void;
    select(): void;
    size: number;
    // (undocumented)
    protected sizeChanged(): void;
    spellcheck: boolean;
    // (undocumented)
    protected spellcheckChanged(): void;
    type: TextFieldType;
    validate(): void;
}

// @internal
export interface FASTTextField extends StartEnd, DelegatesARIATextbox {
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "FASTToolbar" because one of its declarations is marked as @internal
//
// @public
export class FASTToolbar extends FASTElement {
    // @internal
    get activeIndex(): number;
    set activeIndex(value: number);
    // @internal
    protected get allSlottedItems(): (HTMLElement | Node)[];
    // (undocumented)
    childItems: Element[];
    // (undocumented)
    protected childItemsChanged(prev: undefined | Element[], next: Element[]): void;
    // @internal (undocumented)
    connectedCallback(): void;
    // @internal
    direction: Direction;
    // @internal
    focusinHandler(e: FocusEvent): boolean | void;
    // @internal
    keydownHandler(e: KeyboardEvent): boolean | void;
    // @internal
    mouseDownHandler(e: MouseEvent): boolean | void;
    orientation: ToolbarOrientation;
    // @internal
    protected reduceFocusableElements(): void;
    // @internal
    slottedItems: HTMLElement[];
    // (undocumented)
    protected slottedItemsChanged(): void;
    // @internal
    slottedLabel: HTMLElement[];
}

// @internal (undocumented)
export interface FASTToolbar extends StartEnd, DelegatesARIAToolbar {
}

// @public
export class FASTTooltip extends FASTElement {
    anchor: string;
    // @internal
    protected anchorChanged(prev: string | undefined, next: string): void;
    // @internal
    anchorElement: Element | null;
    cleanup: () => void;
    // (undocumented)
    connectedCallback(): void;
    // @internal
    protected controlledVisibilityChanged(prev: boolean | undefined, next: boolean): void;
    // @internal
    protected focusinAnchorHandler: () => void;
    // @internal
    protected focusoutAnchorHandler: () => void;
    // @internal
    hideTooltip(): void;
    id: string;
    // (undocumented)
    idChanged(prev: string, next: string): void;
    placement: TooltipPlacement;
    // @internal
    protected positionStyles: ElementStyles;
    // @internal
    protected positionStylesChanged(prev: ElementStyles | undefined, next: ElementStyles | undefined): void;
    setPositioning(): void;
    show: boolean | undefined;
    // (undocumented)
    showChanged(prev: boolean | undefined, next: boolean | undefined): void;
    get visible(): boolean | undefined;
}

// Warning: (ae-different-release-tags) This symbol has another declaration with a different release tag
// Warning: (ae-internal-mixed-release-tag) Mixed release tags are not allowed for "FASTTreeItem" because one of its declarations is marked as @internal
//
// @public
export class FASTTreeItem extends FASTElement {
    // @internal
    get childItemLength(): number;
    // @internal (undocumented)
    childItems: HTMLElement[];
    disabled: boolean;
    // @internal
    expandCollapseButton: HTMLDivElement;
    expanded: boolean;
    // (undocumented)
    protected expandedChanged(prev: boolean | undefined, next: boolean): void;
    // @internal
    focusable: boolean;
    static focusItem(el: HTMLElement): void;
    // @internal
    handleBlur: (e: FocusEvent) => void;
    // @internal
    handleExpandCollapseButtonClick: (e: MouseEvent) => void;
    // @internal
    handleFocus: (e: FocusEvent) => void;
    readonly isNestedItem: () => boolean;
    // @internal
    readonly isTreeItem: boolean;
    // @internal
    items: HTMLElement[];
    // (undocumented)
    protected itemsChanged(oldValue: unknown, newValue: HTMLElement[]): void;
    // @deprecated
    nested: boolean;
    selected: boolean;
    // (undocumented)
    protected selectedChanged(prev: boolean | undefined, next: boolean): void;
}

// @internal
export interface FASTTreeItem extends StartEnd {
}

// @public
export class FASTTreeView extends FASTElement {
    // (undocumented)
    connectedCallback(): void;
    // @internal
    currentFocused: HTMLElement | FASTTreeItem | null;
    currentSelected: HTMLElement | FASTTreeItem | null;
    // @internal
    handleBlur: (e: FocusEvent) => void;
    // @internal
    handleClick(e: Event): boolean | void;
    // @internal
    handleFocus: (e: FocusEvent) => void;
    // @internal
    handleKeyDown: (e: KeyboardEvent) => boolean | void;
    // @internal
    handleSelectedChange: (e: Event) => boolean | void;
    // @internal
    slottedTreeItems: HTMLElement[];
    // (undocumented)
    protected slottedTreeItemsChanged(): void;
    // @internal
    treeView: HTMLElement;
}

// @public
export const FlipperDirection: {
    readonly next: "next";
    readonly previous: "previous";
};

// @public
export type FlipperDirection = ValuesOf<typeof FlipperDirection>;

// @public
export type FlipperOptions = {
    next?: StaticallyComposableHTML<FASTFlipper>;
    previous?: StaticallyComposableHTML<FASTFlipper>;
};

// @public
export function flipperTemplate<T extends FASTFlipper>(options?: FlipperOptions): ElementViewTemplate<T>;

// @public
export const FlyoutPosBottom: AnchoredRegionConfig;

// @public
export const FlyoutPosBottomFill: AnchoredRegionConfig;

// @public
export const FlyoutPosTallest: AnchoredRegionConfig;

// @public
export const FlyoutPosTallestFill: AnchoredRegionConfig;

// @public
export const FlyoutPosTop: AnchoredRegionConfig;

// @public
export const FlyoutPosTopFill: AnchoredRegionConfig;

// @public @deprecated
export const focusVisible = "focus-visible";

// @public
export const forcedColorsStylesheetBehavior: (styles: ElementStyles) => MatchMediaStyleSheetBehavior;

// @beta
export function FormAssociated<T extends ConstructableFormAssociated>(BaseCtor: T): T;

// Warning: (ae-forgotten-export) The symbol "ElementInternals" needs to be exported by the entry point index.d.ts
//
// @beta
export interface FormAssociated extends Omit<ElementInternals_2, "labels"> {
    // (undocumented)
    attachProxy(): void;
    // (undocumented)
    currentValue: string;
    // (undocumented)
    detachProxy(): void;
    // (undocumented)
    dirtyValue: boolean;
    // (undocumented)
    disabled: boolean;
    // (undocumented)
    disabledChanged?(previous: boolean, next: boolean): void;
    // (undocumented)
    readonly elementInternals: ElementInternals_2 | null;
    // (undocumented)
    readonly formAssociated: boolean;
    // (undocumented)
    formDisabledCallback?(disabled: boolean): void;
    // (undocumented)
    formResetCallback(): void;
    // (undocumented)
    initialValue: string;
    // (undocumented)
    initialValueChanged?(previous: string, next: string): void;
    // (undocumented)
    readonly labels: ReadonlyArray<Node[]>;
    // (undocumented)
    name: string;
    // (undocumented)
    nameChanged?(previous: string, next: string): void;
    // (undocumented)
    required: boolean;
    // (undocumented)
    requiredChanged(prev: boolean, next: boolean): void;
    // (undocumented)
    stopPropagation(e: Event): void;
    validate(anchor?: HTMLElement): void;
    // (undocumented)
    value: string;
    // (undocumented)
    valueChanged(previous: string, next: string): void;
}

// @beta
export type FormAssociatedElement = FormAssociated & FASTElement & HTMLElement & FormAssociatedProxy;

// @beta
export interface FormAssociatedProxy {
    // (undocumented)
    disabledChanged?(previous: boolean, next: boolean): void;
    // (undocumented)
    formDisabledCallback?(disabled: boolean): void;
    // (undocumented)
    formResetCallback?(): void;
    // (undocumented)
    initialValueChanged?(previous: string, next: string): void;
    // (undocumented)
    nameChanged?(previous: string, next: string): void;
    // (undocumented)
    proxy: ProxyElement;
    // (undocumented)
    valueChanged?(previous: string, next: string): void;
}

// @public
export const GenerateHeaderOptions: {
    readonly none: "none";
    readonly default: "default";
    readonly sticky: "sticky";
};

// @public
export type GenerateHeaderOptions = ValuesOf<typeof GenerateHeaderOptions>;

// @public
export const getDirection: (rootNode: HTMLElement) => Direction;

// @public (undocumented)
export function getRootActiveElement(element: Element): Element | null;

// @public
export const hidden = ":host([hidden]){display:none}";

// @public
export const HorizontalPosition: {
    readonly start: "start";
    readonly end: "end";
    readonly left: "left";
    readonly right: "right";
    readonly center: "center";
    readonly unset: "unset";
};

// @public
export type HorizontalPosition = ValuesOf<typeof HorizontalPosition>;

// @public
export type HorizontalScrollOptions = StartEndOptions<FASTHorizontalScroll> & {
    nextFlipper?: StaticallyComposableHTML<FASTHorizontalScroll>;
    previousFlipper?: StaticallyComposableHTML<FASTHorizontalScroll>;
};

// @public (undocumented)
export function horizontalScrollTemplate<T extends FASTHorizontalScroll>(options?: HorizontalScrollOptions): ElementViewTemplate<T>;

// @public
export const HorizontalScrollView: {
    readonly default: "default";
    readonly mobile: "mobile";
};

// @public
export type HorizontalScrollView = ValuesOf<typeof HorizontalScrollView>;

// Warning: (ae-internal-missing-underscore) The name "interactiveCalendarGridTemplate" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal
export function interactiveCalendarGridTemplate<T extends FASTCalendar>(options: CalendarOptions, todayString: string): ViewTemplate<T>;

// @public
export function isListboxOption(el: Element): el is FASTListboxOption;

// @public
export function isTreeItemElement(el: Element): el is HTMLElement;

// @public
export const lightModeStylesheetBehavior: (styles: ElementStyles) => MatchMediaStyleSheetBehavior;

// @public
export type ListboxOptionOptions = StartEndOptions<FASTListboxOption>;

// @public
export function listboxOptionTemplate<T extends FASTListboxOption>(options?: ListboxOptionOptions): ElementViewTemplate<T>;

// @public
export function listboxTemplate<T extends FASTListboxElement>(): ElementViewTemplate<T>;

// @public
export abstract class MatchMediaBehavior implements HostBehavior {
    constructor(query: MediaQueryList);
    connectedCallback(controller: HostController): void;
    protected abstract constructListener(controller: HostController): MediaQueryListListener;
    disconnectedCallback(controller: HostController): void;
    readonly query: MediaQueryList;
}

// @public
export class MatchMediaStyleSheetBehavior extends MatchMediaBehavior {
    constructor(query: MediaQueryList, styles: ElementStyles);
    protected constructListener(controller: HostController): MediaQueryListListener;
    readonly query: MediaQueryList;
    // @internal
    removedCallback(controller: HostController<any>): void;
    readonly styles: ElementStyles;
    static with(query: MediaQueryList): (styles: ElementStyles) => MatchMediaStyleSheetBehavior;
}

// @public
export type MediaQueryListListener = (this: MediaQueryList, ev?: MediaQueryListEvent) => void;

// @public
export type MenuItemOptions = StartEndOptions<FASTMenuItem> & {
    checkboxIndicator?: StaticallyComposableHTML<FASTMenuItem>;
    expandCollapseGlyph?: StaticallyComposableHTML<FASTMenuItem>;
    radioIndicator?: StaticallyComposableHTML<FASTMenuItem>;
};

// @public
export const MenuItemRole: {
    readonly menuitem: "menuitem";
    readonly menuitemcheckbox: "menuitemcheckbox";
    readonly menuitemradio: "menuitemradio";
};

// @public
export type MenuItemRole = ValuesOf<typeof MenuItemRole>;

// @public
export function menuItemTemplate<T extends FASTMenuItem>(options?: MenuItemOptions): ElementViewTemplate<T>;

// @beta
export const MenuPlacement: {
    readonly bottom: "bottom";
    readonly bottomFill: "bottom-fill";
    readonly tallest: "tallest";
    readonly tallestFill: "tallest-fill";
    readonly top: "top";
    readonly topFill: "top-fill";
};

// @beta
export type MenuPlacement = ValuesOf<typeof MenuPlacement>;

// @public
export function menuTemplate<T extends FASTMenu>(): ElementViewTemplate<T>;

// @public
export const MonthFormat: {
    readonly "2-digit": "2-digit";
    readonly numeric: "numeric";
    readonly short: "short";
    readonly long: "long";
    readonly narrow: "narrow";
};

// @public
export type MonthFormat = ValuesOf<typeof MonthFormat>;

// @public
export type MonthInfo = {
    month: number;
    year: number;
    length: number;
    start: number;
};

// Warning: (ae-internal-missing-underscore) The name "noninteractiveCalendarTemplate" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal
export function noninteractiveCalendarTemplate<T extends FASTCalendar>(options: CalendarOptions, todayString: string): ViewTemplate<T>;

// @public
export type NumberFieldOptions = StartEndOptions<FASTNumberField> & {
    stepDownIcon?: StaticallyComposableHTML<FASTNumberField>;
    stepUpIcon?: StaticallyComposableHTML<FASTNumberField>;
};

// @public
export function numberFieldTemplate<T extends FASTNumberField>(options?: NumberFieldOptions): ElementViewTemplate<T>;

// Warning: (ae-incompatible-release-tags) The symbol "pickerListItemTemplate" is marked as @public, but its signature references "FASTPickerListItem" which is marked as @beta
//
// @public (undocumented)
export function pickerListItemTemplate<T extends FASTPickerListItem>(): ElementViewTemplate<T>;

// Warning: (ae-incompatible-release-tags) The symbol "pickerListTemplate" is marked as @public, but its signature references "FASTPickerList" which is marked as @beta
//
// @public (undocumented)
export function pickerListTemplate<T extends FASTPickerList>(): ElementViewTemplate<T>;

// Warning: (ae-incompatible-release-tags) The symbol "pickerMenuOptionTemplate" is marked as @public, but its signature references "FASTPickerMenuOption" which is marked as @beta
//
// @public (undocumented)
export function pickerMenuOptionTemplate<T extends FASTPickerMenuOption>(): ElementViewTemplate<T>;

// Warning: (ae-incompatible-release-tags) The symbol "pickerMenuTemplate" is marked as @public, but its signature references "FASTPickerMenu" which is marked as @beta
//
// @public
export function pickerMenuTemplate<T extends FASTPickerMenu>(): ElementViewTemplate<T>;

// @public
export type PickerOptions = {
    anchoredRegion: TemplateElementDependency;
    pickerMenu: TemplateElementDependency;
    pickerMenuOption: TemplateElementDependency;
    pickerList: TemplateElementDependency;
    pickerListItem: TemplateElementDependency;
    progressRing: TemplateElementDependency;
};

// Warning: (ae-incompatible-release-tags) The symbol "pickerTemplate" is marked as @public, but its signature references "FASTPicker" which is marked as @beta
//
// @public
export function pickerTemplate<T extends FASTPicker>(options: PickerOptions): ElementViewTemplate<T>;

// @public
export type ProgressOptions = {
    indeterminateIndicator1?: StaticallyComposableHTML<FASTProgress>;
    indeterminateIndicator2?: StaticallyComposableHTML<FASTProgress>;
};

// @public
export type ProgressRingOptions = {
    indeterminateIndicator?: StaticallyComposableHTML<FASTProgressRing>;
};

// @public
export function progressRingTemplate<T extends FASTProgressRing>(options?: ProgressRingOptions): ElementViewTemplate<T>;

// @public
export function progressTemplate<T extends FASTProgress>(options?: ProgressOptions): ElementViewTemplate<T>;

// @public
export class PropertyStyleSheetBehavior implements HostBehavior {
    constructor(propertyName: string, value: any, styles: ElementStyles);
    addedCallback(controller: HostController): void;
    // @internal
    handleChange(source: FASTElement, key: string): void;
    removedCallback(controller: HostController): void;
}

// @public
export interface PropertyTarget {
    // (undocumented)
    removeProperty(name: string): void;
    // (undocumented)
    setProperty(name: string, value: string): void;
}

// @beta
export type ProxyElement = HTMLSelectElement | HTMLTextAreaElement | HTMLInputElement;

// @public
export type RadioControl = Pick<HTMLInputElement, "checked" | "disabled" | "focus" | "setAttribute" | "getAttribute">;

// @public
export const RadioGroupOrientation: {
    readonly horizontal: "horizontal";
    readonly vertical: "vertical";
};

// @public
export type RadioGroupOrientation = ValuesOf<typeof RadioGroupOrientation>;

// @public
export function radioGroupTemplate<T extends FASTRadioGroup>(): ElementViewTemplate<T>;

// @public
export type RadioOptions = {
    checkedIndicator?: StaticallyComposableHTML<FASTRadio>;
};

// @public
export function radioTemplate<T extends FASTRadio>(options?: RadioOptions): ElementViewTemplate<T>;

// @beta
export function reflectAttributes<TSource = any, TParent = any>(...attributes: string[]): CaptureType<TSource, TParent>;

// Warning: (ae-internal-missing-underscore) The name "roleForMenuItem" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal (undocumented)
export const roleForMenuItem: {
    [value in keyof typeof MenuItemRole]: (typeof MenuItemRole)[value];
};

// @public
export const ScrollEasing: {
    readonly linear: "linear";
    readonly easeIn: "ease-in";
    readonly easeOut: "ease-out";
    readonly easeInOut: "ease-in-out";
};

// @public
export type ScrollEasing = ValuesOf<typeof ScrollEasing>;

// @public
export type SearchOptions = StartEndOptions<FASTSearch> & {
    clearIcon?: StaticallyComposableHTML<FASTSearch>;
};

// @public
export function searchTemplate<T extends FASTSearch>(options?: SearchOptions): ElementViewTemplate<T>;

// @public
export type SelectOptions = StartEndOptions<FASTSelect> & {
    indicator?: StaticallyComposableHTML<FASTSelect>;
};

// @public
export function selectTemplate<T extends FASTSelect>(options?: SelectOptions): ElementViewTemplate<T>;

// @public
export const SkeletonShape: {
    readonly rect: "rect";
    readonly circle: "circle";
};

// @public (undocumented)
export type SkeletonShape = ValuesOf<typeof SkeletonShape>;

// @public
export function skeletonTemplate<T extends FASTSkeleton>(): ElementViewTemplate<T>;

// @public
export interface SliderConfiguration {
    // (undocumented)
    direction?: Direction;
    // (undocumented)
    disabled?: boolean;
    // (undocumented)
    max: number;
    // (undocumented)
    min: number;
    // (undocumented)
    orientation?: SliderOrientation;
}

// @public
export function sliderLabelTemplate<T extends FASTSliderLabel>(): ElementViewTemplate<T>;

// @public
export const SliderMode: {
    readonly singleValue: "single-value";
};

// @public
export type SliderMode = ValuesOf<typeof SliderMode>;

// @public
export type SliderOptions = {
    thumb?: StaticallyComposableHTML<FASTSlider>;
};

// @public
export const SliderOrientation: {
    readonly horizontal: "horizontal";
    readonly vertical: "vertical";
};

// @public
export type SliderOrientation = ValuesOf<typeof SliderOrientation>;

// @public
export function sliderTemplate<T extends FASTSlider>(options?: SliderOptions): ElementViewTemplate<T>;

// @public
export class StartEnd {
    // (undocumented)
    end: HTMLSlotElement;
    // (undocumented)
    start: HTMLSlotElement;
}

// @public
export type StartEndOptions<TSource = any, TParent = any> = StartOptions<TSource, TParent> & EndOptions<TSource, TParent>;

// @public
export type StartOptions<TSource = any, TParent = any> = {
    start?: StaticallyComposableHTML<TSource, TParent>;
};

// @public
export function startSlotTemplate<TSource extends StartEnd = StartEnd, TParent = any>(options: StartOptions<TSource, TParent>): CaptureType<TSource, TParent>;

// @public
export type StaticallyComposableHTML<TSource = any, TParent = any> = string | HTMLDirective | SyntheticViewTemplate<TSource, TParent> | undefined;

// @public
export function staticallyCompose<TSource = any, TParent = any>(item: StaticallyComposableHTML<TSource, TParent>): CaptureType<TSource, TParent>;

// @public
export type StaticDesignTokenValue<T> = T extends (...args: any[]) => any ? DerivedDesignTokenValue<T> : T;

// @alpha (undocumented)
export const supportsElementInternals: boolean;

// @public
export type SwitchOptions = {
    thumb?: StaticallyComposableHTML<FASTSwitch>;
};

// @public
export function switchTemplate<T extends FASTSwitch>(options?: SwitchOptions): ElementViewTemplate<T>;

// @public
export type TabOptions = StartEndOptions<FASTTab>;

// @public
export function tabPanelTemplate<T extends FASTTabPanel>(): ElementViewTemplate<T>;

// @public
export type TabsOptions = StartEndOptions<FASTTabs>;

// @public
export const TabsOrientation: {
    readonly horizontal: "horizontal";
    readonly vertical: "vertical";
};

// @public
export type TabsOrientation = ValuesOf<typeof TabsOrientation>;

// @public
export function tabsTemplate<T extends FASTTabs>(options?: TabsOptions): ElementViewTemplate<T>;

// @public
export function tabTemplate<T extends FASTTab>(options?: TabOptions): ElementViewTemplate<T>;

// @beta
export function tagFor(dependency: TemplateElementDependency): string;

// @beta
export type TemplateElementDependency = string | FASTElementDefinition | Constructable<FASTElement>;

// @public
export type TextAreaOptions = StartEndOptions;

// @public
export const TextAreaResize: {
    readonly none: "none";
    readonly both: "both";
    readonly horizontal: "horizontal";
    readonly vertical: "vertical";
};

// @public
export type TextAreaResize = ValuesOf<typeof TextAreaResize>;

// @public
export function textAreaTemplate<T extends FASTTextArea>(options?: TextAreaOptions): ElementViewTemplate<T>;

// @public
export type TextFieldOptions = StartEndOptions<FASTTextField>;

// @public
export function textFieldTemplate<T extends FASTTextField>(options?: TextFieldOptions): ElementViewTemplate<T>;

// @public
export const TextFieldType: {
    readonly email: "email";
    readonly password: "password";
    readonly tel: "tel";
    readonly text: "text";
    readonly url: "url";
};

// @public
export type TextFieldType = ValuesOf<typeof TextFieldType>;

// @public
export type ToolbarOptions = StartEndOptions<FASTToolbar>;

// @public
export const ToolbarOrientation: {
    readonly horizontal: "horizontal";
    readonly vertical: "vertical";
};

// @public
export type ToolbarOrientation = ValuesOf<typeof ToolbarOrientation>;

// @public
export function toolbarTemplate<T extends FASTToolbar>(options?: ToolbarOptions): ElementViewTemplate<T>;

// @public
export const TooltipPlacement: {
    readonly bottom: "bottom";
    readonly bottomEnd: "bottom-end";
    readonly bottomStart: "bottom-start";
    readonly left: "left";
    readonly leftEnd: "left-end";
    readonly leftStart: "left-start";
    readonly right: "right";
    readonly rightEnd: "right-end";
    readonly rightStart: "right-start";
    readonly top: "top";
    readonly topEnd: "top-end";
    readonly topStart: "top-start";
};

// @public
export type TooltipPlacement = ValuesOf<typeof TooltipPlacement>;

// @public
export function tooltipTemplate<T extends FASTTooltip>(): ElementViewTemplate<T>;

// @public
export type TreeItemOptions = StartEndOptions<FASTTreeItem> & {
    expandCollapseGlyph?: StaticallyComposableHTML<FASTTreeItem>;
};

// @public
export function treeItemTemplate<T extends FASTTreeItem>(options?: TreeItemOptions): ElementViewTemplate<T>;

// @public
export function treeViewTemplate<T extends FASTTreeView>(): ElementViewTemplate<T>;

// @public
export type ValuesOf<T> = T[keyof T];

// @public
export const VerticalPosition: {
    readonly top: "top";
    readonly bottom: "bottom";
    readonly center: "center";
    readonly unset: "unset";
};

// @public
export type VerticalPosition = ValuesOf<typeof VerticalPosition>;

// @public
export const WeekdayFormat: {
    readonly long: "long";
    readonly narrow: "narrow";
    readonly short: "short";
};

// @public
export type WeekdayFormat = ValuesOf<typeof WeekdayFormat>;

// @public
export type WeekdayText = {
    text: string;
    abbr?: string;
};

// @public
export const whitespaceFilter: ElementsFilter;

// @public
export const YearFormat: {
    readonly "2-digit": "2-digit";
    readonly numeric: "numeric";
};

// @public
export type YearFormat = ValuesOf<typeof YearFormat>;

// Warnings were encountered during analysis:
//
// dist/dts/calendar/calendar.d.ts:51:5 - (ae-incompatible-release-tags) The symbol "dataGridCell" is marked as @public, but its signature references "TemplateElementDependency" which is marked as @beta
// dist/dts/calendar/calendar.d.ts:52:5 - (ae-incompatible-release-tags) The symbol "dataGridRow" is marked as @public, but its signature references "TemplateElementDependency" which is marked as @beta
// dist/dts/calendar/calendar.d.ts:53:5 - (ae-incompatible-release-tags) The symbol "dataGrid" is marked as @public, but its signature references "TemplateElementDependency" which is marked as @beta
// dist/dts/data-grid/data-grid-row.template.d.ts:9:5 - (ae-incompatible-release-tags) The symbol "dataGridCell" is marked as @public, but its signature references "TemplateElementDependency" which is marked as @beta
// dist/dts/data-grid/data-grid.template.d.ts:9:5 - (ae-incompatible-release-tags) The symbol "dataGridRow" is marked as @public, but its signature references "TemplateElementDependency" which is marked as @beta
// dist/dts/picker/picker.template.d.ts:9:5 - (ae-incompatible-release-tags) The symbol "anchoredRegion" is marked as @public, but its signature references "TemplateElementDependency" which is marked as @beta
// dist/dts/picker/picker.template.d.ts:10:5 - (ae-incompatible-release-tags) The symbol "pickerMenu" is marked as @public, but its signature references "TemplateElementDependency" which is marked as @beta
// dist/dts/picker/picker.template.d.ts:11:5 - (ae-incompatible-release-tags) The symbol "pickerMenuOption" is marked as @public, but its signature references "TemplateElementDependency" which is marked as @beta
// dist/dts/picker/picker.template.d.ts:12:5 - (ae-incompatible-release-tags) The symbol "pickerList" is marked as @public, but its signature references "TemplateElementDependency" which is marked as @beta
// dist/dts/picker/picker.template.d.ts:13:5 - (ae-incompatible-release-tags) The symbol "pickerListItem" is marked as @public, but its signature references "TemplateElementDependency" which is marked as @beta
// dist/dts/picker/picker.template.d.ts:14:5 - (ae-incompatible-release-tags) The symbol "progressRing" is marked as @public, but its signature references "TemplateElementDependency" which is marked as @beta

// (No @packageDocumentation comment for this package)

```
