// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Geom_AxisPlacement_HeaderFile
#define _Geom_AxisPlacement_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_Geom_AxisPlacement_HeaderFile
#include <Handle_Geom_AxisPlacement.hxx>
#endif

#ifndef _gp_Ax1_HeaderFile
#include <gp_Ax1.hxx>
#endif
#ifndef _Geom_Geometry_HeaderFile
#include <Geom_Geometry.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Standard_ConstructionError;
class gp_Ax1;
class gp_Dir;
class gp_Pnt;


//! The abstract class AxisPlacement describes the <br>
//! common behavior of positioning systems in 3D space, <br>
//! such as axis or coordinate systems. <br>
//! The Geom package provides two implementations of <br>
//! 3D positioning systems: <br>
//! - the axis (Geom_Axis1Placement class), which is defined by: <br>
//!   - its origin, also termed the "Location point" of the  axis, <br>
//!   - its unit vector, termed the "Direction" or "main <br>
//!    Direction" of the axis; <br>
//! - the right-handed coordinate system <br>
//!   (Geom_Axis2Placement class), which is defined by: <br>
//! - its origin, also termed the "Location point" of the coordinate system, <br>
//! - three orthogonal unit vectors, termed <br>
//!    respectively the "X Direction", the "Y Direction" <br>
//!    and the "Direction" of the coordinate system. As <br>
//!    the coordinate system is right-handed, these <br>
//!    unit vectors have the following relation: <br>
//!    "Direction" = "X Direction" ^ <br>
//!    "Y Direction". The "Direction" is also <br>
//!    called the "main Direction" because, when the <br>
//!    unit vector is modified, the "X Direction" and "Y <br>
//!    Direction" are recomputed, whereas when the "X <br>
//!    Direction" or "Y Direction" is modified, the "main Direction" does not change. <br>
//!     The axis whose origin is the origin of the positioning <br>
//! system and whose unit vector is its "main Direction" is <br>
//! also called the "Axis" or "main Axis" of the positioning system. <br>
class Geom_AxisPlacement : public Geom_Geometry {

public:

  //! Assigns A1 as the "main Axis" of this positioning system. This modifies <br>
//! - its origin, and <br>
//! - its "main Direction". <br>
//!  If this positioning system is a <br>
//! Geom_Axis2Placement, then its "X Direction" and <br>
//! "Y Direction" are recomputed. <br>
//! Exceptions <br>
//! For a Geom_Axis2Placement: <br>
//! Standard_ConstructionError if A1 and the <br>
//! previous "X Direction" of the coordinate system are parallel. <br>
  Standard_EXPORT     void SetAxis(const gp_Ax1& A1) ;
  
//!  Changes the direction of the axis placement. <br>
//!  If <me> is an axis placement two axis the main "Direction" <br>
//!  is modified and the "XDirection" and "YDirection" are <br>
//!  recomputed. <br>
//!    Raises ConstructionError only for an axis placement two axis if V and the <br>
//!  previous "XDirection" are parallel because it is not possible <br>
//!  to calculate the new "XDirection" and the new "YDirection". <br>
  Standard_EXPORT   virtual  void SetDirection(const gp_Dir& V)  = 0;
  
//!  Assigns the point P as the origin of this positioning  system. <br>
  Standard_EXPORT     void SetLocation(const gp_Pnt& P) ;
  //! Computes the angular value, in radians, between the <br>
//! "main Direction" of this positioning system and that <br>
//! of positioning system Other. The result is a value between 0 and Pi. <br>
  Standard_EXPORT     Standard_Real Angle(const Handle(Geom_AxisPlacement)& Other) const;
  //! Returns the main axis of the axis placement. <br>
//!  For an "Axis2placement" it is the main axis (Location, Direction ). <br>
//!  For an "Axis1Placement" this method returns a copy of <me>. <br>
  Standard_EXPORT    const gp_Ax1& Axis() const;
  
//!  Returns the main "Direction" of an axis placement. <br>
  Standard_EXPORT     gp_Dir Direction() const;
  
//!  Returns the Location point (origin) of the axis placement. <br>
  Standard_EXPORT     gp_Pnt Location() const;




  DEFINE_STANDARD_RTTI(Geom_AxisPlacement)

protected:


gp_Ax1 axis;


private: 




};





// other Inline functions and methods (like "C++: function call" methods)


#endif
