// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _StepData_StepModel_HeaderFile
#define _StepData_StepModel_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_StepData_StepModel.hxx>

#include <Interface_EntityList.hxx>
#include <Handle_TColStd_HArray1OfInteger.hxx>
#include <Interface_InterfaceModel.hxx>
#include <Handle_Standard_Transient.hxx>
#include <Standard_Integer.hxx>
#include <Handle_Interface_InterfaceModel.hxx>
#include <Standard_Boolean.hxx>
#include <Handle_Standard_Type.hxx>
#include <Handle_Interface_Check.hxx>
#include <Handle_Message_Messenger.hxx>
#include <Handle_TCollection_HAsciiString.hxx>
class TColStd_HArray1OfInteger;
class Standard_NoSuchObject;
class Standard_Transient;
class Interface_InterfaceModel;
class Interface_EntityIterator;
class Standard_Type;
class Interface_Check;
class Message_Messenger;
class TCollection_HAsciiString;


//! Gives access to
//! - entities in a STEP file,
//! - the STEP file header.
class StepData_StepModel : public Interface_InterfaceModel
{

public:

  
  //! Creates an empty STEP model with an empty header.
  Standard_EXPORT StepData_StepModel();
  
  //! returns entity given its rank.
  //! Same as InterfaceEntity, but with a shorter name
  Standard_EXPORT   Handle(Standard_Transient) Entity (const Standard_Integer num)  const;
  
  //! gets header from another Model (uses Header Protocol)
  Standard_EXPORT   void GetFromAnother (const Handle(Interface_InterfaceModel)& other) ;
  
  //! Returns a New Empty Model, same type as <me>, i.e. StepModel
  Standard_EXPORT   Handle(Interface_InterfaceModel) NewEmptyModel()  const;
  
  //! returns Header entities under the form of an iterator
  Standard_EXPORT   Interface_EntityIterator Header()  const;
  
  //! says if a Header entity has a specifed type
  Standard_EXPORT   Standard_Boolean HasHeaderEntity (const Handle(Standard_Type)& atype)  const;
  
  //! Returns Header entity with specified type, if there is
  Standard_EXPORT   Handle(Standard_Transient) HeaderEntity (const Handle(Standard_Type)& atype)  const;
  
  //! Clears the Header
  Standard_EXPORT   void ClearHeader() ;
  
  //! Adds an Entity to the Header
  Standard_EXPORT   void AddHeaderEntity (const Handle(Standard_Transient)& ent) ;
  
  //! Specific Check, checks Header Items with HeaderProtocol
  Standard_EXPORT virtual   void VerifyCheck (Handle(Interface_Check)& ach)  const;
  
  //! Dumps the Header, with the Header Protocol of StepData.
  //! If the Header Protocol is not defined, for each Header Entity,
  //! prints its Type. Else sends the Header under the form of
  //! HEADER Section of an Ascii Step File
  //! <level> is not used because Header is not so big
  Standard_EXPORT   void DumpHeader (const Handle(Message_Messenger)& S, const Standard_Integer level = 0)  const;
  
  //! erases specific labels, i.e. clears the map (entity-ident)
  Standard_EXPORT   void ClearLabels() ;
  
  //! Attaches an ident to an entity to produce a label
  //! (does nothing if <ent> is not in <me>)
  Standard_EXPORT   void SetIdentLabel (const Handle(Standard_Transient)& ent, const Standard_Integer ident) ;
  
  //! returns the label ident attached to an entity, 0 if not in me
  Standard_EXPORT   Standard_Integer IdentLabel (const Handle(Standard_Transient)& ent)  const;
  
  //! Prints label specific to STEP norm for a given entity, i.e.
  //! if a LabelIdent has been recorded, its value with '#', else
  //! the number in the model with '#' and between ()
  Standard_EXPORT   void PrintLabel (const Handle(Standard_Transient)& ent, const Handle(Message_Messenger)& S)  const;
  
  //! Returns a string with the label attached to a given entity,
  //! same form as for PrintLabel
  Standard_EXPORT   Handle(TCollection_HAsciiString) StringLabel (const Handle(Standard_Transient)& ent)  const;




  DEFINE_STANDARD_RTTI(StepData_StepModel)

protected:




private: 


  Interface_EntityList theheader;
  Handle(TColStd_HArray1OfInteger) theidnums;


};







#endif // _StepData_StepModel_HeaderFile
