// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Voxel_Reader_HeaderFile
#define _Voxel_Reader_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Standard_Address.hxx>
#include <Standard_Boolean.hxx>
class TCollection_ExtendedString;


//! Reads a cube of voxels from disk.
//! Beware, a caller of the reader is responsible for deletion of the read voxels.
class Voxel_Reader 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! An empty constructor.
  Standard_EXPORT Voxel_Reader();
  
  //! Reads the voxels from disk
  Standard_EXPORT   Standard_Boolean Read (const TCollection_ExtendedString& file) ;
  
  //! Informs the user about the type of voxels he has read.
  Standard_EXPORT   Standard_Boolean IsBoolVoxels()  const;
  
  //! Informs the user about the type of voxels he has read.
  Standard_EXPORT   Standard_Boolean IsColorVoxels()  const;
  
  //! Informs the user about the type of voxels he has read.
  Standard_EXPORT   Standard_Boolean IsFloatVoxels()  const;
  
  //! Returns a pointer to the read 1bit voxels.
  Standard_EXPORT   Standard_Address GetBoolVoxels()  const;
  
  //! Returns a pointer to the read 4bit voxels.
  Standard_EXPORT   Standard_Address GetColorVoxels()  const;
  
  //! Returns a pointer to the read 4bytes voxels.
  Standard_EXPORT   Standard_Address GetFloatVoxels()  const;




protected:





private:

  
  //! Reads 1bit voxels from disk in ASCII format.
  Standard_EXPORT   Standard_Boolean ReadBoolAsciiVoxels (const TCollection_ExtendedString& file) ;
  
  //! Reads 4bit voxels from disk in ASCII format.
  Standard_EXPORT   Standard_Boolean ReadColorAsciiVoxels (const TCollection_ExtendedString& file) ;
  
  //! Reads 4bytes voxels from disk in ASCII format.
  Standard_EXPORT   Standard_Boolean ReadFloatAsciiVoxels (const TCollection_ExtendedString& file) ;
  
  //! Reads 1bit voxels from disk in BINARY format.
  Standard_EXPORT   Standard_Boolean ReadBoolBinaryVoxels (const TCollection_ExtendedString& file) ;
  
  //! Reads 4bit voxels from disk in BINARY format.
  Standard_EXPORT   Standard_Boolean ReadColorBinaryVoxels (const TCollection_ExtendedString& file) ;
  
  //! Reads 4bytes voxels from disk in BINARY format.
  Standard_EXPORT   Standard_Boolean ReadFloatBinaryVoxels (const TCollection_ExtendedString& file) ;


  Standard_Address myBoolVoxels;
  Standard_Address myColorVoxels;
  Standard_Address myFloatVoxels;


};







#endif // _Voxel_Reader_HeaderFile
