#!/bin/bash

#################################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
#################################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_SSHServiceAccessBySAP.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_SSHServiceAccessBySAP provider module";
Name = "SSH_OpenDRIM_SSHServiceAccessBySAPModule";
Location = "cmpiSSH_OpenDRIM_SSHServiceAccessBySAPProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_SSHServiceAccessBySAP provider";
Name = "SSH_OpenDRIM_SSHServiceAccessBySAPProvider";
ProviderModuleName = "SSH_OpenDRIM_SSHServiceAccessBySAPModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_SSHServiceAccessBySAP provider capabilities";
ProviderModuleName = "SSH_OpenDRIM_SSHServiceAccessBySAPModule";
ProviderName = "SSH_OpenDRIM_SSHServiceAccessBySAPProvider";
ClassName = "OpenDRIM_SSHServiceAccessBySAP";
ProviderType = {2, 3};
Namespaces = {"$1"};
SupportedProperties = {"Antecedent", "Dependent"};
CapabilityID = "SSH_OpenDRIM_SSHServiceAccessBySAP";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_SSHServiceAccessBySAP.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_SSHServiceAccessBySAP]   
   provider: SSH_OpenDRIM_SSHServiceAccessBySAPProvider
   location: cmpiSSH_OpenDRIM_SSHServiceAccessBySAPProvider
   type: instance association
   namespace: $1
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_SSHServiceAccessBySAP.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_SSHServiceAccessBySAP-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_SSHServiceAccessBySAP.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	
	rm -f $OUTFILE
	
fi
