<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">

<xsl:template match="/">
	<xsl:apply-templates select="report"/>
</xsl:template>

<xsl:template match="report">
	<document filename="example_5.pdf">
	<template pageSize="21cm,29.7cm" leftMargin="1.5cm" rightMargin="1.5cm" topMargin="1.5cm" bottomMargin="1.5cm" title="Bordereau acheteur" author="Generated by Open ERP, Fabien Pinckaers" allowSplitting="20">
		<pageTemplate id="main">
			<pageGraphics>
				<fill color="(0.4,0.4,0.4)"/>
				<stroke color="(0.4,0.4,0.4)"/>
				<setFont name="Helvetica" size="8"/>
				<drawString x="1.8cm" y="1.4cm"><xsl:value-of select="auction/name"/></drawString>
				<drawRightString x="19.2cm" y="1.4cm"><xsl:value-of select="auction/date-au1"/></drawRightString>
				<lineMode width="0.2mm"/>
				<lines>1.8cm 1.8cm 19.2cm 1.8cm</lines>
			</pageGraphics>
			<frame id="colmnOne" x1="1.8cm" y1="1.8cm" width="17.4cm" height="26.6cm"/>
		</pageTemplate>
	</template>
	<stylesheet>
		<paraStyle name="name" fontName="Helvetica-Bold" fontSize="16" alignment="center"/>
		<blockTableStyle id="result">
			 <blockValign value="TOP"/>
			 <blockAlignment value="RIGHT" start="-1,0" stop="-1,-1"/>
			 <blockFont name="Helvetica-BoldOblique" size="12" start="0,0" stop="-1,0"/>
			 <blockBackground colorName="grey" start="0,0" stop="-1,0"/>
			 <blockTextColor colorName="white" start="0,0" stop="-1,0"/>
		</blockTableStyle>
	</stylesheet>
	<story>
		<blockTable colWidths="1.5cm,1.5cm,6.9cm,5cm,2cm" style="result">
		<tr>
			<td t="1">Num</td>
			<td t="1">Ref.</td>
			<td t="1">Description</td>
			<td t="1">Adjudication</td>
			<td t="1">Price</td>
		</tr>
			<xsl:apply-templates select="object"/>
		</blockTable>
	</story>
	</document>
</xsl:template>

<xsl:template match="object">
	<tr>
		<td><para><xsl:value-of select="number"/></para></td>
		<td><para><xsl:value-of select="obj_num"/></para></td>
		<td><para><xsl:value-of select="lot_desc"/></para></td>
		<td><para><xsl:value-of select="price"/></para></td>
		<td><xsl:value-of select="obj_price"/></td>
	</tr>
</xsl:template>

</xsl:stylesheet>
